/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai;

import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.ai.MoveBehaviour;
import com.cobblemon.mod.common.pokemon.ai.OmniPathNodeMaker;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1409;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u0012\u0006\u0010/\u001a\u00020.\u00a2\u0006\u0004\b6\u00107J\u000f\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\b\u0010\u0004J\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0013J\r\u0010\u0018\u001a\u00020\t\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010 \u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\"\u0010\u0007J\u000f\u0010#\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b#\u0010\u0004R\"\u0010$\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010\u0007\"\u0004\b'\u0010(R\u0017\u0010*\u001a\u00020)8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010/\u001a\u00020.8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u00103\u001a\u0004\b4\u00105\u00a8\u00068"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/PokemonNavigation;", "Lnet/minecraft/class_1409;", "", "adjustPath", "()V", "", "canSwim", "()Z", "continueFollowingPath", "", "range", "Lnet/minecraft/class_13;", "createPathNodeNavigator", "(I)Lnet/minecraft/class_13;", "Lnet/minecraft/class_2338;", "target", "distance", "Lnet/minecraft/class_11;", "findPath", "(Lnet/minecraft/class_2338;I)Lnet/minecraft/class_11;", "Lnet/minecraft/class_1297;", "entity", "findPathTo", "(Lnet/minecraft/class_1297;I)Lnet/minecraft/class_11;", "getPathfindingY", "()I", "Lnet/minecraft/class_243;", "getPos", "()Lnet/minecraft/class_243;", "Lnet/minecraft/class_1937;", "world", "pos", "isAirborne", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Z", "isAtValidPosition", "tick", "checked", "Z", "getChecked", "setChecked", "(Z)V", "Lcom/cobblemon/mod/common/pokemon/ai/MoveBehaviour;", "moving", "Lcom/cobblemon/mod/common/pokemon/ai/MoveBehaviour;", "getMoving", "()Lcom/cobblemon/mod/common/pokemon/ai/MoveBehaviour;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getPokemonEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lnet/minecraft/class_1937;", "getWorld", "()Lnet/minecraft/class_1937;", "<init>", "(Lnet/minecraft/class_1937;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "common"})
public final class PokemonNavigation
extends class_1409 {
    @NotNull
    private final class_1937 world;
    @NotNull
    private final PokemonEntity pokemonEntity;
    @NotNull
    private final MoveBehaviour moving;
    private boolean checked;

    public PokemonNavigation(@NotNull class_1937 world, @NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pokemonEntity, "pokemonEntity");
        super((class_1308)pokemonEntity, world);
        this.world = world;
        this.pokemonEntity = pokemonEntity;
        this.moving = this.pokemonEntity.getBehaviour().getMoving();
    }

    @NotNull
    public final class_1937 getWorld() {
        return this.world;
    }

    @NotNull
    public final PokemonEntity getPokemonEntity() {
        return this.pokemonEntity;
    }

    @NotNull
    public final MoveBehaviour getMoving() {
        return this.moving;
    }

    @NotNull
    protected class_13 method_6336(int range) {
        this.field_6678 = new OmniPathNodeMaker();
        this.field_6678.method_15(true);
        return new class_13(this.field_6678, range);
    }

    protected boolean method_6358() {
        class_1937 class_19372 = this.field_6684.field_6002;
        Intrinsics.checkNotNullExpressionValue(class_19372, "entity.world");
        class_1922 class_19222 = (class_1922)class_19372;
        class_238 class_2384 = this.field_6684.method_5829();
        Intrinsics.checkNotNullExpressionValue(class_2384, "entity.boundingBox");
        boolean isTouchingLava = WorldExtensionsKt.getWaterAndLavaIn(class_19222, class_2384).component2();
        boolean isAtValidPosition = !this.field_6684.method_5771() && !this.field_6684.method_5777(class_3486.field_15518) || isTouchingLava && this.moving.getSwim().getCanSwimInLava() || this.field_6684.method_5765();
        return isAtValidPosition;
    }

    public boolean method_6350() {
        return this.moving.getSwim().getCanSwimInWater();
    }

    @NotNull
    protected class_243 method_6347() {
        return new class_243(this.field_6684.method_23317(), (double)this.getPathfindingY(), this.field_6684.method_23321());
    }

    protected void method_6339() {
        class_243 vec3d;
        block3: {
            block2: {
                boolean bl;
                vec3d = this.method_6347();
                this.field_6683 = this.field_6684.method_17681() > 0.75f ? this.field_6684.method_17681() / 2.0f : 0.75f - this.field_6684.method_17681() / 2.0f;
                class_11 class_112 = this.field_6681;
                Intrinsics.checkNotNull(class_112);
                class_243 targetVec3d = class_112.method_49((class_1297)this.field_6684);
                double d = Math.abs(this.field_6684.method_23317() - targetVec3d.field_1352);
                double e = Math.abs(this.field_6684.method_23318() - targetVec3d.field_1351);
                double f = Math.abs(this.field_6684.method_23321() - targetVec3d.field_1350);
                boolean bl2 = bl = d < (double)this.field_6683 && f < (double)this.field_6683 && e < 1.0;
                if (bl) break block2;
                class_11 class_113 = this.field_6681;
                Intrinsics.checkNotNull(class_113);
                if (!this.field_6684.method_29244(class_113.method_29301().field_41) || !this.method_27799(vec3d)) break block3;
            }
            class_11 class_114 = this.field_6681;
            Intrinsics.checkNotNull(class_114);
            class_114.method_44();
        }
        this.method_6346(vec3d);
    }

    public final boolean isAirborne(@NotNull class_1937 world, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        return world.method_8320(pos).method_26171((class_1922)world, pos, class_10.field_51) && world.method_8320(pos.method_10087(1)).method_26171((class_1922)world, pos.method_10087(1), class_10.field_51) && world.method_8320(pos.method_10087(2)).method_26171((class_1922)world, pos.method_10087(2), class_10.field_51);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void method_6360() {
        super.method_6360();
        class_11 currentPath = this.method_6345();
        class_9 node = currentPath == null || currentPath.method_46() ? null : currentPath.method_30850();
        boolean isFlying = this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING);
        boolean canWalk = this.pokemonEntity.getBehaviour().getMoving().getWalk().getCanWalk();
        boolean canFly = this.pokemonEntity.getBehaviour().getMoving().getFly().getCanFly();
        if (node != null) {
            if (node.field_41 == class_7.field_7) {
                boolean canFly2 = this.moving.getFly().getCanFly();
                if (!canFly2) return;
                if (this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING)) return;
                this.pokemonEntity.setBehaviourFlag(PokemonBehaviourFlag.FLYING, true);
                return;
            }
            if (node.field_41 == class_7.field_7) return;
            if (!isFlying) return;
            if (!canWalk) return;
            this.pokemonEntity.setBehaviourFlag(PokemonBehaviourFlag.FLYING, false);
            return;
        }
        if (!isFlying && canFly) {
            class_1937 class_19372 = this.pokemonEntity.field_6002;
            Intrinsics.checkNotNullExpressionValue(class_19372, "pokemonEntity.world");
            class_2338 class_23382 = this.pokemonEntity.method_24515();
            Intrinsics.checkNotNullExpressionValue(class_23382, "pokemonEntity.blockPos");
            if (this.isAirborne(class_19372, class_23382)) {
                this.pokemonEntity.setBehaviourFlag(PokemonBehaviourFlag.FLYING, true);
                return;
            }
        }
        if (!isFlying) return;
        if (!canWalk) return;
        if (this.pokemonEntity.field_6002.method_8320(this.pokemonEntity.method_24515()).method_26171((class_1922)this.pokemonEntity.field_6002, this.pokemonEntity.method_24515().method_10074(), class_10.field_50)) return;
        this.pokemonEntity.setBehaviourFlag(PokemonBehaviourFlag.FLYING, false);
    }

    public final boolean getChecked() {
        return this.checked;
    }

    public final void setChecked(boolean bl) {
        this.checked = bl;
    }

    @Nullable
    public final class_11 findPath(@NotNull class_2338 target, int distance) {
        Intrinsics.checkNotNullParameter(target, "target");
        return this.method_35142((Set)ImmutableSet.of((Object)target), 8, false, distance);
    }

    @Nullable
    public class_11 method_6348(@NotNull class_2338 target, int distance) {
        class_11 class_112;
        Intrinsics.checkNotNullParameter(target, "target");
        class_2338 target2 = target;
        class_2338 blockPos2 = null;
        if (this.world.method_8320(target2).method_26215() && !this.pokemonEntity.getBehaviour().getMoving().getFly().getCanFly()) {
            class_2338 class_23382 = target2.method_10074();
            Intrinsics.checkNotNullExpressionValue(class_23382, "target.down()");
            blockPos2 = class_23382;
            while (blockPos2.method_10264() > this.world.method_31607() && this.world.method_8320(blockPos2).method_26215()) {
                Intrinsics.checkNotNullExpressionValue(blockPos2.method_10074(), "blockPos.down()");
            }
            while (blockPos2.method_10264() < this.world.method_31600() && this.world.method_8320(blockPos2).method_26215()) {
                Intrinsics.checkNotNullExpressionValue(blockPos2.method_10084(), "blockPos.up()");
            }
            target2 = blockPos2;
        }
        if (!this.world.method_8320(target2).method_26207().method_15799()) {
            class_112 = this.findPath(target2, distance);
        } else {
            class_2338 class_23383 = target2.method_10084();
            Intrinsics.checkNotNullExpressionValue(class_23383, "target.up()");
            blockPos2 = class_23383;
            while (blockPos2.method_10264() < this.world.method_31600() && this.world.method_8320(blockPos2).method_26207().method_15799()) {
                Intrinsics.checkNotNullExpressionValue(blockPos2.method_10084(), "blockPos.up()");
            }
            class_112 = this.findPath(blockPos2, distance);
        }
        class_11 path = class_112;
        return path;
    }

    @Nullable
    public class_11 method_6349(@NotNull class_1297 entity2, int distance) {
        Intrinsics.checkNotNullParameter(entity2, "entity");
        class_2338 class_23382 = entity2.method_24515();
        Intrinsics.checkNotNullExpressionValue(class_23382, "entity.blockPos");
        return this.method_6348(class_23382, distance);
    }

    protected void method_6359() {
        super.method_6359();
        class_11 class_112 = this.method_6345();
        if (class_112 == null) {
            return;
        }
        class_11 path = class_112;
        int i = 2;
        block2: while (i < path.method_38()) {
            class_9 firstNode = path.method_40(i - 2);
            class_9 middleNode = path.method_40(i - 1);
            class_9 nextNode = path.method_40(i);
            class_2338 class_23382 = middleNode.method_22879().method_10059((class_2382)firstNode.method_22879());
            Intrinsics.checkNotNullExpressionValue(class_23382, "middleNode.blockPos.subtract(firstNode.blockPos)");
            class_243 directionToMiddle = BlockPosExtensionsKt.toVec3d(class_23382).method_1029();
            class_7 nodeType = firstNode.field_41;
            if (nodeType != middleNode.field_41 || nodeType != nextNode.field_41 || nodeType == class_7.field_12) {
                ++i;
                continue;
            }
            class_2338 class_23383 = nextNode.method_22879().method_10059((class_2382)middleNode.method_22879());
            Intrinsics.checkNotNullExpressionValue(class_23383, "nextNode.blockPos.subtract(middleNode.blockPos)");
            class_243 directionToEnd = BlockPosExtensionsKt.toVec3d(class_23383).method_1029();
            if (!Intrinsics.areEqual(directionToEnd, directionToMiddle)) {
                ++i;
                continue;
            }
            List remainingNodes = new ArrayList();
            int j = i;
            while (true) {
                try {
                    class_9 class_92 = path.method_40(j);
                    Intrinsics.checkNotNullExpressionValue(class_92, "path.getNode(j)");
                    remainingNodes.add(class_92);
                    ++j;
                }
                catch (Exception e) {
                    path.method_36(i + remainingNodes.size() - 1);
                    int n = remainingNodes.size();
                    for (int k = 0; k < n; ++k) {
                        path.method_33(i - 1 + k, (class_9)remainingNodes.get(k));
                    }
                    continue block2;
                }
            }
        }
    }

    public final int getPathfindingY() {
        boolean inSwimmableFluid;
        boolean bl = inSwimmableFluid = this.field_6684.method_5777(class_3486.field_15517) && this.moving.getSwim().getCanSwimInWater() || this.field_6684.method_5777(class_3486.field_15518) && this.moving.getSwim().getCanSwimInLava();
        if (!inSwimmableFluid) {
            return class_3532.method_15357((double)(this.field_6684.method_23318() + 0.5));
        }
        return this.field_6684.method_31478();
    }
}

