/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai;

import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.PokemonMoveControl;
import com.cobblemon.mod.common.pokemon.ai.FormPokemonBehaviour;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1308;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.minecraft.class_8;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/PokemonMoveControl;", "Lnet/minecraft/class_1335;", "", "xMovement", "zMovement", "", "isWalkable", "(FF)Z", "", "tick", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getPokemonEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Companion", "common"})
public final class PokemonMoveControl
extends class_1335 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PokemonEntity pokemonEntity;
    public static final double VERY_CLOSE = 0.002500000277905201;

    public PokemonMoveControl(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter(pokemonEntity, "pokemonEntity");
        super((class_1308)pokemonEntity);
        this.pokemonEntity = pokemonEntity;
    }

    @NotNull
    public final PokemonEntity getPokemonEntity() {
        return this.pokemonEntity;
    }

    public void method_6240() {
        PersistentStatusContainer persistentStatusContainer = this.pokemonEntity.getPokemon().getStatus();
        if (Intrinsics.areEqual(persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null, Statuses.INSTANCE.getSLEEP()) || this.pokemonEntity.method_29504()) {
            this.pokemonEntity.method_6125(0.0f);
            this.pokemonEntity.field_6227 = 0.0f;
            return;
        }
        FormPokemonBehaviour behaviour = this.pokemonEntity.getBehaviour();
        PoseType[] poseTypeArray = new PoseType[]{PoseType.FLY, PoseType.HOVER};
        float mediumSpeed = SetsKt.setOf(poseTypeArray).contains((Object)this.pokemonEntity.getPoseType()) ? behaviour.getMoving().getFly().getFlySpeedHorizontal() : (this.pokemonEntity.method_5777(class_3486.field_15517) || this.pokemonEntity.method_5777(class_3486.field_15518) ? behaviour.getMoving().getSwim().getSwimSpeed() : behaviour.getMoving().getWalk().getWalkSpeed());
        float baseSpeed = (float)this.field_6371.method_26825(class_5134.field_23719) * (float)this.field_6372;
        float adjustedSpeed = baseSpeed * mediumSpeed;
        if (this.field_6374 == class_1335.class_1336.field_6376) {
            float zMovement;
            float movingDistanceTotal = class_3532.method_15355((float)(this.field_6368 * this.field_6368 + this.field_6373 * this.field_6373));
            if (movingDistanceTotal < 1.0f) {
                movingDistanceTotal = 1.0f;
            }
            movingDistanceTotal = adjustedSpeed / movingDistanceTotal;
            float adjustedForward = this.field_6368 * movingDistanceTotal;
            float adjustedStrafe = this.field_6373 * movingDistanceTotal;
            float xComponent = class_3532.method_15374((float)AngleExtensionsKt.toRadians(Float.valueOf(this.field_6371.method_36454())));
            float zComponent = class_3532.method_15362((float)AngleExtensionsKt.toRadians(Float.valueOf(this.field_6371.method_36454())));
            float xMovement = adjustedForward * zComponent - adjustedStrafe * xComponent;
            if (!this.isWalkable(xMovement, zMovement = adjustedStrafe * zComponent + adjustedForward * xComponent)) {
                this.field_6368 = 1.0f;
                this.field_6373 = 0.0f;
            }
            this.field_6371.method_6125(adjustedSpeed);
            this.field_6371.method_5930(this.field_6368);
            this.field_6371.method_5938(this.field_6373);
            this.field_6374 = class_1335.class_1336.field_6377;
        } else if (this.field_6374 == class_1335.class_1336.field_6378) {
            boolean closeHorizontally;
            double xDist = this.field_6370 - this.field_6371.method_23317();
            double zDist = this.field_6367 - this.field_6371.method_23321();
            double yDist = this.field_6369 - this.field_6371.method_23318();
            double horizontalDistanceFromTarget = xDist * xDist + zDist * zDist;
            boolean bl = closeHorizontally = horizontalDistanceFromTarget < 0.002500000277905201;
            if (!closeHorizontally) {
                float angleToTarget = AngleExtensionsKt.toDegrees(class_3532.method_15349((double)zDist, (double)xDist)) - 90.0f;
                float currentMovingAngle = this.field_6371.method_36454();
                float steppedAngle = class_3532.method_15388((float)currentMovingAngle, (float)angleToTarget, (float)((float)100 * mediumSpeed));
                this.field_6371.method_36456(steppedAngle);
            }
            class_1937 class_19372 = this.field_6371.field_6002;
            Intrinsics.checkNotNullExpressionValue(class_19372, "entity.world");
            class_1922 class_19222 = (class_1922)class_19372;
            class_238 class_2382 = this.field_6371.method_5829();
            Intrinsics.checkNotNullExpressionValue(class_2382, "entity.boundingBox");
            Pair<Boolean, Boolean> pair = WorldExtensionsKt.getWaterAndLavaIn(class_19222, class_2382);
            boolean inWater = pair.component1();
            boolean inLava = pair.component2();
            boolean inFluid = inWater || inLava;
            boolean verticalHandled = false;
            class_2338 blockPos2 = this.field_6371.method_24515();
            class_2680 blockState = this.field_6371.field_6002.method_8320(blockPos2);
            class_265 voxelShape = blockState.method_26220((class_1922)this.field_6371.field_6002, blockPos2);
            if (this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING) || inFluid) {
                verticalHandled = true;
                this.field_6371.field_6227 = 0.0f;
                this.field_6371.method_6125(0.0f);
                Function1 refine2 = tick.refine.1.INSTANCE;
                class_243 fullDistance = new class_243(((Number)refine2.invoke(xDist)).doubleValue(), inFluid || this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING) ? ((Number)refine2.invoke(yDist + 0.05)).doubleValue() : 0.0, ((Number)refine2.invoke(zDist)).doubleValue());
                class_243 direction = fullDistance.method_1029();
                double scale = Math.min((double)adjustedSpeed, fullDistance.method_1033());
                this.field_6371.method_18799(direction.method_1021(scale));
            } else {
                float forwardSpeed = Math.min(adjustedSpeed, (float)Math.sqrt(horizontalDistanceFromTarget));
                this.field_6371.method_6125(forwardSpeed);
            }
            if (!verticalHandled) {
                boolean closeEnoughToJump;
                boolean tooBigToStep = yDist > (double)this.field_6371.field_6013;
                boolean bl2 = closeEnoughToJump = Math.sqrt(xDist * xDist + zDist * zDist) < (double)RangesKt.coerceAtLeast(1.0f, this.field_6371.method_17681()) + 1.0;
                if (tooBigToStep && closeEnoughToJump || !voxelShape.method_1110() && this.field_6371.method_23318() < voxelShape.method_1105(class_2350.class_2351.field_11052) + (double)blockPos2.method_10264() && !blockState.method_26164(class_3481.field_15495) && !blockState.method_26164(class_3481.field_16584)) {
                    this.field_6371.method_5993().method_6233();
                    this.field_6374 = class_1335.class_1336.field_6379;
                }
            }
            if (closeHorizontally && Math.abs(yDist) < 0.002500000277905201) {
                this.field_6374 = class_1335.class_1336.field_6377;
            }
        } else if (this.field_6374 == class_1335.class_1336.field_6379) {
            this.field_6371.method_6125(adjustedSpeed);
            this.field_6371.field_6227 = 0.0f;
            if (this.field_6371.method_24828() || this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING)) {
                this.field_6374 = class_1335.class_1336.field_6377;
            }
        } else {
            this.field_6371.method_5930(0.0f);
            this.field_6371.field_6227 = 0.0f;
        }
        if (this.field_6374 == class_1335.class_1336.field_6377) {
            if (this.field_6371.method_24828() && behaviour.getMoving().getWalk().getCanWalk() && this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING)) {
                this.pokemonEntity.setBehaviourFlag(PokemonBehaviourFlag.FLYING, false);
            }
            if (this.field_6371.method_5777(class_3486.field_15517) && behaviour.getMoving().getSwim().getCanSwimInWater()) {
                this.pokemonEntity.method_5976(0.2f);
            }
        }
    }

    private final boolean isWalkable(float xMovement, float zMovement) {
        class_8 pathNodeMaker;
        class_1408 entityNavigation = this.field_6371.method_5942();
        return entityNavigation == null || (pathNodeMaker = entityNavigation.method_6342()) == null || pathNodeMaker.method_17((class_1922)this.field_6371.field_6002, class_3532.method_15357((double)(this.field_6371.method_23317() + (double)xMovement)), this.field_6371.method_31478(), class_3532.method_15357((double)(this.field_6371.method_23321() + (double)zMovement))) == class_7.field_12;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/PokemonMoveControl$Companion;", "", "", "VERY_CLOSE", "D", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

