/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.SentOutState;
import com.cobblemon.mod.common.pokemon.ai.MoveBehaviour;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b \u0010\u0011J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0006J\r\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0011R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\f\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/PokemonServerDelegate;", "Lcom/cobblemon/mod/common/api/entity/PokemonSideDelegate;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "changePokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lnet/minecraft/class_1282;", "source", "drop", "(Lnet/minecraft/class_1282;)V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "initialize", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "tick", "updateMaxHealth", "()V", "updatePathfindingPenalties", "updatePoseType", "updatePostDeath", "", "acknowledgedHPStat", "I", "getAcknowledgedHPStat", "()I", "setAcknowledgedHPStat", "(I)V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "setEntity", "<init>", "common"})
public final class PokemonServerDelegate
implements PokemonSideDelegate {
    public PokemonEntity entity;
    private int acknowledgedHPStat = -1;

    @NotNull
    public final PokemonEntity getEntity() {
        PokemonEntity pokemonEntity = this.entity;
        if (pokemonEntity != null) {
            return pokemonEntity;
        }
        Intrinsics.throwUninitializedPropertyAccessException("entity");
        return null;
    }

    public final void setEntity(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter(pokemonEntity, "<set-?>");
        this.entity = pokemonEntity;
    }

    public final int getAcknowledgedHPStat() {
        return this.acknowledgedHPStat;
    }

    public final void setAcknowledgedHPStat(int n) {
        this.acknowledgedHPStat = n;
    }

    @Override
    public void changePokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        this.updatePathfindingPenalties(pokemon);
        this.getEntity().method_5959();
        this.updateMaxHealth();
    }

    public final void updatePathfindingPenalties(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        MoveBehaviour moving = pokemon.getForm().getBehaviour().getMoving();
        this.getEntity().method_5941(class_7.field_14, moving.getSwim().getCanSwimInLava() ? 12.0f : -1.0f);
        this.getEntity().method_5941(class_7.field_18, moving.getSwim().getCanSwimInWater() ? 12.0f : -1.0f);
        this.getEntity().method_5941(class_7.field_4, moving.getSwim().getCanSwimInWater() ? 6.0f : -1.0f);
        if (moving.getSwim().getCanBreatheUnderwater()) {
            this.getEntity().method_5941(class_7.field_18, moving.getWalk().getAvoidsLand() ? 0.0f : 4.0f);
        }
        if (moving.getSwim().getCanBreatheUnderlava()) {
            this.getEntity().method_5941(class_7.field_14, moving.getSwim().getCanSwimInLava() ? 4.0f : -1.0f);
        }
        if (moving.getWalk().getAvoidsLand()) {
            this.getEntity().method_5941(class_7.field_12, 12.0f);
        }
        if (moving.getWalk().getCanWalk() && moving.getFly().getCanFly()) {
            this.getEntity().method_5941(class_7.field_12, 0.0f);
        }
    }

    public final void updateMaxHealth() {
        double currentHealthRatio = (double)this.getEntity().method_6032() / (double)this.getEntity().method_6063();
        Integer n = this.getEntity().getForm().getBaseStats().get(Stats.HP);
        if (n == null) {
            return;
        }
        this.acknowledgedHPStat = n;
        int minStat = 50;
        int maxStat = 150;
        int baseStat = RangesKt.coerceIn(this.acknowledgedHPStat, new IntRange(minStat, maxStat));
        double r = (double)(baseStat - minStat) / (double)(maxStat - minStat);
        double minPossibleHP = 10.0;
        double maxPossibleHP = 100.0;
        double maxHealth = minPossibleHP + r * (maxPossibleHP - minPossibleHP);
        class_1324 class_13242 = this.getEntity().method_5996(class_5134.field_23716);
        if (class_13242 != null) {
            class_13242.method_6192(maxHealth);
        }
        this.getEntity().method_6033((float)currentHealthRatio * (float)maxHealth);
    }

    @Override
    public void initialize(@NotNull PokemonEntity entity2) {
        Intrinsics.checkNotNullParameter(entity2, "entity");
        this.setEntity(entity2);
        PokemonEntity $this$initialize_u24lambda_u2d0 = entity2;
        boolean bl = false;
        $this$initialize_u24lambda_u2d0.field_28627 = 0.1f;
        entity2.getDespawner().beginTracking((PokemonEntity)((class_1297)$this$initialize_u24lambda_u2d0));
        $this$initialize_u24lambda_u2d0.getSubscriptions().add(Observable.DefaultImpls.subscribe$default($this$initialize_u24lambda_u2d0.getBehaviourFlags(), null, new Function1<Byte, Unit>(this){
            final /* synthetic */ PokemonServerDelegate this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Byte it) {
                this.this$0.updatePoseType();
            }
        }, 1, null));
    }

    @Override
    public void tick(@NotNull PokemonEntity entity2) {
        boolean isMoving;
        UUID battleId;
        Intrinsics.checkNotNullParameter(entity2, "entity");
        PokemonState state = entity2.getPokemon().getState();
        if (!(state instanceof ActivePokemonState && Intrinsics.areEqual(((ActivePokemonState)state).getEntity(), entity2) || entity2.method_29504() || !(entity2.method_6032() > 0.0f))) {
            entity2.getPokemon().setState(new SentOutState(entity2));
        }
        if (entity2.method_6139() != null && entity2.getPokemon().getStoreCoordinates().get() == null) {
            entity2.method_31472();
        }
        if (!entity2.getBehaviour().getMoving().getWalk().getCanWalk() && entity2.getBehaviour().getMoving().getFly().getCanFly() && !entity2.getBehaviourFlag(PokemonBehaviourFlag.FLYING)) {
            entity2.setBehaviourFlag(PokemonBehaviourFlag.FLYING, true);
        }
        if ((battleId = (UUID)((Optional)entity2.getBattleId().get()).orElse(null)) != null) {
            PokemonBattle it = BattleRegistry.INSTANCE.getBattle(battleId);
            boolean bl = false;
            boolean bl2 = it == null || it.getEnded();
            if (bl2) {
                entity2.getBattleId().set(Optional.empty());
            }
        }
        if (entity2.getTicksLived() % 20 == 0 && battleId != null) {
            ActiveBattlePokemon activeBattlePokemon;
            Iterable<ActiveBattlePokemon> iterable;
            PokemonBattle pokemonBattle = BattleRegistry.INSTANCE.getBattle(battleId);
            if (pokemonBattle != null && (iterable = pokemonBattle.getActivePokemon()) != null) {
                ActiveBattlePokemon activeBattlePokemon2;
                block20: {
                    Iterable<ActiveBattlePokemon> iterable2 = iterable;
                    Iterator<ActiveBattlePokemon> iterator2 = iterable2.iterator();
                    while (iterator2.hasNext()) {
                        ActiveBattlePokemon activeBattlePokemon3;
                        ActiveBattlePokemon it = activeBattlePokemon3 = iterator2.next();
                        boolean bl = false;
                        BattlePokemon battlePokemon = it.getBattlePokemon();
                        if (!Intrinsics.areEqual(battlePokemon != null ? battlePokemon.getUuid() : null, entity2.getPokemon().getUuid())) continue;
                        activeBattlePokemon2 = activeBattlePokemon3;
                        break block20;
                    }
                    activeBattlePokemon2 = null;
                }
                v3 = activeBattlePokemon2;
            } else {
                v3 = activeBattlePokemon = null;
            }
            if (activeBattlePokemon != null) {
                class_1937 class_19372 = entity2.field_6002;
                Intrinsics.checkNotNull(class_19372, "null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
                activeBattlePokemon.setPosition(TuplesKt.to((class_3218)class_19372, entity2.method_19538()));
            }
        }
        Integer n = entity2.getForm().getBaseStats().get(Stats.HP);
        int activeBattlePokemon = this.acknowledgedHPStat;
        if (n == null || n != activeBattlePokemon) {
            this.updateMaxHealth();
        }
        if (!Intrinsics.areEqual(entity2.method_6139(), entity2.getPokemon().getOwnerUUID())) {
            entity2.method_6174(entity2.getPokemon().getOwnerUUID());
        }
        if (entity2.method_6139() != null && entity2.method_6177() == null) {
            entity2.method_5650(class_1297.class_5529.field_26999);
        }
        if (!Intrinsics.areEqual(entity2.getPokemon().getSpecies().getResourceIdentifier().toString(), entity2.getSpecies().get())) {
            entity2.getSpecies().set(entity2.getPokemon().getSpecies().getResourceIdentifier().toString());
        }
        if (!Intrinsics.areEqual(entity2.getAspects().get(), entity2.getPokemon().getAspects())) {
            entity2.getAspects().set(entity2.getPokemon().getAspects());
        }
        Integer n2 = (Integer)entity2.getLabelLevel$common().get();
        activeBattlePokemon = entity2.getPokemon().getLevel();
        if (n2 == null || n2 != activeBattlePokemon) {
            entity2.getLabelLevel$common().set(entity2.getPokemon().getLevel());
        }
        boolean bl = isMoving = !entity2.method_5942().method_6357();
        if (isMoving && !((Boolean)entity2.isMoving().get()).booleanValue()) {
            entity2.isMoving().set(true);
        } else if (!isMoving) {
            Object t = entity2.isMoving().get();
            Intrinsics.checkNotNullExpressionValue(t, "entity.isMoving.get()");
            if (((Boolean)t).booleanValue()) {
                entity2.isMoving().set(false);
            }
        }
        this.updatePoseType();
    }

    public final void updatePoseType() {
        PoseType poseType;
        PersistentStatusContainer persistentStatusContainer = this.getEntity().getPokemon().getStatus();
        boolean isSleeping = Intrinsics.areEqual(persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null, Statuses.INSTANCE.getSLEEP()) && this.getEntity().getBehaviour().getResting().getCanSleep();
        Boolean isMoving = (Boolean)this.getEntity().isMoving().get();
        boolean isUnderwater = this.getEntity().getIsSubmerged();
        boolean isFlying = this.getEntity().getBehaviourFlag(PokemonBehaviourFlag.FLYING);
        if (isSleeping) {
            v1 = PoseType.SLEEP;
        } else {
            Intrinsics.checkNotNullExpressionValue(isMoving, "isMoving");
            v1 = isMoving != false && isUnderwater ? PoseType.SWIM : (isUnderwater ? PoseType.FLOAT : (isMoving != false && isFlying ? PoseType.FLY : (isFlying ? PoseType.HOVER : (poseType = isMoving != false ? PoseType.WALK : PoseType.STAND))));
        }
        if (poseType != this.getEntity().getPoseType().get()) {
            this.getEntity().getPoseType().set(poseType);
        }
    }

    @Override
    public void drop(@Nullable class_1282 source) {
        class_3222 player;
        class_1282 class_12822 = source;
        class_1297 class_12972 = class_12822 != null ? class_12822.method_5526() : null;
        class_3222 class_32222 = player = class_12972 instanceof class_3222 ? (class_3222)class_12972 : null;
        if (this.getEntity().getPokemon().isWild()) {
            this.getEntity().setKiller(player);
        }
    }

    @Override
    public void updatePostDeath() {
        class_1309 owner;
        if (!((Boolean)this.getEntity().getDeathEffectsStarted().get()).booleanValue()) {
            this.getEntity().getDeathEffectsStarted().set(true);
        }
        PokemonEntity pokemonEntity = this.getEntity();
        ++pokemonEntity.field_6213;
        int cfr_ignored_0 = pokemonEntity.field_6213;
        if (this.getEntity().field_6213 == 30 && (owner = this.getEntity().method_6177()) != null) {
            class_1937 class_19372 = this.getEntity().field_6002;
            Intrinsics.checkNotNullExpressionValue(class_19372, "entity.world");
            class_243 class_2432 = owner.method_19538();
            Intrinsics.checkNotNullExpressionValue(class_2432, "owner.pos");
            Object object = CobblemonSounds.POKE_BALL_RECALL.get();
            Intrinsics.checkNotNullExpressionValue(object, "POKE_BALL_RECALL.get()");
            WorldExtensionsKt.playSoundServer$default(class_19372, class_2432, (class_3414)object, null, 0.2f, 0.0f, 20, null);
            this.getEntity().getPhasingTargetId().set(owner.method_5628());
            this.getEntity().getBeamModeEmitter().set((byte)2);
        }
        if (this.getEntity().field_6213 == 60) {
            if (this.getEntity().method_6177() == null) {
                this.getEntity().field_6002.method_8421((class_1297)this.getEntity(), (byte)60);
                DropTable dropTable = this.getEntity().getDrops();
                if (dropTable == null) {
                    dropTable = this.getEntity().getPokemon().getForm().getDrops();
                }
                class_1309 class_13092 = (class_1309)this.getEntity();
                class_1937 class_19373 = this.getEntity().field_6002;
                Intrinsics.checkNotNull(class_19373, "null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
                class_3218 class_32182 = (class_3218)class_19373;
                class_243 class_2433 = this.getEntity().method_19538();
                Intrinsics.checkNotNullExpressionValue(class_2433, "entity.pos");
                DropTable.drop$default(dropTable, class_13092, class_32182, class_2433, this.getEntity().getKiller(), null, 16, null);
            }
            this.getEntity().method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Override
    public void handleStatus(byte status) {
        PokemonSideDelegate.DefaultImpls.handleStatus(this, status);
    }
}

