/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.struct.MoStruct;
import com.cobblemon.mod.common.api.snowstorm.BedrockParticleEffect;
import com.cobblemon.mod.common.client.particle.ParticleStorm;
import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.client.render.models.blockbench.PoseableEntityModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PoseableEntityState;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockBoneTimeline;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockBoneValue;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockParticleKeyframe;
import com.cobblemon.mod.common.client.render.models.blockbench.pose.TransformedModelPart;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_630;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013B9\u0012\u0006\u0010\u0011\u001a\u00020\u0002\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0004\b1\u00102J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010JJ\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u00052\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJA\u0010%\u001a\u00020\u00022\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\f\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\rH\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(R\u0017\u0010\u0012\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010)\u001a\u0004\b*\u0010\u0007R#\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010+\u001a\u0004\b,\u0010\u0010R\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010-\u001a\u0004\b.\u0010\u000bR\u0017\u0010\u0011\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010/\u001a\u0004\b0\u0010\u0004\u00a8\u00064"}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation;", "", "", "component1", "()Z", "", "component2", "()D", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockParticleKeyframe;", "component3", "()Ljava/util/List;", "", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockBoneTimeline;", "component4", "()Ljava/util/Map;", "shouldLoop", "animationLength", "particleEffects", "boneTimelines", "copy", "(ZDLjava/util/List;Ljava/util/Map;)Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PoseableEntityModel;", "model", "Lnet/minecraft/class_1297;", "entity", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PoseableEntityState;", "state", "previousSecondsPassed", "secondsPassed", "run", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PoseableEntityModel;Lnet/minecraft/class_1297;Lcom/cobblemon/mod/common/client/render/models/blockbench/PoseableEntityState;DD)Z", "toString", "()Ljava/lang/String;", "D", "getAnimationLength", "Ljava/util/Map;", "getBoneTimelines", "Ljava/util/List;", "getParticleEffects", "Z", "getShouldLoop", "<init>", "(ZDLjava/util/List;Ljava/util/Map;)V", "Companion", "common"})
public final class BedrockAnimation {
    @NotNull
    public static final Companion Companion;
    private final boolean shouldLoop;
    private final double animationLength;
    @NotNull
    private final List<BedrockParticleKeyframe> particleEffects;
    @NotNull
    private final Map<String, BedrockBoneTimeline> boneTimelines;
    @NotNull
    private static final MoLangRuntime sharedRuntime;

    public BedrockAnimation(boolean shouldLoop, double animationLength, @NotNull List<BedrockParticleKeyframe> particleEffects, @NotNull Map<String, BedrockBoneTimeline> boneTimelines) {
        Intrinsics.checkNotNullParameter(particleEffects, "particleEffects");
        Intrinsics.checkNotNullParameter(boneTimelines, "boneTimelines");
        this.shouldLoop = shouldLoop;
        this.animationLength = animationLength;
        this.particleEffects = particleEffects;
        this.boneTimelines = boneTimelines;
    }

    public final boolean getShouldLoop() {
        return this.shouldLoop;
    }

    public final double getAnimationLength() {
        return this.animationLength;
    }

    @NotNull
    public final List<BedrockParticleKeyframe> getParticleEffects() {
        return this.particleEffects;
    }

    @NotNull
    public final Map<String, BedrockBoneTimeline> getBoneTimelines() {
        return this.boneTimelines;
    }

    public final boolean run(@NotNull PoseableEntityModel<?> model, @Nullable class_1297 entity2, @Nullable PoseableEntityState<?> state, double previousSecondsPassed, double secondsPassed) {
        Intrinsics.checkNotNullParameter(model, "model");
        double animationSeconds = 0.0;
        animationSeconds = secondsPassed;
        if (this.shouldLoop) {
            animationSeconds %= this.animationLength;
        } else if (animationSeconds > this.animationLength && this.animationLength > 0.0) {
            return false;
        }
        if (entity2 != null && state != null) {
            List particleEffectsToPlay = new ArrayList();
            if (previousSecondsPassed > animationSeconds) {
                Iterable iterable = this.particleEffects;
                var23_10 = particleEffectsToPlay;
                $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (BedrockParticleKeyframe)element$iv$iv;
                    boolean bl = false;
                    if (!((double)it.getSeconds() >= previousSecondsPassed || (double)it.getSeconds() <= animationSeconds)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var23_10.addAll((List)destination$iv$iv);
            } else {
                $this$filter$iv = this.particleEffects;
                var23_10 = particleEffectsToPlay;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (BedrockParticleKeyframe)element$iv$iv;
                    boolean bl = false;
                    double d = it.getSeconds();
                    boolean bl2 = previousSecondsPassed <= d ? d <= animationSeconds : false;
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var23_10.addAll((List)destination$iv$iv);
            }
            for (BedrockParticleKeyframe particleEffect : particleEffectsToPlay) {
                class_1937 class_19372 = entity2.field_6002;
                Intrinsics.checkNotNull(class_19372, "null cannot be cast to non-null type net.minecraft.client.world.ClientWorld");
                class_638 world = (class_638)class_19372;
                MatrixWrapper matrixWrapper = state.getLocatorStates().get(particleEffect.getLocator());
                if (matrixWrapper == null) {
                    MatrixWrapper matrixWrapper2 = state.getLocatorStates().get("root");
                    Intrinsics.checkNotNull(matrixWrapper2);
                    matrixWrapper = matrixWrapper2;
                }
                MatrixWrapper matrixWrapper3 = matrixWrapper;
                BedrockParticleEffect effect = particleEffect.getEffect();
                if (state.getPoseParticles().contains(particleEffect)) continue;
                ParticleStorm storm2 = new ParticleStorm(effect, matrixWrapper3, world, new Function0<class_243>(entity2){
                    final /* synthetic */ class_1297 $entity;
                    {
                        this.$entity = $entity;
                        super(0);
                    }

                    @NotNull
                    public final class_243 invoke() {
                        class_243 class_2432 = this.$entity.method_18798();
                        Intrinsics.checkNotNullExpressionValue(class_2432, "entity.velocity");
                        return class_2432;
                    }
                }, new Function0<Boolean>(entity2, state, particleEffect){
                    final /* synthetic */ class_1297 $entity;
                    final /* synthetic */ PoseableEntityState<?> $state;
                    final /* synthetic */ BedrockParticleKeyframe $particleEffect;
                    {
                        this.$entity = $entity;
                        this.$state = $state;
                        this.$particleEffect = $particleEffect;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return !this.$entity.method_31481() && this.$state.getPoseParticles().contains(this.$particleEffect);
                    }
                }, new Function0<Boolean>(entity2){
                    final /* synthetic */ class_1297 $entity;
                    {
                        this.$entity = $entity;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return !this.$entity.method_5767();
                    }
                }, null, 64, null);
                state.getPoseParticles().add(particleEffect);
                storm2.getRuntime().execute(particleEffect.getScripts());
                storm2.spawn();
            }
        }
        Map<String, BedrockBoneTimeline> $this$forEach$iv = this.boneTimelines;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, BedrockBoneTimeline>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            class_630 bl;
            Map.Entry<String, BedrockBoneTimeline> element$iv;
            Map.Entry<String, BedrockBoneTimeline> entry = element$iv = iterator2.next();
            boolean bl3 = false;
            String boneName = entry.getKey();
            BedrockBoneTimeline timeline = entry.getValue();
            TransformedModelPart part = model.getRelevantPartsByName().get(boneName);
            if (part == null) continue;
            if (!timeline.getPosition().isEmpty()) {
                BedrockBoneValue bedrockBoneValue = timeline.getPosition();
                PoseableEntityState<?> poseableEntityState = state;
                if (poseableEntityState == null || (poseableEntityState = poseableEntityState.getRuntime()) == null) {
                    poseableEntityState = sharedRuntime;
                }
                class_243 position = bedrockBoneValue.resolve(animationSeconds, (MoLangRuntime)((Object)poseableEntityState)).method_1021((double)model.getChangeFactor(part.getModelPart()));
                class_630 $this$run_u24lambda_u2d5_u24lambda_u2d2 = bl = part.getModelPart();
                boolean bl4 = false;
                $this$run_u24lambda_u2d5_u24lambda_u2d2.field_3657 += (float)position.field_1352;
                $this$run_u24lambda_u2d5_u24lambda_u2d2.field_3656 += (float)position.field_1351;
                $this$run_u24lambda_u2d5_u24lambda_u2d2.field_3655 += (float)position.field_1350;
            }
            if (timeline.getRotation().isEmpty()) continue;
            try {
                BedrockBoneValue bedrockBoneValue = timeline.getRotation();
                PoseableEntityState<?> poseableEntityState = state;
                if (poseableEntityState == null || (poseableEntityState = poseableEntityState.getRuntime()) == null) {
                    poseableEntityState = sharedRuntime;
                }
                class_243 rotation = bedrockBoneValue.resolve(animationSeconds, (MoLangRuntime)((Object)poseableEntityState)).method_1021((double)model.getChangeFactor(part.getModelPart()));
                class_630 $this$run_u24lambda_u2d5_u24lambda_u2d3 = bl = part.getModelPart();
                boolean bl5 = false;
                $this$run_u24lambda_u2d5_u24lambda_u2d3.field_3654 += AngleExtensionsKt.toRadians(Float.valueOf((float)rotation.field_1352));
                $this$run_u24lambda_u2d5_u24lambda_u2d3.field_3675 += AngleExtensionsKt.toRadians(Float.valueOf((float)rotation.field_1351));
                $this$run_u24lambda_u2d5_u24lambda_u2d3.field_3674 += AngleExtensionsKt.toRadians(Float.valueOf((float)rotation.field_1350));
            }
            catch (Exception e) {
                Object obj = model.getCurrentEntity();
                Intrinsics.checkNotNull(obj);
                IllegalStateException exception = new IllegalStateException("Bad animation for species: " + ((PokemonEntity)obj).getPokemon().getSpecies().getName(), e);
                class_128 crash = new class_128("Cobblemon encountered an unexpected crash", (Throwable)exception);
                class_129 section = crash.method_562("Animation Details");
                PoseableEntityState<?> poseableEntityState = state;
                if (poseableEntityState != null) {
                    PoseableEntityState<?> it = poseableEntityState;
                    boolean bl6 = false;
                    String string = state.getCurrentPose();
                    Intrinsics.checkNotNull(string);
                    section.method_578("Pose", (Object)string);
                }
                section.method_578("Bone", (Object)boneName);
                throw new class_148(crash);
            }
        }
        return true;
    }

    public final boolean component1() {
        return this.shouldLoop;
    }

    public final double component2() {
        return this.animationLength;
    }

    @NotNull
    public final List<BedrockParticleKeyframe> component3() {
        return this.particleEffects;
    }

    @NotNull
    public final Map<String, BedrockBoneTimeline> component4() {
        return this.boneTimelines;
    }

    @NotNull
    public final BedrockAnimation copy(boolean shouldLoop, double animationLength, @NotNull List<BedrockParticleKeyframe> particleEffects, @NotNull Map<String, BedrockBoneTimeline> boneTimelines) {
        Intrinsics.checkNotNullParameter(particleEffects, "particleEffects");
        Intrinsics.checkNotNullParameter(boneTimelines, "boneTimelines");
        return new BedrockAnimation(shouldLoop, animationLength, particleEffects, boneTimelines);
    }

    public static /* synthetic */ BedrockAnimation copy$default(BedrockAnimation bedrockAnimation, boolean bl, double d, List list, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            bl = bedrockAnimation.shouldLoop;
        }
        if ((n & 2) != 0) {
            d = bedrockAnimation.animationLength;
        }
        if ((n & 4) != 0) {
            list = bedrockAnimation.particleEffects;
        }
        if ((n & 8) != 0) {
            map = bedrockAnimation.boneTimelines;
        }
        return bedrockAnimation.copy(bl, d, list, map);
    }

    @NotNull
    public String toString() {
        return "BedrockAnimation(shouldLoop=" + this.shouldLoop + ", animationLength=" + this.animationLength + ", particleEffects=" + this.particleEffects + ", boneTimelines=" + this.boneTimelines + ")";
    }

    public int hashCode() {
        int n = this.shouldLoop ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result2 = n;
        result2 = result2 * 31 + Double.hashCode(this.animationLength);
        result2 = result2 * 31 + ((Object)this.particleEffects).hashCode();
        result2 = result2 * 31 + ((Object)this.boneTimelines).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BedrockAnimation)) {
            return false;
        }
        BedrockAnimation bedrockAnimation = (BedrockAnimation)other;
        if (this.shouldLoop != bedrockAnimation.shouldLoop) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.animationLength, (Object)bedrockAnimation.animationLength)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.particleEffects, bedrockAnimation.particleEffects)) {
            return false;
        }
        return Intrinsics.areEqual(this.boneTimelines, bedrockAnimation.boneTimelines);
    }

    static {
        MoLangRuntime moLangRuntime;
        Companion = new Companion(null);
        MoLangRuntime it = moLangRuntime = new MoLangRuntime();
        boolean bl = false;
        Map<String, MoStruct> map = it.getEnvironment().getStructs();
        Intrinsics.checkNotNullExpressionValue(map, "it.environment.structs");
        Map<String, MoStruct> map2 = map;
        String string = "query";
        MoStruct moStruct = it.getEnvironment().getStructs().get("variable");
        map2.put(string, moStruct);
        sharedRuntime = moLangRuntime;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation$Companion;", "", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "sharedRuntime", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "getSharedRuntime", "()Lcom/bedrockk/molang/runtime/MoLangRuntime;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MoLangRuntime getSharedRuntime() {
            return sharedRuntime;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

