/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.models.blockbench.animation;

import com.cobblemon.mod.common.client.render.models.blockbench.ModelPartExtensionsKt;
import com.cobblemon.mod.common.client.render.models.blockbench.PoseableEntityModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PoseableEntityState;
import com.cobblemon.mod.common.client.render.models.blockbench.animation.StatelessAnimation;
import com.cobblemon.mod.common.client.render.models.blockbench.frame.HeadedFrame;
import com.cobblemon.mod.common.client.render.models.blockbench.frame.ModelFrame;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u0003B\u001f\u0012\u0006\u0010\u001f\u001a\u00020\u0004\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\u0004\b \u0010!J_\u0010\u0011\u001a\u00020\u00102\b\u0010\u0005\u001a\u0004\u0018\u00018\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0014\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u0017R \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/SingleBoneLookAnimation;", "Lnet/minecraft/class_1297;", "T", "Lcom/cobblemon/mod/common/client/render/models/blockbench/animation/StatelessAnimation;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/frame/HeadedFrame;", "entity", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PoseableEntityModel;", "model", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PoseableEntityState;", "state", "", "limbSwing", "limbSwingAmount", "ageInTicks", "headYaw", "headPitch", "", "setAngles", "(Lnet/minecraft/class_1297;Lcom/cobblemon/mod/common/client/render/models/blockbench/PoseableEntityModel;Lcom/cobblemon/mod/common/client/render/models/blockbench/PoseableEntityState;FFFFF)V", "", "invertX", "Z", "getInvertX", "()Z", "invertY", "getInvertY", "Ljava/lang/Class;", "targetFrame", "Ljava/lang/Class;", "getTargetFrame", "()Ljava/lang/Class;", "frame", "<init>", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/frame/HeadedFrame;ZZ)V", "common"})
public final class SingleBoneLookAnimation<T extends class_1297>
extends StatelessAnimation<T, HeadedFrame> {
    private final boolean invertX;
    private final boolean invertY;
    @NotNull
    private final Class<HeadedFrame> targetFrame;

    public SingleBoneLookAnimation(@NotNull HeadedFrame frame, boolean invertX, boolean invertY) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        super((ModelFrame)frame);
        this.invertX = invertX;
        this.invertY = invertY;
        this.targetFrame = HeadedFrame.class;
    }

    public final boolean getInvertX() {
        return this.invertX;
    }

    public final boolean getInvertY() {
        return this.invertY;
    }

    @Override
    @NotNull
    public Class<HeadedFrame> getTargetFrame() {
        return this.targetFrame;
    }

    @Override
    protected void setAngles(@Nullable T entity2, @NotNull PoseableEntityModel<T> model, @Nullable PoseableEntityState<T> state, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        Intrinsics.checkNotNullParameter(model, "model");
        float pitch = (float)(this.invertX ? -1 : 1) * RangesKt.coerceIn(headPitch, -45.0f, 70.0f);
        float yaw = (float)(this.invertY ? -1 : 1) * RangesKt.coerceIn(headYaw, -45.0f, 45.0f);
        ModelPartExtensionsKt.addRotation(((HeadedFrame)this.getFrame()).getHead(), 0, AngleExtensionsKt.toRadians(Float.valueOf(pitch)));
        ModelPartExtensionsKt.addRotation(((HeadedFrame)this.getFrame()).getHead(), 1, AngleExtensionsKt.toRadians(Float.valueOf(yaw)));
    }
}

