/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.particle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.snowstorm.BedrockParticleEffect;
import com.cobblemon.mod.common.particle.SnowstormParticleReader;
import com.cobblemon.mod.common.util.IdentifierExtensionsKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/client/particle/BedrockParticleEffectRepository;", "", "Lnet/minecraft/class_2960;", "identifier", "Lcom/cobblemon/mod/common/api/snowstorm/BedrockParticleEffect;", "getEffect", "(Lnet/minecraft/class_2960;)Lcom/cobblemon/mod/common/api/snowstorm/BedrockParticleEffect;", "Lnet/minecraft/class_3300;", "resourceManager", "", "loadEffects", "(Lnet/minecraft/class_3300;)V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "", "effects", "Ljava/util/Map;", "<init>", "()V", "common"})
public final class BedrockParticleEffectRepository {
    @NotNull
    public static final BedrockParticleEffectRepository INSTANCE = new BedrockParticleEffectRepository();
    private static final Gson GSON = new GsonBuilder().create();
    @NotNull
    private static final Map<class_2960, BedrockParticleEffect> effects = new LinkedHashMap();

    private BedrockParticleEffectRepository() {
    }

    public final void loadEffects(@NotNull class_3300 resourceManager) {
        Intrinsics.checkNotNullParameter(resourceManager, "resourceManager");
        Cobblemon.INSTANCE.getLOGGER().info("Loading particle effects...");
        effects.clear();
        resourceManager.method_14488("bedrock/particles", BedrockParticleEffectRepository::loadEffects$lambda-0).forEach(BedrockParticleEffectRepository::loadEffects$lambda-2);
        Cobblemon.INSTANCE.getLOGGER().info("Loaded " + effects.size() + " particle effects");
    }

    @Nullable
    public final BedrockParticleEffect getEffect(@NotNull class_2960 identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        return effects.get(identifier);
    }

    private static final boolean loadEffects$lambda-0(class_2960 path) {
        Intrinsics.checkNotNullExpressionValue(path, "path");
        return IdentifierExtensionsKt.endsWith(path, ".particle.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadEffects$lambda-2(class_2960 identifier, class_3298 resource) {
        Closeable closeable = resource.method_14482();
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            byte[] byArray = stream.readAllBytes();
            Intrinsics.checkNotNullExpressionValue(byArray, "stream.readAllBytes()");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            Charset charset2 = charset;
            String json = new String(byArray2, charset2);
            Object object = GSON.fromJson(json, JsonObject.class);
            Intrinsics.checkNotNullExpressionValue(object, "GSON.fromJson(json, JsonObject::class.java)");
            BedrockParticleEffect effect = SnowstormParticleReader.INSTANCE.loadEffect((JsonObject)object);
            effects.put(effect.getId(), effect);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }
}

