/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.block.HealingMachineBlock;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 S2\u00020\u0001:\u0001SB\u0017\u0012\u0006\u0010$\u001a\u00020#\u0012\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\bQ\u0010RJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000bJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001f\u001a\u00020\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\u000bJ\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\"\u0010\u0012R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u0017\u0010)\u001a\u00020(8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R$\u0010.\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001d8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R(\u00102\u001a\u0004\u0018\u00010\u00132\b\u0010-\u001a\u0004\u0018\u00010\u00138\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\"\u00106\u001a\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u0010/\u001a\u0004\b7\u00101\"\u0004\b8\u00109R\"\u0010;\u001a\u00020:8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\"\u0010A\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bG\u0010DR\"\u0010H\u001a\u00020:8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010<\u001a\u0004\bI\u0010>\"\u0004\bJ\u0010@R0\u0010M\u001a\b\u0012\u0004\u0012\u00020L0K2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020L0K8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010P\u00a8\u0006T"}, d2={"Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;", "Lnet/minecraft/class_2586;", "Lnet/minecraft/class_3222;", "player", "", "activate", "(Lnet/minecraft/class_3222;)V", "", "canHeal", "(Lnet/minecraft/class_3222;)Z", "clearData$common", "()V", "clearData", "completeHealing", "markUpdated", "Lnet/minecraft/class_2487;", "compoundTag", "readNbt", "(Lnet/minecraft/class_2487;)V", "Ljava/util/UUID;", "user", "setUser", "(Ljava/util/UUID;)V", "toInitialChunkDataNbt", "()Lnet/minecraft/class_2487;", "Lnet/minecraft/class_2622;", "kotlin.jvm.PlatformType", "toUpdatePacket", "()Lnet/minecraft/class_2622;", "", "level", "updateBlockChargeLevel", "(Ljava/lang/Integer;)V", "updateRedstoneSignal", "writeNbt", "Lnet/minecraft/class_2338;", "blockPos", "Lnet/minecraft/class_2338;", "getBlockPos", "()Lnet/minecraft/class_2338;", "Lnet/minecraft/class_2680;", "blockState", "Lnet/minecraft/class_2680;", "getBlockState", "()Lnet/minecraft/class_2680;", "<set-?>", "currentSignal", "I", "getCurrentSignal", "()I", "currentUser", "Ljava/util/UUID;", "getCurrentUser", "()Ljava/util/UUID;", "healTimeLeft", "getHealTimeLeft", "setHealTimeLeft", "(I)V", "", "healingCharge", "F", "getHealingCharge", "()F", "setHealingCharge", "(F)V", "infinite", "Z", "getInfinite", "()Z", "setInfinite", "(Z)V", "isInUse", "maxCharge", "getMaxCharge", "setMaxCharge", "", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBalls", "Ljava/util/List;", "getPokeBalls", "()Ljava/util/List;", "<init>", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;)V", "Companion", "common"})
public final class HealingMachineBlockEntity
extends class_2586 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_2338 blockPos;
    @NotNull
    private final class_2680 blockState;
    @Nullable
    private UUID currentUser;
    @NotNull
    private List<PokeBall> pokeBalls;
    private int healTimeLeft;
    private float healingCharge;
    private boolean infinite;
    private int currentSignal;
    private float maxCharge;
    @NotNull
    private static final HashSet<UUID> alreadyHealing = new HashSet();
    public static final int MAX_REDSTONE_SIGNAL = 10;
    @NotNull
    private static final class_5558<HealingMachineBlockEntity> TICKER = HealingMachineBlockEntity::TICKER$lambda-1;

    public HealingMachineBlockEntity(@NotNull class_2338 blockPos2, @NotNull class_2680 blockState) {
        Intrinsics.checkNotNullParameter(blockPos2, "blockPos");
        Intrinsics.checkNotNullParameter(blockState, "blockState");
        super((class_2591)CobblemonBlockEntities.HEALING_MACHINE.get(), blockPos2, blockState);
        this.blockPos = blockPos2;
        this.blockState = blockState;
        this.pokeBalls = new ArrayList();
        this.maxCharge = 6.0f;
        this.maxCharge = RangesKt.coerceAtLeast(Cobblemon.INSTANCE.getConfig().getMaxHealerCharge(), 6.0f);
        this.updateRedstoneSignal();
        HealingMachineBlockEntity.updateBlockChargeLevel$default(this, null, 1, null);
    }

    @NotNull
    public final class_2338 getBlockPos() {
        return this.blockPos;
    }

    @NotNull
    public final class_2680 getBlockState() {
        return this.blockState;
    }

    @Nullable
    public final UUID getCurrentUser() {
        return this.currentUser;
    }

    @NotNull
    public final List<PokeBall> getPokeBalls() {
        return this.pokeBalls;
    }

    public final int getHealTimeLeft() {
        return this.healTimeLeft;
    }

    public final void setHealTimeLeft(int n) {
        this.healTimeLeft = n;
    }

    public final float getHealingCharge() {
        return this.healingCharge;
    }

    public final void setHealingCharge(float f) {
        this.healingCharge = f;
    }

    public final boolean isInUse() {
        return this.currentUser != null;
    }

    public final boolean getInfinite() {
        return this.infinite;
    }

    public final void setInfinite(boolean bl) {
        this.infinite = bl;
    }

    public final int getCurrentSignal() {
        return this.currentSignal;
    }

    public final float getMaxCharge() {
        return this.maxCharge;
    }

    public final void setMaxCharge(float f) {
        this.maxCharge = f;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUser(@NotNull UUID user) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(user, "user");
        this.clearData$common();
        class_3222 class_32222 = PlayerExtensionsKt.getPlayer(user);
        if (class_32222 == null) {
            return;
        }
        class_3222 player = class_32222;
        PlayerPartyStore party = PlayerExtensionsKt.party(player);
        this.pokeBalls.clear();
        Iterable iterable = party;
        List<PokeBall> list = this.pokeBalls;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pokemon pokemon = (Pokemon)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCaughtBall());
        }
        list.addAll((List)destination$iv$iv);
        this.currentUser = user;
        this.healTimeLeft = 60;
        this.markUpdated();
    }

    public final boolean canHeal(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() || this.infinite) {
            return true;
        }
        float neededHealthPercent = PlayerExtensionsKt.party(player).getHealingRemainderPercent();
        return this.healingCharge >= neededHealthPercent;
    }

    public final void activate(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() && !(this.healingCharge == this.maxCharge)) {
            float neededHealthPercent = PlayerExtensionsKt.party(player).getHealingRemainderPercent();
            this.healingCharge = ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(this.healingCharge - neededHealthPercent), RangesKt.rangeTo(0.0f, this.maxCharge))).floatValue();
            this.updateRedstoneSignal();
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "player.uuid");
        this.setUser(uUID);
        alreadyHealing.add(player.method_5667());
        this.updateBlockChargeLevel(6);
        if (this.field_11863 != null) {
            class_1937 class_19372 = this.field_11863;
            Intrinsics.checkNotNull(class_19372);
            if (!class_19372.field_9236) {
                class_1937 class_19373 = this.field_11863;
                Intrinsics.checkNotNull(class_19373);
                class_243 class_2432 = BlockPosExtensionsKt.toVec3d(this.blockPos);
                Object object = CobblemonSounds.HEALING_MACHINE_ACTIVE.get();
                Intrinsics.checkNotNullExpressionValue(object, "HEALING_MACHINE_ACTIVE.get()");
                WorldExtensionsKt.playSoundServer$default(class_19373, class_2432, (class_3414)object, null, 1.0f, 1.0f, 4, null);
            }
        }
    }

    public final void completeHealing() {
        UUID uUID = this.currentUser;
        if (uUID == null || (uUID = PlayerExtensionsKt.getPlayer(uUID)) == null) {
            this.clearData$common();
            return;
        }
        UUID player = uUID;
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)player);
        party.heal();
        class_5250 class_52502 = LocalizationUtilsKt.lang("healingmachine.healed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(class_52502, "lang(\"healingmachine.healed\")");
        player.method_43496((class_2561)TextKt.green(class_52502));
        HealingMachineBlockEntity.updateBlockChargeLevel$default(this, null, 1, null);
        this.clearData$common();
    }

    public final void clearData$common() {
        UUID uUID = this.currentUser;
        if (uUID != null) {
            UUID uUID2 = uUID;
            HashSet<UUID> hashSet = alreadyHealing;
            UUID p0 = uUID2;
            boolean bl = false;
            hashSet.remove(p0);
        }
        this.currentUser = null;
        this.pokeBalls.clear();
        this.healTimeLeft = 0;
        this.markUpdated();
    }

    public void method_11014(@NotNull class_2487 compoundTag) {
        Intrinsics.checkNotNullParameter(compoundTag, "compoundTag");
        super.method_11014(compoundTag);
        this.pokeBalls.clear();
        if (compoundTag.method_25928("MachineUser")) {
            this.currentUser = compoundTag.method_25926("MachineUser");
        }
        if (compoundTag.method_10545("MachinePokeBalls")) {
            class_2487 pokeBallsTag = compoundTag.method_10562("MachinePokeBalls");
            for (String key : pokeBallsTag.method_10541()) {
                PokeBall pokeBall;
                String pokeBallId = pokeBallsTag.method_10558(key);
                Intrinsics.checkNotNullExpressionValue(pokeBallId, "pokeBallId");
                if (((CharSequence)pokeBallId).length() == 0 || (pokeBall = PokeBalls.INSTANCE.getPokeBall(new class_2960(pokeBallId))) == null) continue;
                this.pokeBalls.add(pokeBall);
            }
        }
        if (compoundTag.method_10545("MachineTimeLeft")) {
            this.healTimeLeft = compoundTag.method_10550("MachineTimeLeft");
        }
        if (compoundTag.method_10545("MachineCharge")) {
            this.healingCharge = ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(compoundTag.method_10583("MachineCharge")), RangesKt.rangeTo(0.0f, this.maxCharge))).floatValue();
        }
        if (compoundTag.method_10545("MachineInfinite")) {
            this.infinite = compoundTag.method_10577("MachineInfinite");
        }
    }

    protected void method_11007(@NotNull class_2487 compoundTag) {
        Intrinsics.checkNotNullParameter(compoundTag, "compoundTag");
        super.method_11007(compoundTag);
        if (this.currentUser != null) {
            UUID uUID = this.currentUser;
            Intrinsics.checkNotNull(uUID);
            compoundTag.method_25927("MachineUser", uUID);
        } else {
            compoundTag.method_10551("MachineUser");
        }
        if (!((Collection)this.pokeBalls).isEmpty()) {
            class_2487 pokeBallsTag = new class_2487();
            int ballIndex = 1;
            for (PokeBall pokeBall : this.pokeBalls) {
                pokeBallsTag.method_10582("Pokeball" + ballIndex, pokeBall.getName().toString());
                ++ballIndex;
            }
            compoundTag.method_10566("MachinePokeBalls", (class_2520)pokeBallsTag);
        } else {
            compoundTag.method_10551("MachinePokeBalls");
        }
        compoundTag.method_10569("MachineTimeLeft", this.healTimeLeft);
        compoundTag.method_10548("MachineCharge", this.healingCharge);
        compoundTag.method_10556("MachineInfinite", this.infinite);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 class_24872 = super.method_38242();
        Intrinsics.checkNotNullExpressionValue(class_24872, "super.createNbtWithIdentifyingData()");
        return class_24872;
    }

    private final void markUpdated() {
        this.method_5431();
        class_1937 class_19372 = this.field_11863;
        Intrinsics.checkNotNull(class_19372);
        class_19372.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    private final void updateRedstoneSignal() {
        if (Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() || this.infinite) {
            this.currentSignal = 10;
        }
        int remainder = (int)(this.healingCharge / this.maxCharge * (float)100) / 10;
        this.currentSignal = RangesKt.coerceAtMost(remainder, 10);
    }

    private final void updateBlockChargeLevel(Integer level) {
        if (this.field_11863 != null) {
            class_1937 class_19372 = this.field_11863;
            Intrinsics.checkNotNull(class_19372);
            if (!class_19372.field_9236) {
                int currentCharge;
                Integer n = level;
                int chargeLevel = RangesKt.coerceIn(n != null ? n : (Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() || this.infinite ? 5 : (int)Math.floor(this.healingCharge / this.maxCharge * (float)5)), new IntRange(0, 6));
                class_1937 class_19373 = this.field_11863;
                Intrinsics.checkNotNull(class_19373);
                class_2680 state = class_19373.method_8320(this.blockPos);
                if (state != null && state.method_26204() instanceof HealingMachineBlock && chargeLevel != (currentCharge = ((Number)((Object)state.method_11654((class_2769)HealingMachineBlock.Companion.getCHARGE_LEVEL()))).intValue())) {
                    class_1937 class_19374 = this.field_11863;
                    Intrinsics.checkNotNull(class_19374);
                    class_19374.method_8501(this.blockPos, (class_2680)state.method_11657((class_2769)HealingMachineBlock.Companion.getCHARGE_LEVEL(), (Comparable)Integer.valueOf(chargeLevel)));
                }
            }
        }
    }

    static /* synthetic */ void updateBlockChargeLevel$default(HealingMachineBlockEntity healingMachineBlockEntity, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        healingMachineBlockEntity.updateBlockChargeLevel(n);
    }

    private static final void TICKER$lambda-1(class_1937 world, class_2338 class_23382, class_2680 class_26802, HealingMachineBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (blockEntity.isInUse()) {
            if (blockEntity.healTimeLeft > 0) {
                int n = blockEntity.healTimeLeft;
                blockEntity.healTimeLeft = n + -1;
            } else {
                blockEntity.completeHealing();
            }
        } else if (blockEntity.healingCharge < blockEntity.maxCharge) {
            float chargePerTick = RangesKt.coerceAtLeast(Cobblemon.INSTANCE.getConfig().getChargeGainedPerTick(), 0.0f);
            blockEntity.healingCharge = ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(blockEntity.healingCharge + chargePerTick), RangesKt.rangeTo(0.0f, blockEntity.maxCharge))).floatValue();
            Intrinsics.checkNotNullExpressionValue((Object)blockEntity, "blockEntity");
            HealingMachineBlockEntity.updateBlockChargeLevel$default(blockEntity, null, 1, null);
            blockEntity.updateRedstoneSignal();
            blockEntity.markUpdated();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$Companion;", "", "Lnet/minecraft/class_1657;", "player", "", "isUsingHealer", "(Lnet/minecraft/class_1657;)Z", "", "MAX_REDSTONE_SIGNAL", "I", "Lnet/minecraft/class_5558;", "Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;", "TICKER", "Lnet/minecraft/class_5558;", "getTICKER$common", "()Lnet/minecraft/class_5558;", "Ljava/util/HashSet;", "Ljava/util/UUID;", "Lkotlin/collections/HashSet;", "alreadyHealing", "Ljava/util/HashSet;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_5558<HealingMachineBlockEntity> getTICKER$common() {
            return TICKER;
        }

        public final boolean isUsingHealer(@NotNull class_1657 player) {
            Intrinsics.checkNotNullParameter(player, "player");
            return alreadyHealing.contains(player.method_5667());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

