/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.runner.graal;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.util.FileUtils;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0011\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u001c\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler;", "", "", "attemptUnbundle", "()V", "Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "loadShowdownMetadata", "()Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "Ljava/io/File;", "target", "readShowdownMetadata", "(Ljava/io/File;)Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "<init>", "ShowdownMetadata", "common"})
public final class GraalShowdownUnbundler {
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    public final void attemptUnbundle() {
        File showdownDir = new File("showdown");
        ShowdownMetadata metadata2 = this.loadShowdownMetadata();
        if (!showdownDir.exists() || Cobblemon.INSTANCE.getConfig().getAutoUpdateShowdown()) {
            showdownDir.mkdirs();
            File showdownZip = new File(showdownDir, "showdown.zip");
            File showdownMetadataFile = new File(showdownDir, "showdown.json");
            boolean extract = true;
            if (showdownMetadataFile.exists()) {
                ShowdownMetadata current = this.readShowdownMetadata(showdownMetadataFile);
                ShowdownMetadata showdownMetadata = metadata2;
                Intrinsics.checkNotNull(showdownMetadata);
                double d = showdownMetadata.getShowdownVersion();
                ShowdownMetadata showdownMetadata2 = current;
                Intrinsics.checkNotNull(showdownMetadata2);
                if (d == showdownMetadata2.getShowdownVersion()) {
                    extract = false;
                } else {
                    Cobblemon.INSTANCE.getLOGGER().info("Updating showdown service to version " + metadata2.getShowdownVersion() + ", from version " + current.getShowdownVersion() + "...");
                    File backupDir = new File("showdown-backup");
                    if (backupDir.exists() && backupDir.isDirectory()) {
                        FilesKt.deleteRecursively(backupDir);
                    }
                    FilesKt.copyTo$default(showdownDir, backupDir, false, 0, 6, null);
                }
            }
            if (extract) {
                ResourceLocationExtensionsKt.extractTo(new class_2960("cobblemon", "showdown.zip"), showdownZip);
                ResourceLocationExtensionsKt.extractTo(new class_2960("cobblemon", "showdown.json"), showdownMetadataFile);
                Path path = showdownZip.toPath();
                Intrinsics.checkNotNullExpressionValue(path, "showdownZip.toPath()");
                Path path2 = showdownDir.toPath();
                Intrinsics.checkNotNullExpressionValue(path2, "showdownDir.toPath()");
                FileUtils.INSTANCE.unzipFile(path, path2);
                showdownZip.delete();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ShowdownMetadata loadShowdownMetadata() {
        try {
            void $this$fromJson$iv;
            InputStream inputStream = this.getClass().getResourceAsStream("/assets/cobblemon/showdown.json");
            Intrinsics.checkNotNull(inputStream);
            InputStream inputStream2 = inputStream;
            Gson gson2 = this.gson;
            Intrinsics.checkNotNullExpressionValue(gson2, "gson");
            Gson gson3 = gson2;
            Reader reader$iv = new InputStreamReader(inputStream2);
            boolean $i$f$fromJson = false;
            return (ShowdownMetadata)$this$fromJson$iv.fromJson(reader$iv, ShowdownMetadata.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ShowdownMetadata readShowdownMetadata(File target) {
        try {
            Closeable closeable = new InputStreamReader(new FileInputStream(target));
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)closeable;
                boolean bl = false;
                Gson gson2 = this.gson;
                Intrinsics.checkNotNullExpressionValue(gson2, "gson");
                Gson $this$fromJson$iv = gson2;
                boolean $i$f$fromJson = false;
                ShowdownMetadata showdownMetadata = (ShowdownMetadata)$this$fromJson$iv.fromJson((Reader)it, ShowdownMetadata.class);
                return showdownMetadata;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u00d6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "", "", "component1", "()D", "showdownVersion", "copy", "(D)Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "D", "getShowdownVersion", "<init>", "(D)V", "common"})
    private static final class ShowdownMetadata {
        private final double showdownVersion;

        public ShowdownMetadata(double showdownVersion) {
            this.showdownVersion = showdownVersion;
        }

        public final double getShowdownVersion() {
            return this.showdownVersion;
        }

        public final double component1() {
            return this.showdownVersion;
        }

        @NotNull
        public final ShowdownMetadata copy(double showdownVersion) {
            return new ShowdownMetadata(showdownVersion);
        }

        public static /* synthetic */ ShowdownMetadata copy$default(ShowdownMetadata showdownMetadata, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = showdownMetadata.showdownVersion;
            }
            return showdownMetadata.copy(d);
        }

        @NotNull
        public String toString() {
            return "ShowdownMetadata(showdownVersion=" + this.showdownVersion + ")";
        }

        public int hashCode() {
            return Double.hashCode(this.showdownVersion);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShowdownMetadata)) {
                return false;
            }
            ShowdownMetadata showdownMetadata = (ShowdownMetadata)other;
            return Intrinsics.areEqual((Object)this.showdownVersion, (Object)showdownMetadata.showdownVersion);
        }
    }
}

