/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.runner.graal;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.cobblemon.mod.common.battles.runner.graal.GraalLogger;
import com.cobblemon.mod.common.battles.runner.graal.GraalShowdownUnbundler;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.io.File;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b7\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\tJ\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0004J\u000f\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0004J%\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0017J%\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0017\u0010'\u001a\u00020&8\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\"\u0010,\u001a\u00020+8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0017\u00103\u001a\u0002028\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106\u00a8\u00068"}, d2={"Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownService;", "Lcom/cobblemon/mod/common/battles/runner/ShowdownService;", "", "boot", "()V", "closeConnection", "createContext", "Lcom/google/gson/JsonArray;", "getAbilityIds", "()Lcom/google/gson/JsonArray;", "getItemIds", "getMoves", "", "message", "log", "(Ljava/lang/String;)V", "openConnection", "registerSpecies", "Ljava/util/UUID;", "battleId", "", "messages", "send", "(Ljava/util/UUID;[Ljava/lang/String;)V", "sendFromShowdown", "(Ljava/lang/String;Ljava/lang/String;)V", "sendToShowdown", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "startBattle", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;[Ljava/lang/String;)V", "Lorg/graalvm/polyglot/Context;", "context", "Lorg/graalvm/polyglot/Context;", "getContext", "()Lorg/graalvm/polyglot/Context;", "setContext", "(Lorg/graalvm/polyglot/Context;)V", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Lorg/graalvm/polyglot/Value;", "sendBattleMessageFunction", "Lorg/graalvm/polyglot/Value;", "getSendBattleMessageFunction", "()Lorg/graalvm/polyglot/Value;", "setSendBattleMessageFunction", "(Lorg/graalvm/polyglot/Value;)V", "Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler;", "unbundler", "Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler;", "getUnbundler", "()Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler;", "<init>", "common"})
public final class GraalShowdownService
implements ShowdownService {
    public transient Context context;
    public transient Value sendBattleMessageFunction;
    @NotNull
    private final transient GraalShowdownUnbundler unbundler = new GraalShowdownUnbundler();
    @NotNull
    private final transient Gson gson = new Gson();

    @NotNull
    public final Context getContext() {
        Context context = this.context;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException("context");
        return null;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter(context, "<set-?>");
        this.context = context;
    }

    @NotNull
    public final Value getSendBattleMessageFunction() {
        Value value = this.sendBattleMessageFunction;
        if (value != null) {
            return value;
        }
        Intrinsics.throwUninitializedPropertyAccessException("sendBattleMessageFunction");
        return null;
    }

    public final void setSendBattleMessageFunction(@NotNull Value value) {
        Intrinsics.checkNotNullParameter(value, "<set-?>");
        this.sendBattleMessageFunction = value;
    }

    @NotNull
    public final GraalShowdownUnbundler getUnbundler() {
        return this.unbundler;
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @Override
    public void openConnection() {
        this.unbundler.attemptUnbundle();
        this.createContext();
        this.boot();
    }

    private final void createContext() {
        HostAccess access = HostAccess.newBuilder(HostAccess.ALL).build();
        String[] stringArray = new String[]{"js"};
        Context context = Context.newBuilder(stringArray).allowIO(true).allowExperimentalOptions(true).allowPolyglotAccess(PolyglotAccess.ALL).allowHostAccess(access).allowAllAccess(true).allowCreateThread(true).logHandler(GraalLogger.INSTANCE).option("engine.WarnInterpreterOnly", "false").option("js.commonjs-require", "true").option("js.commonjs-require-cwd", "showdown").option("js.commonjs-core-modules-replacements", "buffer:buffer/,crypto:crypto-browserify,path:path-browserify").allowHostClassLoading(true).allowNativeAccess(true).allowCreateProcess(true).build();
        Intrinsics.checkNotNullExpressionValue(context, "newBuilder(\"js\")\n       \u2026rue)\n            .build()");
        this.setContext(context);
        this.getContext().eval("js", "globalThis.process = {\n    cwd: function() {\n        return '';\n    }\n}");
    }

    @Override
    public void closeConnection() {
        this.getContext().close();
    }

    private final void boot() {
        this.getContext().eval("js", FilesKt.readText$default(new File("showdown/index.js"), null, 1, null));
        Value value = this.getContext().getBindings("js").getMember("sendBattleMessage");
        Intrinsics.checkNotNullExpressionValue(value, "context.getBindings(\"js\"\u2026mber(\"sendBattleMessage\")");
        this.setSendBattleMessageFunction(value);
    }

    @Override
    public void startBattle(@NotNull PokemonBattle battle, @NotNull String[] messages) {
        Intrinsics.checkNotNullParameter(battle, "battle");
        Intrinsics.checkNotNullParameter(messages, "messages");
        Value startBattleFunction = this.getContext().getBindings("js").getMember("startBattle");
        Object[] objectArray = new Object[]{this, battle.getBattleId().toString(), messages};
        startBattleFunction.execute(objectArray);
    }

    @Override
    public void send(@NotNull UUID battleId, @NotNull String[] messages) {
        Intrinsics.checkNotNullParameter(battleId, "battleId");
        Intrinsics.checkNotNullParameter(messages, "messages");
        this.sendToShowdown(battleId, messages);
    }

    @Override
    @NotNull
    public JsonArray getAbilityIds() {
        Value getCobbledAbilityIdsFn = this.getContext().getBindings("js").getMember("getCobbledAbilityIds");
        String arrayResult = getCobbledAbilityIdsFn.execute(new Object[0]).asString();
        Object object = this.gson.fromJson(arrayResult, JsonArray.class);
        Intrinsics.checkNotNullExpressionValue(object, "gson.fromJson(arrayResult, JsonArray::class.java)");
        return (JsonArray)object;
    }

    @Override
    @NotNull
    public JsonArray getMoves() {
        Value getCobbledMovesFn = this.getContext().getBindings("js").getMember("getCobbledMoves");
        String arrayResult = getCobbledMovesFn.execute(new Object[0]).asString();
        Object object = this.gson.fromJson(arrayResult, JsonArray.class);
        Intrinsics.checkNotNullExpressionValue(object, "gson.fromJson(arrayResult, JsonArray::class.java)");
        return (JsonArray)object;
    }

    @Override
    @NotNull
    public JsonArray getItemIds() {
        Value getCobbledItemIdsFn = this.getContext().getBindings("js").getMember("getCobbledItemIds");
        String arrayResult = getCobbledItemIdsFn.execute(new Object[0]).asString();
        Object object = this.gson.fromJson(arrayResult, JsonArray.class);
        Intrinsics.checkNotNullExpressionValue(object, "gson.fromJson(arrayResult, JsonArray::class.java)");
        return (JsonArray)object;
    }

    @Override
    public void registerSpecies() {
        Value receiveSpeciesDataFn = this.getContext().getBindings("js").getMember("receiveSpeciesData");
        Value jsArray = this.getContext().eval("js", "new Array();");
        long index = 0L;
        Iterable $this$forEach$iv = PokemonSpecies.INSTANCE.getSpecies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Species species = (Species)element$iv;
            boolean bl = false;
            long l = index;
            index = l + 1L;
            jsArray.setArrayElement(l, this.gson.toJson((Object)new PokemonSpecies.ShowdownSpecies(species, null)));
            Iterable $this$forEach$iv2 = species.getForms();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FormData form2 = (FormData)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual(form2, species.getStandardForm())) continue;
                long l2 = index;
                index = l2 + 1L;
                jsArray.setArrayElement(l2, this.gson.toJson((Object)new PokemonSpecies.ShowdownSpecies(species, form2)));
            }
        }
        Object[] objectArray = new Object[]{jsArray};
        receiveSpeciesDataFn.execute(objectArray);
    }

    private final void sendToShowdown(UUID battleId, String[] messages) {
        Object[] objectArray = new Object[]{battleId.toString(), messages};
        this.getSendBattleMessageFunction().execute(objectArray);
    }

    public final void sendFromShowdown(@NotNull String battleId, @NotNull String message) {
        Intrinsics.checkNotNullParameter(battleId, "battleId");
        Intrinsics.checkNotNullParameter(message, "message");
        UUID uUID = UUID.fromString(battleId);
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(battleId)");
        ShowdownInterpreter.INSTANCE.interpretMessage(uUID, message);
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Cobblemon.INSTANCE.getLOGGER().info(message);
    }
}

