/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.pokemon;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.pokemon.helditem.HeldItemManager;
import com.cobblemon.mod.common.api.pokemon.helditem.HeldItemProvider;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.actor.MultiPokemonBattleActor;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleUpdateTeamPokemonPacket;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 T2\u00020\u0001:\u0001TB\u0019\u0012\u0006\u0010C\u001a\u00020\u001a\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\bR\u0010SJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0004J\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\"\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001d\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\"\u0010(\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010\u0004\"\u0004\b+\u0010,R\u0011\u0010.\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0017R\u001b\u00104\u001a\u00020/8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0011\u00108\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u0010:\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0017R\u0011\u0010>\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010B\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0017\u0010C\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\bC\u0010\u001c\u001a\u0004\bD\u0010\u001eR#\u0010G\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u00130E8\u0006\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010JR\u0011\u0010N\u001a\u00020K8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\"\u0010O\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010)\u001a\u0004\bP\u0010\u0004\"\u0004\bQ\u0010,\u00a8\u0006U"}, d2={"Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "", "", "canBeSentOut", "()Z", "Lnet/minecraft/class_5250;", "getName", "()Lnet/minecraft/class_5250;", "isSentOut", "", "sendUpdate", "()V", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "actor", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "getActor", "()Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "setActor", "(Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;)V", "", "criticalHits", "I", "getCriticalHits", "()I", "setCriticalHits", "(I)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "effectedPokemon", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getEffectedPokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "", "facedOpponents", "Ljava/util/Set;", "getFacedOpponents", "()Ljava/util/Set;", "gone", "Z", "getGone", "setGone", "(Z)V", "getHealth", "health", "Lcom/cobblemon/mod/common/api/pokemon/helditem/HeldItemManager;", "heldItemManager$delegate", "Lkotlin/Lazy;", "getHeldItemManager", "()Lcom/cobblemon/mod/common/api/pokemon/helditem/HeldItemManager;", "heldItemManager", "Lcom/cobblemon/mod/common/pokemon/IVs;", "getIvs", "()Lcom/cobblemon/mod/common/pokemon/IVs;", "ivs", "getMaxHealth", "maxHealth", "Lcom/cobblemon/mod/common/api/moves/MoveSet;", "getMoveSet", "()Lcom/cobblemon/mod/common/api/moves/MoveSet;", "moveSet", "Lcom/cobblemon/mod/common/pokemon/Nature;", "getNature", "()Lcom/cobblemon/mod/common/pokemon/Nature;", "nature", "originalPokemon", "getOriginalPokemon", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "statChanges", "Ljava/util/Map;", "getStatChanges", "()Ljava/util/Map;", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "uuid", "willBeSwitchedIn", "getWillBeSwitchedIn", "setWillBeSwitchedIn", "<init>", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Companion", "common"})
public class BattlePokemon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Pokemon originalPokemon;
    @NotNull
    private final Pokemon effectedPokemon;
    public BattleActor actor;
    @NotNull
    private final Map<Stat, Integer> statChanges;
    private boolean gone;
    private boolean willBeSwitchedIn;
    @NotNull
    private final Set<BattlePokemon> facedOpponents;
    private int criticalHits;
    @NotNull
    private final Lazy heldItemManager$delegate;

    public BattlePokemon(@NotNull Pokemon originalPokemon, @NotNull Pokemon effectedPokemon) {
        Intrinsics.checkNotNullParameter(originalPokemon, "originalPokemon");
        Intrinsics.checkNotNullParameter(effectedPokemon, "effectedPokemon");
        this.originalPokemon = originalPokemon;
        this.effectedPokemon = effectedPokemon;
        this.statChanges = new LinkedHashMap();
        this.facedOpponents = new LinkedHashSet();
        this.heldItemManager$delegate = LazyKt.lazy((Function0)new Function0<HeldItemManager>(this){
            final /* synthetic */ BattlePokemon this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HeldItemManager invoke() {
                return HeldItemProvider.INSTANCE.provide(this.this$0);
            }
        });
    }

    public /* synthetic */ BattlePokemon(Pokemon pokemon, Pokemon pokemon2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pokemon2 = pokemon;
        }
        this(pokemon, pokemon2);
    }

    @NotNull
    public final Pokemon getOriginalPokemon() {
        return this.originalPokemon;
    }

    @NotNull
    public final Pokemon getEffectedPokemon() {
        return this.effectedPokemon;
    }

    @NotNull
    public final BattleActor getActor() {
        BattleActor battleActor = this.actor;
        if (battleActor != null) {
            return battleActor;
        }
        Intrinsics.throwUninitializedPropertyAccessException("actor");
        return null;
    }

    public final void setActor(@NotNull BattleActor battleActor) {
        Intrinsics.checkNotNullParameter(battleActor, "<set-?>");
        this.actor = battleActor;
    }

    @NotNull
    public final UUID getUuid() {
        UUID uUID = this.effectedPokemon.getUuid();
        Intrinsics.checkNotNullExpressionValue(uUID, "effectedPokemon.uuid");
        return uUID;
    }

    public final int getHealth() {
        return this.effectedPokemon.getCurrentHealth();
    }

    public final int getMaxHealth() {
        return this.effectedPokemon.getHp();
    }

    @NotNull
    public final IVs getIvs() {
        return this.effectedPokemon.getIvs();
    }

    @NotNull
    public final Nature getNature() {
        return this.effectedPokemon.getNature();
    }

    @NotNull
    public final MoveSet getMoveSet() {
        return this.effectedPokemon.getMoveSet();
    }

    @NotNull
    public final Map<Stat, Integer> getStatChanges() {
        return this.statChanges;
    }

    public final boolean getGone() {
        return this.gone;
    }

    public final void setGone(boolean bl) {
        this.gone = bl;
    }

    @Nullable
    public final PokemonEntity getEntity() {
        return this.effectedPokemon.getEntity();
    }

    public final boolean getWillBeSwitchedIn() {
        return this.willBeSwitchedIn;
    }

    public final void setWillBeSwitchedIn(boolean bl) {
        this.willBeSwitchedIn = bl;
    }

    @NotNull
    public final Set<BattlePokemon> getFacedOpponents() {
        return this.facedOpponents;
    }

    public final int getCriticalHits() {
        return this.criticalHits;
    }

    public final void setCriticalHits(int n) {
        this.criticalHits = n;
    }

    @NotNull
    public final HeldItemManager getHeldItemManager() {
        Lazy lazy = this.heldItemManager$delegate;
        return (HeldItemManager)lazy.getValue();
    }

    @NotNull
    public class_5250 getName() {
        class_5250 class_52502;
        if (this.getActor() instanceof PokemonBattleActor || this.getActor() instanceof MultiPokemonBattleActor) {
            class_52502 = this.effectedPokemon.getDisplayName();
        } else {
            Object[] objectArray = new Object[]{this.getActor().getName(), this.effectedPokemon.getDisplayName()};
            class_5250 class_52503 = LocalizationUtilsKt.battleLang("owned_pokemon", objectArray);
            class_52502 = class_52503;
            Intrinsics.checkNotNullExpressionValue(class_52503, "{\n            battleLang\u2026on.displayName)\n        }");
        }
        return class_52502;
    }

    public final void sendUpdate() {
        this.getActor().sendUpdate(new BattleUpdateTeamPokemonPacket(this.effectedPokemon));
    }

    public final boolean isSentOut() {
        boolean bl;
        block3: {
            Iterable<ActiveBattlePokemon> $this$any$iv = this.getActor().getBattle().getActivePokemon();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<ActiveBattlePokemon> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    ActiveBattlePokemon element$iv;
                    ActiveBattlePokemon it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getBattlePokemon(), this)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean canBeSentOut() {
        return !this.isSentOut() && !this.willBeSwitchedIn && this.getHealth() > 0;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon$Companion;", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "safeCopyOf", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BattlePokemon safeCopyOf(@NotNull Pokemon pokemon) {
            Intrinsics.checkNotNullParameter(pokemon, "pokemon");
            return new BattlePokemon(pokemon, Pokemon.clone$default(pokemon, false, false, 3, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

