/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.actor;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.experience.BattleExperienceSource;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.AddExperienceResult;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\"\u001a\u00020\u000f\u0012\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040#\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001e\u001a\u00020\u001d8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/battles/actor/PlayerBattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/EntityBackedBattleActor;", "Lnet/minecraft/class_3222;", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "", "experience", "", "awardExperience", "(Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;I)V", "Lnet/minecraft/class_5250;", "getName", "()Lnet/minecraft/class_5250;", "", "Ljava/util/UUID;", "getPlayerUUIDs", "()Ljava/util/Set;", "", "name", "nameOwned", "(Ljava/lang/String;)Lnet/minecraft/class_5250;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "packet", "sendUpdate", "(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "getEntity", "()Lnet/minecraft/class_3222;", "entity", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "type", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "getType", "()Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "uuid", "", "pokemonList", "<init>", "(Ljava/util/UUID;Ljava/util/List;)V", "common"})
public final class PlayerBattleActor
extends BattleActor
implements EntityBackedBattleActor<class_3222> {
    @NotNull
    private final ActorType type;

    public PlayerBattleActor(@NotNull UUID uuid2, @NotNull List<? extends BattlePokemon> pokemonList) {
        Intrinsics.checkNotNullParameter(uuid2, "uuid");
        Intrinsics.checkNotNullParameter(pokemonList, "pokemonList");
        super(uuid2, CollectionsKt.toMutableList((Collection)pokemonList));
        this.type = ActorType.PLAYER;
    }

    @Override
    @Nullable
    public class_3222 getEntity() {
        return PlayerExtensionsKt.getPlayer(this.getUuid());
    }

    @Override
    @NotNull
    public class_5250 getName() {
        class_5250 class_52502;
        class_3222 class_32222 = this.getEntity();
        if ((class_32222 != null && (class_32222 = class_32222.method_5477()) != null ? class_32222.method_27661() : (class_52502 = null)) == null) {
            class_52502 = TextKt.red("Offline Player");
        }
        return class_52502;
    }

    @Override
    @NotNull
    public class_5250 nameOwned(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Object[] objectArray = new Object[]{this.getName(), name};
        class_5250 class_52502 = LocalizationUtilsKt.battleLang("owned_pokemon", objectArray);
        Intrinsics.checkNotNullExpressionValue(class_52502, "battleLang(\"owned_pokemon\", this.getName(), name)");
        return class_52502;
    }

    @Override
    @NotNull
    public ActorType getType() {
        return this.type;
    }

    @NotNull
    public Set<UUID> getPlayerUUIDs() {
        return SetsKt.setOf(this.getUuid());
    }

    @Override
    public void awardExperience(@NotNull BattlePokemon battlePokemon, int experience) {
        block4: {
            BattleExperienceSource source;
            block5: {
                Intrinsics.checkNotNullParameter(battlePokemon, "battlePokemon");
                if (this.getBattle().isPvP() && !Cobblemon.INSTANCE.getConfig().getAllowExperienceFromPvP()) {
                    return;
                }
                source = new BattleExperienceSource(this.getBattle(), CollectionsKt.toList((Iterable)battlePokemon.getFacedOpponents()));
                if (!Intrinsics.areEqual(battlePokemon.getEffectedPokemon(), battlePokemon.getOriginalPokemon()) || experience <= 0) break block4;
                class_3222 class_32222 = PlayerExtensionsKt.getPlayer(this.getUuid());
                if (class_32222 == null) break block5;
                class_3222 it = class_32222;
                boolean bl = false;
                AddExperienceResult addExperienceResult = battlePokemon.getEffectedPokemon().addExperienceWithPlayer(it, source, experience);
                if (addExperienceResult != null) break block4;
            }
            PlayerBattleActor $this$awardExperience_u24lambda_u2d1 = this;
            boolean bl = false;
            battlePokemon.getEffectedPokemon().addExperience(source, experience);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendUpdate(@NotNull NetworkPacket packet) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(packet, "packet");
        Iterable iterable = this.getPlayerUUIDs();
        CobblemonNetwork cobblemonNetwork = CobblemonNetwork.INSTANCE;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            class_3222 it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (PlayerExtensionsKt.getPlayer(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        cobblemonNetwork.sendToPlayers((List)destination$iv$iv, packet);
    }
}

