/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\u0004R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/battles/ShowdownThread;", "Ljava/lang/Thread;", "", "launch", "()V", "Ljava/lang/Runnable;", "action", "queue", "(Ljava/lang/Runnable;)V", "run", "Ljava/util/concurrent/CountDownLatch;", "latch", "Ljava/util/concurrent/CountDownLatch;", "Ljava/util/Queue;", "whenReady", "Ljava/util/Queue;", "<init>", "common"})
public final class ShowdownThread
extends Thread {
    @NotNull
    private final CountDownLatch latch = new CountDownLatch(1);
    @NotNull
    private final Queue<Runnable> whenReady = new LinkedList();

    public ShowdownThread() {
        super("Cobblemon Showdown");
    }

    public final void launch() {
        this.start();
        this.latch.await();
        for (Runnable action : this.whenReady) {
            action.run();
        }
    }

    public final void queue(@NotNull Runnable action) {
        Intrinsics.checkNotNullParameter(action, "action");
        if (this.latch.getCount() == 0L) {
            action.run();
        } else {
            this.whenReady.add(action);
        }
    }

    @Override
    public void run() {
        Cobblemon.INSTANCE.getLOGGER().info("Starting showdown service...");
        ShowdownService.Companion.get().openConnection();
        Cobblemon.INSTANCE.getLOGGER().info("Showdown has been started!");
        this.latch.countDown();
    }
}

