/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.pokemon.helditem.HeldItemProvider;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b-\u0010\u0010J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0010J\u0017\u0010\u001c\u001a\u00020\u001b*\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001f\u0010#\u001a\n \"*\u0004\u0018\u00010!0!8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R#\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020(0'8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lcom/cobblemon/mod/common/battles/BattleRegistry;", "", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "closeBattle", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Ljava/util/UUID;", "id", "getBattle", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "Lnet/minecraft/class_3222;", "serverPlayerEntity", "getBattleByParticipatingPlayer", "(Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "onServerStarted", "()V", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "battleFormat", "Lcom/cobblemon/mod/common/battles/BattleSide;", "side1", "side2", "startBattle", "(Lcom/cobblemon/mod/common/battles/BattleFormat;Lcom/cobblemon/mod/common/battles/BattleSide;Lcom/cobblemon/mod/common/battles/BattleSide;)Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "tick", "", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "", "packTeam", "(Ljava/util/List;)Ljava/lang/String;", "Ljava/util/concurrent/ConcurrentHashMap;", "battleMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "", "Lcom/cobblemon/mod/common/battles/BattleRegistry$BattleChallenge;", "pvpChallenges", "Ljava/util/Map;", "getPvpChallenges", "()Ljava/util/Map;", "<init>", "BattleChallenge", "common"})
public final class BattleRegistry {
    @NotNull
    public static final BattleRegistry INSTANCE = new BattleRegistry();
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    @NotNull
    private static final ConcurrentHashMap<UUID, PokemonBattle> battleMap = new ConcurrentHashMap();
    @NotNull
    private static final Map<UUID, BattleChallenge> pvpChallenges = new LinkedHashMap();

    private BattleRegistry() {
    }

    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final Map<UUID, BattleChallenge> getPvpChallenges() {
        return pvpChallenges;
    }

    public final void onServerStarted() {
        battleMap.clear();
        pvpChallenges.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String packTeam(@NotNull List<? extends BattlePokemon> $this$packTeam) {
        Intrinsics.checkNotNullParameter($this$packTeam, "<this>");
        List team = new ArrayList();
        for (BattlePokemon battlePokemon : $this$packTeam) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            String string;
            String string2;
            Pokemon pk = battlePokemon.getEffectedPokemon();
            StringBuilder packedTeamBuilder = new StringBuilder();
            packedTeamBuilder.append(pk.showdownId() + "|");
            packedTeamBuilder.append("|");
            packedTeamBuilder.append(pk.getUuid() + "|");
            packedTeamBuilder.append(pk.getCurrentHealth() + "|");
            if (pk.getStatus() != null) {
                PersistentStatusContainer persistentStatusContainer = pk.getStatus();
                Intrinsics.checkNotNull(persistentStatusContainer);
                string2 = persistentStatusContainer.getStatus().getShowdownName();
            } else {
                string2 = "";
            }
            String showdownStatus = string2;
            packedTeamBuilder.append(showdownStatus + "|");
            PersistentStatus[] persistentStatusArray = new PersistentStatus[]{Statuses.INSTANCE.getSLEEP(), Statuses.INSTANCE.getFROZEN()};
            PersistentStatusContainer persistentStatusContainer = pk.getStatus();
            if (CollectionsKt.contains((Iterable)CollectionsKt.listOf(persistentStatusArray), persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null)) {
                packedTeamBuilder.append("2|");
            } else {
                packedTeamBuilder.append("-1|");
            }
            if ((string = HeldItemProvider.INSTANCE.provideShowdownId(battlePokemon)) == null) {
                string = "";
            }
            String heldItemID = string;
            packedTeamBuilder.append(heldItemID + "|");
            packedTeamBuilder.append(StringsKt.replace$default(pk.getAbility().getName(), "_", "", false, 4, null) + "|");
            packedTeamBuilder.append(CollectionsKt.joinToString$default(pk.getMoveSet().getMoves(), ",", null, null, 0, null, packTeam.1.INSTANCE, 30, null) + "|");
            packedTeamBuilder.append(CollectionsKt.joinToString$default(pk.getMoveSet().getMoves(), ",", null, null, 0, null, packTeam.2.INSTANCE, 30, null) + "|");
            packedTeamBuilder.append(pk.getNature().getName().method_12832() + "|");
            Iterable $this$map$iv = Stats.Companion.getPERMANENT();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Stat stat = (Stat)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(pk.getEvs().getOrDefault((Stat)it));
            }
            String evsInOrder = CollectionsKt.joinToString$default((List)destination$iv$iv, ",", null, null, 0, null, null, 62, null);
            packedTeamBuilder.append(evsInOrder + "|");
            packedTeamBuilder.append(pk.getGender().getShowdownName() + "|");
            Iterable $this$map$iv2 = Stats.Companion.getPERMANENT();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Stat bl = (Stat)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(pk.getIvs().getOrDefault((Stat)it));
            }
            String ivsInOrder = CollectionsKt.joinToString$default((List)destination$iv$iv2, ",", null, null, 0, null, null, 62, null);
            packedTeamBuilder.append(ivsInOrder + "|");
            packedTeamBuilder.append((pk.getShiny() ? "S" : "") + "|");
            packedTeamBuilder.append(pk.getLevel() + "|");
            packedTeamBuilder.append(pk.getFriendship() + ",");
            String string3 = battlePokemon.getEffectedPokemon().getCaughtBall().getName().method_12832();
            Intrinsics.checkNotNullExpressionValue(string3, "pokemon.effectedPokemon.caughtBall.name.path");
            String pokeball = StringsKt.replace$default(string3, "_", "", false, 4, null);
            packedTeamBuilder.append(pokeball + ",");
            packedTeamBuilder.append(",");
            packedTeamBuilder.append(",");
            packedTeamBuilder.append(",");
            packedTeamBuilder.append(",");
            String string4 = packedTeamBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string4, "packedTeamBuilder.toString()");
            team.add(string4);
        }
        return CollectionsKt.joinToString$default(team, "]", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PokemonBattle startBattle(@NotNull BattleFormat battleFormat, @NotNull BattleSide side1, @NotNull BattleSide side2) {
        Intrinsics.checkNotNullParameter(battleFormat, "battleFormat");
        Intrinsics.checkNotNullParameter(side1, "side1");
        Intrinsics.checkNotNullParameter(side2, "side2");
        PokemonBattle battle = new PokemonBattle(battleFormat, side1, side2);
        Map map = battleMap;
        UUID uUID = battle.getBattleId();
        Intrinsics.checkNotNullExpressionValue(uUID, "battle.battleId");
        map.put(uUID, battle);
        List messages = new ArrayList();
        messages.add(">start { \"format\": " + battleFormat.toFormatJSON() + " }");
        int actorIndex = 1;
        for (BattleActor actor : battle.getSide1().getActors()) {
            actor.setShowdownId("p" + actorIndex);
            actor.setBattle(battle);
            actorIndex += 2;
        }
        actorIndex = 2;
        for (BattleActor actor : battle.getSide2().getActors()) {
            actor.setShowdownId("p" + actorIndex);
            actor.setBattle(battle);
            actorIndex += 2;
        }
        for (BattleActor actor : battle.getActors()) {
            void $this$mapNotNullTo$iv$iv;
            int n = battleFormat.getBattleType().getSlotsPerActor();
            int actor2 = 0;
            while (actor2 < n) {
                int it = actor2++;
                boolean bl = false;
                actor.getActivePokemon().add(new ActiveBattlePokemon(actor, null, 2, null));
            }
            Iterable $this$mapNotNull$iv = actor.getPokemonList();
            boolean $i$f$mapNotNull = false;
            Iterable bl = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PokemonEntity it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                BattlePokemon it = (BattlePokemon)element$iv$iv;
                boolean bl3 = false;
                if (it.getEntity() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List entities = (List)destination$iv$iv;
            Iterable $this$forEach$iv = entities;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                PokemonEntity it = (PokemonEntity)element$iv;
                boolean bl5 = false;
                it.getBattleId().set(Optional.of(battle.getBattleId()));
            }
        }
        Iterable<BattleActor> $this$sortedBy$iv = battle.getActors();
        boolean $i$f$sortedBy = false;
        for (BattleActor actor : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                BattleActor it = (BattleActor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getShowdownId());
                it = (BattleActor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getShowdownId()));
            }
        })) {
            messages.add(">player " + actor.getShowdownId() + " {\"name\":\"" + actor.getUuid() + "\",\"team\":\"" + this.packTeam(actor.getPokemonList()) + "\"}");
        }
        $this$sortedBy$iv = battle.getActors();
        $i$f$sortedBy = false;
        for (BattleActor actor : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                BattleActor it = (BattleActor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getShowdownId());
                it = (BattleActor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getShowdownId()));
            }
        })) {
            messages.add(">" + actor.getShowdownId() + " team " + ((Collection)actor.getPokemonList()).size());
        }
        ShowdownService showdownService = ShowdownService.Companion.get();
        Collection $this$toTypedArray$iv = messages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull(stringArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        showdownService.startBattle(battle, stringArray);
        return battle;
    }

    public final void closeBattle(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter(battle, "battle");
        battleMap.remove(battle.getBattleId());
    }

    @Nullable
    public final PokemonBattle getBattle(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter(id, "id");
        return battleMap.get(id);
    }

    @Nullable
    public final PokemonBattle getBattleByParticipatingPlayer(@NotNull class_3222 serverPlayerEntity) {
        Object v2;
        block5: {
            Intrinsics.checkNotNullParameter(serverPlayerEntity, "serverPlayerEntity");
            Collection<PokemonBattle> collection = battleMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, "battleMap.values");
            Iterable iterable = collection;
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    PokemonBattle it = (PokemonBattle)t;
                    boolean bl2 = false;
                    Iterable<BattleActor> $this$any$iv = it.getActors();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<BattleActor> iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            BattleActor element$iv;
                            BattleActor it2 = element$iv = iterator2.next();
                            boolean bl3 = false;
                            if (!it2.isForPlayer(serverPlayerEntity)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        return v2;
    }

    public final void tick() {
        battleMap.forEachValue(Long.MAX_VALUE, BattleRegistry::tick$lambda-9);
    }

    private static final void tick$lambda-9(PokemonBattle it) {
        it.tick();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001f\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/battles/BattleRegistry$BattleChallenge;", "", "", "isExpired", "()Z", "Ljava/util/UUID;", "challengedPlayerUUID", "Ljava/util/UUID;", "getChallengedPlayerUUID", "()Ljava/util/UUID;", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "challengedTime", "Ljava/time/Instant;", "getChallengedTime", "()Ljava/time/Instant;", "", "expiryTimeSeconds", "I", "getExpiryTimeSeconds", "()I", "setExpiryTimeSeconds", "(I)V", "<init>", "(Ljava/util/UUID;I)V", "common"})
    public static final class BattleChallenge {
        @NotNull
        private final UUID challengedPlayerUUID;
        private int expiryTimeSeconds;
        private final Instant challengedTime;

        public BattleChallenge(@NotNull UUID challengedPlayerUUID, int expiryTimeSeconds) {
            Intrinsics.checkNotNullParameter(challengedPlayerUUID, "challengedPlayerUUID");
            this.challengedPlayerUUID = challengedPlayerUUID;
            this.expiryTimeSeconds = expiryTimeSeconds;
            this.challengedTime = Instant.now();
        }

        public /* synthetic */ BattleChallenge(UUID uUID, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 60;
            }
            this(uUID, n);
        }

        @NotNull
        public final UUID getChallengedPlayerUUID() {
            return this.challengedPlayerUUID;
        }

        public final int getExpiryTimeSeconds() {
            return this.expiryTimeSeconds;
        }

        public final void setExpiryTimeSeconds(int n) {
            this.expiryTimeSeconds = n;
        }

        public final Instant getChallengedTime() {
            return this.challengedTime;
        }

        public final boolean isExpired() {
            return Instant.now().isAfter(this.challengedTime.plusSeconds(this.expiryTimeSeconds));
        }
    }
}

