/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartError;
import com.cobblemon.mod.common.battles.BattleStartResult;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.SuccessfulBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ[\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013JQ\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/cobblemon/mod/common/battles/BattleBuilder;", "", "Lnet/minecraft/class_3222;", "player", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "Ljava/util/UUID;", "leadingPokemon", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "battleFormat", "", "cloneParties", "healFirst", "", "fleeDistance", "Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "party", "Lcom/cobblemon/mod/common/battles/BattleStartResult;", "pve", "(Lnet/minecraft/class_3222;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Ljava/util/UUID;Lcom/cobblemon/mod/common/battles/BattleFormat;ZZFLcom/cobblemon/mod/common/api/storage/party/PartyStore;)Lcom/cobblemon/mod/common/battles/BattleStartResult;", "player1", "player2", "Lkotlin/Function1;", "partyAccessor", "pvp1v1", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;Lcom/cobblemon/mod/common/battles/BattleFormat;ZZLkotlin/jvm/functions/Function1;)Lcom/cobblemon/mod/common/battles/BattleStartResult;", "<init>", "()V", "common"})
public final class BattleBuilder {
    @NotNull
    public static final BattleBuilder INSTANCE = new BattleBuilder();

    private BattleBuilder() {
    }

    @NotNull
    public final BattleStartResult pvp1v1(@NotNull class_3222 player1, @NotNull class_3222 player2, @NotNull BattleFormat battleFormat, boolean cloneParties, boolean healFirst, @NotNull Function1<? super class_3222, ? extends PartyStore> partyAccessor) {
        BattleStartResult battleStartResult;
        Intrinsics.checkNotNullParameter(player1, "player1");
        Intrinsics.checkNotNullParameter(player2, "player2");
        Intrinsics.checkNotNullParameter(battleFormat, "battleFormat");
        Intrinsics.checkNotNullParameter(partyAccessor, "partyAccessor");
        List team1 = PartyStore.toBattleTeam$default(partyAccessor.invoke((class_3222)player1), cloneParties, !healFirst, null, 4, null);
        List team2 = PartyStore.toBattleTeam$default(partyAccessor.invoke((class_3222)player2), cloneParties, !healFirst, null, 4, null);
        UUID uUID = player1.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "player1.uuid");
        PlayerBattleActor player1Actor = new PlayerBattleActor(uUID, team1);
        UUID uUID2 = player2.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID2, "player2.uuid");
        PlayerBattleActor player2Actor = new PlayerBattleActor(uUID2, team2);
        ErroredBattleStart errors = new ErroredBattleStart(null, null, 3, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to(player1, player1Actor), TuplesKt.to(player2, player2Actor)};
        for (Pair pair : pairArray) {
            class_3222 player = (class_3222)pair.component1();
            PlayerBattleActor actor = (PlayerBattleActor)pair.component2();
            if (actor.getPokemonList().size() < battleFormat.getBattleType().getSlotsPerActor()) {
                ((Collection)errors.getParticipantErrors().get((Object)actor)).add(BattleStartError.Companion.insufficientPokemon(player, battleFormat.getBattleType().getSlotsPerActor(), actor.getPokemonList().size()));
            }
            if (BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player) == null) continue;
            ((Collection)errors.getParticipantErrors().get((Object)actor)).add(BattleStartError.Companion.alreadyInBattle(player));
        }
        if (errors.isEmpty()) {
            Object[] objectArray = new BattleActor[]{player1Actor};
            BattleSide battleSide = new BattleSide((BattleActor[])objectArray);
            objectArray = new BattleActor[]{player2Actor};
            battleStartResult = new SuccessfulBattleStart(BattleRegistry.INSTANCE.startBattle(battleFormat, battleSide, new BattleSide((BattleActor[])objectArray)));
        } else {
            battleStartResult = errors;
        }
        return battleStartResult;
    }

    public static /* synthetic */ BattleStartResult pvp1v1$default(BattleBuilder battleBuilder, class_3222 class_32222, class_3222 class_32223, BattleFormat battleFormat, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            battleFormat = BattleFormat.Companion.getGEN_9_SINGLES();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            function1 = pvp1v1.1.INSTANCE;
        }
        return battleBuilder.pvp1v1(class_32222, class_32223, battleFormat, bl, bl2, function1);
    }

    @NotNull
    public final BattleStartResult pve(@NotNull class_3222 player, @NotNull PokemonEntity pokemonEntity, @Nullable UUID leadingPokemon, @NotNull BattleFormat battleFormat, boolean cloneParties, boolean healFirst, float fleeDistance, @NotNull PartyStore party) {
        BattleStartResult battleStartResult;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(pokemonEntity, "pokemonEntity");
        Intrinsics.checkNotNullParameter(battleFormat, "battleFormat");
        Intrinsics.checkNotNullParameter(party, "party");
        List<BattlePokemon> playerTeam = party.toBattleTeam(cloneParties, !healFirst, leadingPokemon);
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "player.uuid");
        PlayerBattleActor playerActor = new PlayerBattleActor(uUID, (List<? extends BattlePokemon>)playerTeam);
        UUID uUID2 = pokemonEntity.getPokemon().getUuid();
        Intrinsics.checkNotNullExpressionValue(uUID2, "pokemonEntity.pokemon.uuid");
        PokemonBattleActor wildActor = new PokemonBattleActor(uUID2, new BattlePokemon(pokemonEntity.getPokemon(), null, 2, null), fleeDistance, null, 8, null);
        ErroredBattleStart errors = new ErroredBattleStart(null, null, 3, null);
        if (playerActor.getPokemonList().size() < battleFormat.getBattleType().getSlotsPerActor()) {
            ((Collection)errors.getParticipantErrors().get((Object)playerActor)).add(BattleStartError.Companion.insufficientPokemon(player, battleFormat.getBattleType().getSlotsPerActor(), playerActor.getPokemonList().size()));
        }
        if (BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player) != null) {
            ((Collection)errors.getParticipantErrors().get((Object)playerActor)).add(BattleStartError.Companion.alreadyInBattle(playerActor));
        }
        if (((Optional)pokemonEntity.getBattleId().get()).isPresent()) {
            ((Collection)errors.getParticipantErrors().get((Object)wildActor)).add(BattleStartError.Companion.alreadyInBattle(wildActor));
        }
        if (errors.isEmpty()) {
            BattleActor[] battleActorArray = new BattleActor[]{playerActor};
            BattleSide battleSide = new BattleSide(battleActorArray);
            battleActorArray = new BattleActor[]{wildActor};
            PokemonBattle battle = BattleRegistry.INSTANCE.startBattle(battleFormat, battleSide, new BattleSide(battleActorArray));
            if (!cloneParties) {
                pokemonEntity.getBattleId().set(Optional.of(battle.getBattleId()));
            }
            battleStartResult = new SuccessfulBattleStart(battle);
        } else {
            battleStartResult = errors;
        }
        return battleStartResult;
    }

    public static /* synthetic */ BattleStartResult pve$default(BattleBuilder battleBuilder, class_3222 class_32222, PokemonEntity pokemonEntity, UUID uUID, BattleFormat battleFormat, boolean bl, boolean bl2, float f, PartyStore partyStore, int n, Object object) {
        if ((n & 4) != 0) {
            uUID = null;
        }
        if ((n & 8) != 0) {
            battleFormat = BattleFormat.Companion.getGEN_9_SINGLES();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            f = Cobblemon.INSTANCE.getConfig().getDefaultFleeDistance();
        }
        if ((n & 0x80) != 0) {
            partyStore = PlayerExtensionsKt.party(class_32222);
        }
        return battleBuilder.pve(class_32222, pokemonEntity, uUID, battleFormat, bl, bl2, f, partyStore);
    }
}

