/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.player.adapter;

import com.cobblemon.mod.common.api.storage.player.PlayerAdvancementData;
import com.cobblemon.mod.common.api.storage.player.PlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerDataExtension;
import com.cobblemon.mod.common.api.storage.player.adapter.PlayerDataExtensionAdapter;
import com.cobblemon.mod.common.api.storage.player.adapter.PlayerDataFileStoreAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b)\u0010\u0013J\u001f\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010#\u001a\u00020\"8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lcom/cobblemon/mod/common/api/storage/player/adapter/JsonPlayerData;", "Lcom/cobblemon/mod/common/api/storage/player/adapter/PlayerDataFileStoreAdapter;", "Ljava/util/UUID;", "uuid", "Ljava/io/File;", "kotlin.jvm.PlatformType", "file", "(Ljava/util/UUID;)Ljava/io/File;", "", "getSubFile", "(Ljava/util/UUID;)Ljava/lang/String;", "Lcom/cobblemon/mod/common/api/storage/player/PlayerData;", "load", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/storage/player/PlayerData;", "playerData", "", "save", "(Lcom/cobblemon/mod/common/api/storage/player/PlayerData;)V", "saveCache", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "setup", "(Lnet/minecraft/server/MinecraftServer;)V", "", "cache", "Ljava/util/Map;", "Ljava/nio/file/Path;", "savePath", "Ljava/nio/file/Path;", "getSavePath", "()Ljava/nio/file/Path;", "setSavePath", "(Ljava/nio/file/Path;)V", "", "useNestedStructure", "Z", "getUseNestedStructure", "()Z", "setUseNestedStructure", "(Z)V", "<init>", "Companion", "common"})
public final class JsonPlayerData
implements PlayerDataFileStoreAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UUID, PlayerData> cache = new LinkedHashMap();
    public Path savePath;
    private boolean useNestedStructure = true;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter((Type)((Object)PlayerDataExtension.class), (Object)PlayerDataExtensionAdapter.INSTANCE).create();

    @NotNull
    public final Path getSavePath() {
        Path path = this.savePath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException("savePath");
        return null;
    }

    public final void setSavePath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "<set-?>");
        this.savePath = path;
    }

    public final boolean getUseNestedStructure() {
        return this.useNestedStructure;
    }

    public final void setUseNestedStructure(boolean bl) {
        this.useNestedStructure = bl;
    }

    public final void setup(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter(server, "server");
        Path path = server.method_27050(class_5218.field_24182).getParent();
        Intrinsics.checkNotNullExpressionValue(path, "server.getSavePath(World\u2026vePath.PLAYERDATA).parent");
        this.setSavePath(path);
    }

    @NotNull
    public final String getSubFile(@NotNull UUID uuid2) {
        String string;
        Intrinsics.checkNotNullParameter(uuid2, "uuid");
        if (this.useNestedStructure) {
            String string2 = uuid2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "uuid.toString()");
            String string3 = string2;
            int n = 0;
            int n2 = 2;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string4 + "/" + uuid2 + ".json";
        } else {
            string = uuid2 + ".json";
        }
        return string;
    }

    private final File file(UUID uuid2) {
        return this.getSavePath().resolve("cobblemonplayerdata/" + this.getSubFile(uuid2)).toFile();
    }

    @Override
    @NotNull
    public PlayerData load(@NotNull UUID uuid2) {
        PlayerData playerData;
        Intrinsics.checkNotNullParameter(uuid2, "uuid");
        if (this.cache.containsKey(uuid2)) {
            PlayerData playerData2 = this.cache.get(uuid2);
            Intrinsics.checkNotNull(playerData2);
            return playerData2;
        }
        File playerFile = this.file(uuid2);
        playerFile.getParentFile().mkdirs();
        if (playerFile.exists()) {
            Object $this$fromJson$iv;
            Gson gson2 = gson;
            Intrinsics.checkNotNullExpressionValue(gson2, "gson");
            Gson gson3 = gson2;
            Reader reader$iv = new BufferedReader(new FileReader(playerFile));
            boolean $i$f$fromJson = false;
            $this$fromJson$iv = $this$fromJson$iv.fromJson(reader$iv, PlayerData.class);
            PlayerData it = (PlayerData)$this$fromJson$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.cache.put(uuid2, it);
            if (it.getAdvancementData() == null) {
                it.setAdvancementData(new PlayerAdvancementData());
            }
            Object object = $this$fromJson$iv;
            Intrinsics.checkNotNullExpressionValue(object, "{\n            gson.fromJ\u2026}\n            }\n        }");
            playerData = (PlayerData)object;
        } else {
            PlayerData playerData3;
            PlayerData p0 = playerData3 = PlayerData.Companion.default(uuid2);
            boolean bl = false;
            this.save(p0);
            playerData = playerData3;
        }
        return playerData;
    }

    public final void saveCache() {
        Map<UUID, PlayerData> $this$forEach$iv = this.cache;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<UUID, PlayerData> element$iv;
            Map.Entry<UUID, PlayerData> entry = element$iv = iterator2.next();
            boolean bl = false;
            PlayerData pd = entry.getValue();
            this.save(pd);
        }
        this.cache.clear();
    }

    @Override
    public void save(@NotNull PlayerData playerData) {
        Intrinsics.checkNotNullParameter(playerData, "playerData");
        File file = this.file(playerData.getUuid());
        file.getParentFile().mkdirs();
        PrintWriter pw = new PrintWriter(this.file(playerData.getUuid()));
        pw.write(gson.toJson((Object)playerData));
        pw.flush();
        pw.close();
        this.cache.put(playerData.getUuid(), playerData);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u001f\u0010\u0004\u001a\n \u0003*\u0004\u0018\u00010\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/api/storage/player/adapter/JsonPlayerData$Companion;", "", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final Gson getGson() {
            return gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

