/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.party;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.net.messages.client.storage.RemoveClientPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.SwapClientPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.party.InitializePartyPacket;
import com.cobblemon.mod.common.net.messages.client.storage.party.MoveClientPartyPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.storage.party.SetPartyPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u000e\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010]\u001a\u00020J\u00a2\u0006\u0004\ba\u0010bJ\r\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\fJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0005J\u000f\u0010\u001b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0005J\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0096\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020*2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b+\u0010,J\r\u0010-\u001a\u00020\n\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b0\u00101J\r\u00102\u001a\u00020\u0003\u00a2\u0006\u0004\b2\u0010\u0005J\u001f\u00103\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b3\u00104J\u0017\u00105\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b5\u00106J\u0017\u00107\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b7\u00108J\u0017\u0010:\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b:\u0010;J \u0010<\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0004\b<\u0010=J\u001d\u0010<\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0007\u00a2\u0006\u0004\b<\u0010>J!\u0010?\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010/\u001a\u0004\u0018\u00010\u0007H\u0014\u00a2\u0006\u0004\b?\u0010=J\r\u0010@\u001a\u00020\n\u00a2\u0006\u0004\b@\u0010.J\u001f\u0010C\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u00022\u0006\u0010B\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bC\u0010DJ\u001d\u0010C\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020\n\u00a2\u0006\u0004\bC\u0010GJ3\u0010M\u001a\b\u0012\u0004\u0012\u00020L0\u00152\b\b\u0002\u0010H\u001a\u00020\u001c2\b\b\u0002\u0010I\u001a\u00020\u001c2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010J\u00a2\u0006\u0004\bM\u0010NJ\u0015\u0010O\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0007\u00a2\u0006\u0004\bO\u0010PR \u0010R\u001a\b\u0012\u0004\u0012\u00020\u00030Q8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\bR\u0010S\u001a\u0004\b\u000e\u0010TR(\u0010V\u001a\b\u0012\u0004\u0012\u00020J0U8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010W\u001a\u0004\bX\u0010\u0019\"\u0004\bY\u0010ZR\"\u0010[\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070U8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b[\u0010W\u001a\u0004\b\\\u0010\u0019R\u001a\u0010]\u001a\u00020J8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b]\u0010^\u001a\u0004\b_\u0010`\u00a8\u0006c"}, d2={"Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "", "didSleep", "()V", "position", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "get", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "", "slot", "(I)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lcom/cobblemon/mod/common/api/reactive/Observable;", "getAnyChangeObservable", "()Lcom/cobblemon/mod/common/api/reactive/Observable;", "getFirstAvailablePosition", "()Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "", "getHealingRemainderPercent", "()F", "", "Lnet/minecraft/class_3222;", "kotlin.jvm.PlatformType", "getObservingPlayers", "()Ljava/util/List;", "heal", "initialize", "", "isValidPosition", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)Z", "", "iterator", "()Ljava/util/Iterator;", "Lcom/google/gson/JsonObject;", "json", "loadFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "Lnet/minecraft/class_2487;", "nbt", "loadFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "loadPositionFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "occupied", "()I", "pokemon", "remove", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "removeDuplicates", "savePositionToNBT", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lnet/minecraft/class_2487;)V", "saveToJSON", "(Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "saveToNBT", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "player", "sendTo", "(Lnet/minecraft/class_3222;)V", "set", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "(ILcom/cobblemon/mod/common/pokemon/Pokemon;)V", "setAtPosition", "size", "position1", "position2", "swap", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)V", "slot1", "slot2", "(II)V", "clone", "checkHealth", "Ljava/util/UUID;", "leadingPokemon", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "toBattleTeam", "(ZZLjava/util/UUID;)Ljava/util/List;", "trackPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "anyChangeObservable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "", "observerUUIDs", "Ljava/util/List;", "getObserverUUIDs", "setObserverUUIDs", "(Ljava/util/List;)V", "slots", "getSlots", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;)V", "common"})
public class PartyStore
extends PokemonStore<PartyPosition> {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final List<Pokemon> slots;
    @NotNull
    private final SimpleObservable<Unit> anyChangeObservable;
    @NotNull
    private List<UUID> observerUUIDs;

    public PartyStore(@NotNull UUID uuid2) {
        Intrinsics.checkNotNullParameter(uuid2, "uuid");
        this.uuid = uuid2;
        int n = 6;
        PartyStore partyStore = this;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(null);
        }
        partyStore.slots = arrayList;
        this.anyChangeObservable = new SimpleObservable();
        this.observerUUIDs = new ArrayList();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    protected final List<Pokemon> getSlots() {
        return this.slots;
    }

    @NotNull
    protected final SimpleObservable<Unit> getAnyChangeObservable() {
        return this.anyChangeObservable;
    }

    @NotNull
    public final List<UUID> getObserverUUIDs() {
        return this.observerUUIDs;
    }

    public final void setObserverUUIDs(@NotNull List<UUID> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.observerUUIDs = list;
    }

    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        return CollectionsKt.filterNotNull((Iterable)this.slots).iterator();
    }

    @Override
    @Nullable
    public final Pokemon get(int slot) {
        Pokemon pokemon;
        Integer n = slot;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it < this.slots.size() && it >= 0 ? n : null;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            pokemon = this.slots.get(it);
        } else {
            pokemon = null;
        }
        return pokemon;
    }

    @Override
    @Nullable
    public Pokemon get(@NotNull PartyPosition position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return this.get(position.getSlot());
    }

    @Override
    public final void set(int slot, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        this.set(new PartyPosition(slot), pokemon);
    }

    @Override
    protected void setAtPosition(@NotNull PartyPosition position, @Nullable Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (position.getSlot() >= this.slots.size()) {
            throw new IllegalArgumentException("Slot position is out of bounds");
        }
        this.slots.set(position.getSlot(), pokemon);
        if (pokemon != null) {
            StoreCoordinates<?> storeCoordinates = pokemon.getStoreCoordinates().get();
            if (!Intrinsics.areEqual(storeCoordinates != null ? storeCoordinates.getStore() : null, this)) {
                this.trackPokemon(pokemon);
            }
        }
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.anyChangeObservable.emit((Unit[])unitArray);
    }

    public final void trackPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        Observable.DefaultImpls.subscribe$default(pokemon.getChangeObservable().pipe(Observable.Companion.stopAfter((Function1)new Function1<Pokemon, Boolean>(pokemon, this){
            final /* synthetic */ Pokemon $pokemon;
            final /* synthetic */ PartyStore this$0;
            {
                this.$pokemon = $pokemon;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pokemon it) {
                Intrinsics.checkNotNullParameter(it, "it");
                StoreCoordinates<?> storeCoordinates = this.$pokemon.getStoreCoordinates().get();
                return !Intrinsics.areEqual(storeCoordinates != null ? storeCoordinates.getStore() : null, this.this$0);
            }
        })), null, new Function1<Pokemon, Unit>(this){
            final /* synthetic */ PartyStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Pokemon it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Unit[] unitArray = new Unit[]{Unit.INSTANCE};
                this.this$0.getAnyChangeObservable().emit((Unit[])unitArray);
            }
        }, 1, null);
    }

    @Override
    @Nullable
    public PartyPosition getFirstAvailablePosition() {
        int n = this.slots.size();
        for (int i = 0; i < n; ++i) {
            if (this.slots.get(i) != null) continue;
            return new PartyPosition(i);
        }
        return null;
    }

    @Override
    public boolean isValidPosition(@NotNull PartyPosition position) {
        Intrinsics.checkNotNullParameter(position, "position");
        int n = this.slots.size();
        int n2 = position.getSlot();
        return 0 <= n2 ? n2 < n : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<class_3222> getObservingPlayers() {
        List list;
        Object object = DistributionUtilsKt.getServer();
        if (object != null && (object = object.method_3760()) != null && (object = object.method_14571()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                class_3222 it = (class_3222)element$iv$iv;
                boolean bl = false;
                if (!this.observerUUIDs.contains(it.method_5667())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final int size() {
        return this.slots.size();
    }

    public final int occupied() {
        return ((Collection)CollectionsKt.filterNotNull((Iterable)this.slots)).size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendTo(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        CobblemonNetwork.INSTANCE.sendPacket(player, new InitializePartyPacket(false, this.getUuid(), this.slots.size()));
        Iterable $this$forEachIndexed$iv = this.slots;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            if (pokemon == null) continue;
            CobblemonNetwork.INSTANCE.sendPacket(player, new SetPartyPokemonPacket(this.getUuid(), new PartyPosition(index), (Pokemon)pokemon));
        }
    }

    @Override
    public void set(@NotNull PartyPosition position, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        super.set((StorePosition)position, pokemon);
        this.sendPacketToObservers(new SetPartyPokemonPacket(this.getUuid(), position, pokemon));
    }

    @Override
    public boolean remove(@NotNull Pokemon pokemon) {
        boolean bl;
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        if (super.remove(pokemon)) {
            PokemonStore pokemonStore = this;
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue(uUID, "pokemon.uuid");
            this.sendPacketToObservers(new RemoveClientPokemonPacket(pokemonStore, uUID));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public final void swap(int slot1, int slot2) {
        block4: {
            block3: {
                boolean bl = 0 <= slot1 ? slot1 < this.slots.size() : false;
                if (!bl) break block3;
                if (0 <= slot2 ? slot2 < this.slots.size() : false) break block4;
            }
            return;
        }
        this.swap(new PartyPosition(slot1), new PartyPosition(slot2));
    }

    @Override
    public void swap(@NotNull PartyPosition position1, @NotNull PartyPosition position2) {
        Intrinsics.checkNotNullParameter(position1, "position1");
        Intrinsics.checkNotNullParameter(position2, "position2");
        Pokemon pokemon1 = this.get(position1);
        Pokemon pokemon2 = this.get(position2);
        super.swap((StorePosition)position1, (StorePosition)position2);
        if (pokemon1 != null && pokemon2 != null) {
            PokemonStore pokemonStore = this;
            UUID uUID = pokemon1.getUuid();
            Intrinsics.checkNotNullExpressionValue(uUID, "pokemon1.uuid");
            UUID uUID2 = pokemon2.getUuid();
            Intrinsics.checkNotNullExpressionValue(uUID2, "pokemon2.uuid");
            this.sendPacketToObservers(new SwapClientPokemonPacket(pokemonStore, uUID, uUID2));
        } else if (pokemon1 != null || pokemon2 != null) {
            PartyPosition newPosition = pokemon1 == null ? position1 : position2;
            Pokemon pokemon = pokemon1;
            if (pokemon == null) {
                Pokemon pokemon3 = pokemon2;
                pokemon = pokemon3;
                Intrinsics.checkNotNull(pokemon3);
            }
            Pokemon pokemon4 = pokemon;
            UUID uUID = this.getUuid();
            UUID uUID3 = pokemon4.getUuid();
            Intrinsics.checkNotNullExpressionValue(uUID3, "pokemon.uuid");
            this.sendPacketToObservers(new MoveClientPartyPokemonPacket(uUID, uUID3, newPosition));
        }
    }

    @Override
    public void initialize() {
        int n = this.slots.size();
        for (int slot = 0; slot < n; ++slot) {
            Pokemon pokemon;
            if (this.get(slot) == null) continue;
            pokemon.getStoreCoordinates().set(new StoreCoordinates<StorePosition>(this, new PartyPosition(slot)));
            this.trackPokemon(pokemon);
        }
    }

    @Override
    @NotNull
    public class_2487 saveToNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        nbt.method_10569("SlotCount", this.slots.size());
        int n = this.slots.size();
        for (int slot = 0; slot < n; ++slot) {
            Pokemon pokemon = this.get(slot);
            if (pokemon == null) continue;
            nbt.method_10566("Slot" + slot, (class_2520)pokemon.saveToNBT(new class_2487()));
        }
        return nbt;
    }

    @NotNull
    public PartyStore loadFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        int slotCount = nbt.method_10550("SlotCount");
        while (slotCount > this.slots.size()) {
            CollectionsKt.removeLast(this.slots);
        }
        while (slotCount < this.slots.size()) {
            this.slots.add(null);
        }
        int n = this.slots.size();
        for (int slot = 0; slot < n; ++slot) {
            class_2487 pokemonNBT = nbt.method_10562("Slot" + slot);
            if (pokemonNBT.method_33133()) continue;
            Pokemon pokemon = new Pokemon();
            Intrinsics.checkNotNullExpressionValue(pokemonNBT, "pokemonNBT");
            this.slots.set(slot, pokemon.loadFromNBT(pokemonNBT));
        }
        this.removeDuplicates();
        return this;
    }

    @Override
    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        json.addProperty("SlotCount", (Number)this.slots.size());
        int n = this.slots.size();
        for (int slot = 0; slot < n; ++slot) {
            Pokemon pokemon = this.get(slot);
            if (pokemon == null) continue;
            json.add("Slot" + slot, (JsonElement)pokemon.saveToJSON(new JsonObject()));
        }
        return json;
    }

    @NotNull
    public PartyStore loadFromJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        int slotCount = json.get("SlotCount").getAsInt();
        while (slotCount > this.slots.size()) {
            CollectionsKt.removeLast(this.slots);
        }
        while (slotCount < this.slots.size()) {
            this.slots.add(null);
        }
        int n = this.slots.size();
        for (int slot = 0; slot < n; ++slot) {
            String key = "Slot" + slot;
            if (!json.has(key)) continue;
            Pokemon pokemon = new Pokemon();
            JsonObject jsonObject = json.get(key).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue(jsonObject, "json.get(key).asJsonObject");
            this.slots.set(slot, pokemon.loadFromJSON(jsonObject));
        }
        this.removeDuplicates();
        return this;
    }

    public final void removeDuplicates() {
        List knownUUIDs = new ArrayList();
        int n = this.slots.size();
        for (int slot = 0; slot < n; ++slot) {
            Pokemon pokemon;
            if (this.get(slot) == null) continue;
            if (!knownUUIDs.contains(pokemon.getUuid())) {
                UUID uUID = pokemon.getUuid();
                Intrinsics.checkNotNullExpressionValue(uUID, "pokemon.uuid");
                knownUUIDs.add(uUID);
                continue;
            }
            this.slots.set(slot, null);
            Unit[] unitArray = new Unit[]{Unit.INSTANCE};
            this.anyChangeObservable.emit((Unit[])unitArray);
        }
    }

    @Override
    @NotNull
    public StoreCoordinates<PartyPosition> loadPositionFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        byte slot = nbt.method_10571("Slot");
        return new StoreCoordinates<StorePosition>(this, new PartyPosition(slot));
    }

    @Override
    public void savePositionToNBT(@NotNull PartyPosition position, @NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        nbt.method_10567("Slot", (byte)position.getSlot());
    }

    @Override
    @NotNull
    public Observable<Unit> getAnyChangeObservable() {
        return this.anyChangeObservable;
    }

    public final void heal() {
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pokemon it = (Pokemon)element$iv;
            boolean bl = false;
            it.heal();
        }
    }

    public final void didSleep() {
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pokemon it = (Pokemon)element$iv;
            boolean bl = false;
            it.didSleep();
        }
    }

    public final float getHealingRemainderPercent() {
        float totalPercent = 0.0f;
        for (Pokemon pokemon : this) {
            totalPercent += 1.0f - (float)pokemon.getCurrentHealth() / (float)pokemon.getHp();
        }
        return totalPercent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BattlePokemon> toBattleTeam(boolean clone, boolean checkHealth, @Nullable UUID leadingPokemon) {
        void $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            BattlePokemon it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pokemon it = (Pokemon)element$iv$iv;
            boolean bl2 = false;
            if ((checkHealth && it.getCurrentHealth() <= 0 ? null : (clone ? BattlePokemon.Companion.safeCopyOf(it) : new BattlePokemon(it, null, 2, null))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(leadingPokemon, this){
            final /* synthetic */ UUID $leadingPokemon$inlined;
            final /* synthetic */ PartyStore this$0;
            {
                this.$leadingPokemon$inlined = uUID;
                this.this$0 = partyStore;
            }

            public final int compare(T a, T b) {
                BattlePokemon it = (BattlePokemon)a;
                boolean bl = false;
                int n = Intrinsics.areEqual(it.getUuid(), this.$leadingPokemon$inlined) ? 0 : CollectionsKt.indexOf(this.this$0, it.getOriginalPokemon()) + 1;
                it = (BattlePokemon)b;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues(comparable, Intrinsics.areEqual(it.getUuid(), this.$leadingPokemon$inlined) ? 0 : CollectionsKt.indexOf(this.this$0, it.getOriginalPokemon()) + 1);
            }
        });
    }

    public static /* synthetic */ List toBattleTeam$default(PartyStore partyStore, boolean bl, boolean bl2, UUID uUID, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toBattleTeam");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            uUID = null;
        }
        return partyStore.toBattleTeam(bl, bl2, uUID);
    }
}

