/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage;

import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.storage.BottomlessPosition;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\b?\u0010@J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019H\u0096\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u001d\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020$2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010'\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010.\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b.\u0010/J!\u00101\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u00100\u001a\u0004\u0018\u00010\u0004H\u0014\u00a2\u0006\u0004\b1\u00102R\u001d\u00100\u001a\b\u0012\u0004\u0012\u00020\u0004038\u0006\u00a2\u0006\f\n\u0004\b0\u00104\u001a\u0004\b5\u00106R\u001d\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010\rR\u001a\u0010;\u001a\u00020:8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\u00a8\u0006A"}, d2={"Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;", "position", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "get", "(Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "", "index", "(I)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "", "getAnyChangeObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getFirstAvailablePosition", "()Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;", "", "Lnet/minecraft/class_3222;", "getObservingPlayers", "()Ljava/util/Set;", "initialize", "()V", "", "isValidPosition", "(Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;)Z", "", "iterator", "()Ljava/util/Iterator;", "Lcom/google/gson/JsonObject;", "json", "loadFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "Lnet/minecraft/class_2487;", "nbt", "loadFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/BottomlessStore;", "Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "loadPositionFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/storage/StoreCoordinates;", "savePositionToNBT", "(Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;Lnet/minecraft/class_2487;)V", "saveToJSON", "(Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "saveToNBT", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "player", "sendTo", "(Lnet/minecraft/class_3222;)V", "pokemon", "setAtPosition", "(Lcom/cobblemon/mod/common/api/storage/BottomlessPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "Ljava/util/List;", "getPokemon", "()Ljava/util/List;", "storeChangeObservable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getStoreChangeObservable", "Ljava/util/UUID;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;)V", "common"})
public class BottomlessStore
extends PokemonStore<BottomlessPosition> {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final List<Pokemon> pokemon;
    @NotNull
    private final SimpleObservable<Unit> storeChangeObservable;

    public BottomlessStore(@NotNull UUID uuid2) {
        Intrinsics.checkNotNullParameter(uuid2, "uuid");
        this.uuid = uuid2;
        this.pokemon = new ArrayList();
        this.storeChangeObservable = new SimpleObservable();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final List<Pokemon> getPokemon() {
        return this.pokemon;
    }

    @NotNull
    public final SimpleObservable<Unit> getStoreChangeObservable() {
        return this.storeChangeObservable;
    }

    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        return this.pokemon.iterator();
    }

    @Override
    @Nullable
    public Pokemon get(@NotNull BottomlessPosition position) {
        Pokemon pokemon;
        Integer n;
        Intrinsics.checkNotNullParameter(position, "position");
        Integer n2 = position.getCurrentIndex();
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = n = it < this.pokemon.size() && it >= 0 ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            pokemon = this.pokemon.get(it);
        } else {
            pokemon = null;
        }
        return pokemon;
    }

    @Override
    @NotNull
    public BottomlessPosition getFirstAvailablePosition() {
        return new BottomlessPosition(this.pokemon.size());
    }

    @Override
    public boolean isValidPosition(@NotNull BottomlessPosition position) {
        Intrinsics.checkNotNullParameter(position, "position");
        return position.getCurrentIndex() >= 0;
    }

    @Override
    @Nullable
    public final Pokemon get(int index) {
        Pokemon pokemon;
        Integer n = index;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 && it < this.pokemon.size() ? n : null;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            pokemon = this.pokemon.get(it);
        } else {
            pokemon = null;
        }
        return pokemon;
    }

    @NotNull
    public Set<class_3222> getObservingPlayers() {
        return SetsKt.emptySet();
    }

    @Override
    public void sendTo(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() {
        Iterable $this$forEachIndexed$iv = this.pokemon;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            pokemon.getStoreCoordinates().set(new StoreCoordinates<StorePosition>(this, new BottomlessPosition(index)));
            Observable.DefaultImpls.subscribe$default(pokemon.getChangeObservable().pipe(Observable.Companion.stopAfter((Function1)new Function1<Pokemon, Boolean>(this){
                final /* synthetic */ BottomlessStore this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Pokemon it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    StoreCoordinates<?> storeCoordinates = it.getStoreCoordinates().get();
                    return !Intrinsics.areEqual(storeCoordinates != null ? storeCoordinates.getStore() : null, this.this$0);
                }
            })), null, new Function1<Pokemon, Unit>(this){
                final /* synthetic */ BottomlessStore this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Pokemon it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    Unit[] unitArray = new Unit[]{Unit.INSTANCE};
                    this.this$0.getStoreChangeObservable().emit((Unit[])unitArray);
                }
            }, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public class_2487 saveToNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Iterable $this$forEachIndexed$iv = this.pokemon;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            nbt.method_10566("Slot" + index, (class_2520)pokemon.saveToNBT(new class_2487()));
        }
        return nbt;
    }

    @NotNull
    public BottomlessStore loadFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        int i = -1;
        while (nbt.method_10545("Slot" + ++i)) {
            Pokemon pokemon = new Pokemon();
            class_2487 class_24872 = nbt.method_10562("Slot" + i);
            Intrinsics.checkNotNullExpressionValue(class_24872, "nbt.getCompound(DataKeys.STORE_SLOT + i)");
            this.pokemon.add(pokemon.loadFromNBT(class_24872));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        Iterable $this$forEachIndexed$iv = this.pokemon;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            json.add("Slot" + index, (JsonElement)pokemon.saveToJSON(new JsonObject()));
        }
        return json;
    }

    @NotNull
    public BottomlessStore loadFromJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        int i = -1;
        while (json.has("Slot" + ++i)) {
            Pokemon pokemon = new Pokemon();
            JsonObject jsonObject = json.getAsJsonObject("Slot" + i);
            Intrinsics.checkNotNullExpressionValue(jsonObject, "json.getAsJsonObject(DataKeys.STORE_SLOT + i)");
            this.pokemon.add(pokemon.loadFromJSON(jsonObject));
        }
        return this;
    }

    @Override
    @NotNull
    public StoreCoordinates<BottomlessPosition> loadPositionFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        byte slot = nbt.method_10571("Slot");
        return new StoreCoordinates<StorePosition>(this, new BottomlessPosition(slot));
    }

    @Override
    public void savePositionToNBT(@NotNull BottomlessPosition position, @NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        nbt.method_10567("Slot", (byte)position.getCurrentIndex());
    }

    @NotNull
    public SimpleObservable<Unit> getAnyChangeObservable() {
        return this.storeChangeObservable;
    }

    @Override
    protected void setAtPosition(@NotNull BottomlessPosition position, @Nullable Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (position.getCurrentIndex() == this.pokemon.size() && pokemon != null) {
            this.pokemon.add(pokemon);
            Unit[] unitArray = new Unit[]{Unit.INSTANCE};
            this.storeChangeObservable.emit((Unit[])unitArray);
        } else {
            int n = this.pokemon.size();
            int n2 = position.getCurrentIndex();
            boolean bl = 0 <= n2 ? n2 < n : false;
            if (bl) {
                if (pokemon != null) {
                    this.pokemon.add(position.getCurrentIndex(), pokemon);
                } else {
                    this.pokemon.remove(position.getCurrentIndex());
                }
                Unit[] unitArray = new Unit[]{Unit.INSTANCE};
                this.storeChangeObservable.emit((Unit[])unitArray);
            }
        }
    }
}

