/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.spawner;

import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawnerManager;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.selection.FlatContextWeightedSelector;
import com.cobblemon.mod.common.api.spawning.selection.SpawningSelector;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0007\n\u0002\b\u000f\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010@\u001a\u00020?\u0012\u0006\u0010S\u001a\u00020\u0012\u0012\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\bd\u0010eJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u001a\u001a\u00020\u00042\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u001e2\u0006\u0010\u001d\u001a\u00020\u001cH&\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b)\u0010*R\"\u0010+\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010\t\"\u0004\b.\u0010/R \u00100\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u0010\rR\"\u00104\u001a\u0002038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0017\u0010;\u001a\u00020:8\u0006\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>R\u001a\u0010@\u001a\u00020?8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b@\u0010A\u001a\u0004\bB\u0010CR\"\u0010E\u001a\u00020D8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR(\u0010K\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010\u001bR\u0016\u0010&\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010PR\u001d\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00020\n8\u0006\u00a2\u0006\f\n\u0004\bQ\u00101\u001a\u0004\bR\u0010\rR\"\u0010S\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010T\u001a\u0004\bU\u0010\u0014\"\u0004\bV\u0010%R\"\u0010X\u001a\u00020W8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bX\u0010Y\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\"\u0010^\u001a\u00020W8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010Y\u001a\u0004\b_\u0010[\"\u0004\b`\u0010]R\"\u0010a\u001a\u00020W8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010Y\u001a\u0004\bb\u0010[\"\u0004\bc\u0010]\u00a8\u0006f"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/TickingSpawner;", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "Lnet/minecraft/class_1297;", "entity", "", "afterSpawn", "(Lnet/minecraft/class_1297;)V", "", "canSpawn", "()Z", "", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "copyInfluences", "()Ljava/util/List;", "", "getAllInfluences", "getCauseEntity", "()Lnet/minecraft/class_1297;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "getSpawnPool", "()Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "getSpawningSelector", "()Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "spawnAction", "performSpawn", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;)V", "Lcom/cobblemon/mod/common/api/spawning/SpawnCause;", "cause", "Lkotlin/Pair;", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "run", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;)Lkotlin/Pair;", "spawnPool", "setSpawnPool", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;)V", "selector", "setSpawningSelector", "(Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;)V", "tick", "()V", "active", "Z", "getActive", "setActive", "(Z)V", "influences", "Ljava/util/List;", "getInfluences", "", "lastSpawnTime", "J", "getLastSpawnTime", "()J", "setLastSpawnTime", "(J)V", "Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "manager", "Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "getManager", "()Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "", "removalCheckTicks", "I", "getRemovalCheckTicks", "()I", "setRemovalCheckTicks", "(I)V", "scheduledSpawn", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "getScheduledSpawn", "()Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "setScheduledSpawn", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "spawnedEntities", "getSpawnedEntities", "spawns", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "getSpawns", "setSpawns", "", "tickTimerMultiplier", "F", "getTickTimerMultiplier", "()F", "setTickTimerMultiplier", "(F)V", "ticksBetweenSpawns", "getTicksBetweenSpawns", "setTicksBetweenSpawns", "ticksUntilNextSpawn", "getTicksUntilNextSpawn", "setTicksUntilNextSpawn", "<init>", "(Ljava/lang/String;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;)V", "common"})
public abstract class TickingSpawner
implements Spawner {
    @NotNull
    private final String name;
    @NotNull
    private SpawnPool spawns;
    @NotNull
    private final SpawnerManager manager;
    @NotNull
    private SpawningSelector selector;
    @NotNull
    private final List<SpawningInfluence> influences;
    private boolean active;
    @NotNull
    private final List<class_1297> spawnedEntities;
    private long lastSpawnTime;
    private float ticksUntilNextSpawn;
    private float ticksBetweenSpawns;
    private float tickTimerMultiplier;
    @Nullable
    private volatile SpawnAction<?> scheduledSpawn;
    private int removalCheckTicks;

    public TickingSpawner(@NotNull String name, @NotNull SpawnPool spawns, @NotNull SpawnerManager manager) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(spawns, "spawns");
        Intrinsics.checkNotNullParameter(manager, "manager");
        this.name = name;
        this.spawns = spawns;
        this.manager = manager;
        this.selector = new FlatContextWeightedSelector();
        this.influences = new ArrayList();
        this.active = true;
        this.spawnedEntities = new ArrayList();
        this.ticksUntilNextSpawn = 100.0f;
        this.ticksBetweenSpawns = 20.0f;
        this.tickTimerMultiplier = 1.0f;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final SpawnPool getSpawns() {
        return this.spawns;
    }

    public final void setSpawns(@NotNull SpawnPool spawnPool) {
        Intrinsics.checkNotNullParameter(spawnPool, "<set-?>");
        this.spawns = spawnPool;
    }

    @NotNull
    public final SpawnerManager getManager() {
        return this.manager;
    }

    @Override
    @NotNull
    public List<SpawningInfluence> getInfluences() {
        return this.influences;
    }

    @Override
    public boolean canSpawn() {
        return this.active;
    }

    @Override
    @NotNull
    public SpawningSelector getSpawningSelector() {
        return this.selector;
    }

    @Override
    public void setSpawningSelector(@NotNull SpawningSelector selector2) {
        Intrinsics.checkNotNullParameter(selector2, "selector");
        this.selector = selector2;
    }

    @Override
    @NotNull
    public SpawnPool getSpawnPool() {
        return this.spawns;
    }

    @Override
    public void setSpawnPool(@NotNull SpawnPool spawnPool) {
        Intrinsics.checkNotNullParameter(spawnPool, "spawnPool");
        this.spawns = spawnPool;
    }

    @Nullable
    public abstract Pair<SpawningContext, SpawnDetail> run(@NotNull SpawnCause var1);

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean bl) {
        this.active = bl;
    }

    @NotNull
    public final List<class_1297> getSpawnedEntities() {
        return this.spawnedEntities;
    }

    public final long getLastSpawnTime() {
        return this.lastSpawnTime;
    }

    public final void setLastSpawnTime(long l) {
        this.lastSpawnTime = l;
    }

    public final float getTicksUntilNextSpawn() {
        return this.ticksUntilNextSpawn;
    }

    public final void setTicksUntilNextSpawn(float f) {
        this.ticksUntilNextSpawn = f;
    }

    public final float getTicksBetweenSpawns() {
        return this.ticksBetweenSpawns;
    }

    public final void setTicksBetweenSpawns(float f) {
        this.ticksBetweenSpawns = f;
    }

    public final float getTickTimerMultiplier() {
        return this.tickTimerMultiplier;
    }

    public final void setTickTimerMultiplier(float f) {
        this.tickTimerMultiplier = f;
    }

    @Nullable
    public final SpawnAction<?> getScheduledSpawn() {
        return this.scheduledSpawn;
    }

    public final void setScheduledSpawn(@Nullable SpawnAction<?> spawnAction) {
        this.scheduledSpawn = spawnAction;
    }

    public final int getRemovalCheckTicks() {
        return this.removalCheckTicks;
    }

    public final void setRemovalCheckTicks(int n) {
        this.removalCheckTicks = n;
    }

    public void tick() {
        int n = this.removalCheckTicks;
        this.removalCheckTicks = n + 1;
        this.getInfluences().removeIf(TickingSpawner::tick$lambda-0);
        if (this.removalCheckTicks == 60) {
            this.spawnedEntities.removeIf(TickingSpawner::tick$lambda-1);
            this.removalCheckTicks = 0;
        }
        if (!this.active) {
            return;
        }
        SpawnAction<?> scheduledSpawn = this.scheduledSpawn;
        if (scheduledSpawn != null) {
            this.performSpawn(scheduledSpawn);
            this.scheduledSpawn = null;
        }
        this.ticksUntilNextSpawn -= this.tickTimerMultiplier;
        if (this.ticksUntilNextSpawn <= 0.0f) {
            Pair<SpawningContext, SpawnDetail> spawn = this.run(new SpawnCause(this, this.chooseBucket(), this.getCauseEntity()));
            this.ticksUntilNextSpawn = this.ticksBetweenSpawns;
            if (spawn != null) {
                SpawningContext ctx = spawn.getFirst();
                SpawnDetail detail = spawn.getSecond();
                SpawnAction<?> spawnAction = detail.doSpawn(ctx);
                this.scheduledSpawn = spawnAction;
            }
        }
    }

    @Override
    public void afterSpawn(@NotNull class_1297 entity2) {
        Intrinsics.checkNotNullParameter(entity2, "entity");
        Spawner.DefaultImpls.afterSpawn(this, entity2);
        this.spawnedEntities.add(entity2);
        this.lastSpawnTime = System.currentTimeMillis();
    }

    public final void performSpawn(@NotNull SpawnAction<?> spawnAction) {
        Intrinsics.checkNotNullParameter(spawnAction, "spawnAction");
        Observable.DefaultImpls.subscribe$default(spawnAction.getEntity(), null, new Function1<class_1297, Unit>(this){
            final /* synthetic */ TickingSpawner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull class_1297 it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.this$0.afterSpawn(it);
            }
        }, 1, null);
        spawnAction.run();
    }

    @Nullable
    public class_1297 getCauseEntity() {
        return null;
    }

    @NotNull
    public final List<SpawningInfluence> getAllInfluences() {
        return CollectionsKt.plus((Collection)this.getInfluences(), (Iterable)this.manager.getInfluences());
    }

    @Override
    @NotNull
    public List<SpawningInfluence> copyInfluences() {
        return CollectionsKt.toMutableList((Collection)this.getAllInfluences());
    }

    @Override
    public void modifySpawn(@NotNull class_1297 entity2) {
        Spawner.DefaultImpls.modifySpawn(this, entity2);
    }

    @Override
    @NotNull
    public List<SpawnDetail> getMatchingSpawns(@NotNull SpawningContext ctx) {
        return Spawner.DefaultImpls.getMatchingSpawns(this, ctx);
    }

    @Override
    @NotNull
    public SpawnBucket chooseBucket() {
        return Spawner.DefaultImpls.chooseBucket(this);
    }

    private static final boolean tick$lambda-0(SpawningInfluence it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isExpired();
    }

    private static final boolean tick$lambda-1(class_1297 it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.method_31481();
    }
}

