/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.spawner;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawnerManager;
import com.cobblemon.mod.common.api.spawning.WorldSlice;
import com.cobblemon.mod.common.api.spawning.context.AreaContextResolver;
import com.cobblemon.mod.common.api.spawning.context.AreaSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.context.calculators.AreaSpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.context.calculators.SpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.spawning.mixins.CachedOnlyChunkAccessor;
import com.cobblemon.mod.common.api.spawning.prospecting.SpawningProspector;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningArea;
import com.cobblemon.mod.common.api.spawning.spawner.TickingSpawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_10;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 62\u00020\u0001:\u00016B\u001f\u0012\u0006\u0010/\u001a\u00020.\u0012\u0006\u00101\u001a\u000200\u0012\u0006\u00103\u001a\u000202\u00a2\u0006\u0004\b4\u00105J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R,\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010(\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u00067"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/AreaSpawner;", "Lcom/cobblemon/mod/common/api/spawning/spawner/TickingSpawner;", "Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;", "area", "constrainArea", "(Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;)Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;", "Lcom/cobblemon/mod/common/api/spawning/SpawnCause;", "cause", "getArea", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;)Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningArea;", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2791;", "chunk", "Lnet/minecraft/util/math/BlockPos$Mutable;", "startPos", "", "isValidStartPoint", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2791;Lnet/minecraft/class_2338$class_2339;)Z", "Lkotlin/Pair;", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "run", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;)Lkotlin/Pair;", "", "Lcom/cobblemon/mod/common/api/spawning/context/calculators/AreaSpawningContextCalculator;", "contextCalculators", "Ljava/util/List;", "getContextCalculators", "()Ljava/util/List;", "setContextCalculators", "(Ljava/util/List;)V", "Lcom/cobblemon/mod/common/api/spawning/prospecting/SpawningProspector;", "prospector", "Lcom/cobblemon/mod/common/api/spawning/prospecting/SpawningProspector;", "getProspector", "()Lcom/cobblemon/mod/common/api/spawning/prospecting/SpawningProspector;", "setProspector", "(Lcom/cobblemon/mod/common/api/spawning/prospecting/SpawningProspector;)V", "Lcom/cobblemon/mod/common/api/spawning/context/AreaContextResolver;", "resolver", "Lcom/cobblemon/mod/common/api/spawning/context/AreaContextResolver;", "getResolver", "()Lcom/cobblemon/mod/common/api/spawning/context/AreaContextResolver;", "setResolver", "(Lcom/cobblemon/mod/common/api/spawning/context/AreaContextResolver;)V", "", "name", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "spawns", "Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "manager", "<init>", "(Ljava/lang/String;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;)V", "Companion", "common"})
public abstract class AreaSpawner
extends TickingSpawner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SpawningProspector prospector;
    @NotNull
    private AreaContextResolver resolver;
    @NotNull
    private List<? extends AreaSpawningContextCalculator<?>> contextCalculators;
    public static final int CHUNK_REACH = 3;

    public AreaSpawner(@NotNull String name, @NotNull SpawnPool spawns, @NotNull SpawnerManager manager) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(spawns, "spawns");
        Intrinsics.checkNotNullParameter(manager, "manager");
        super(name, spawns, manager);
        this.prospector = Cobblemon.INSTANCE.getProspector();
        this.resolver = Cobblemon.INSTANCE.getAreaContextResolver();
        this.contextCalculators = SpawningContextCalculator.Companion.getPrioritizedAreaCalculators();
    }

    @Nullable
    public abstract SpawningArea getArea(@NotNull SpawnCause var1);

    @NotNull
    public final SpawningProspector getProspector() {
        return this.prospector;
    }

    public final void setProspector(@NotNull SpawningProspector spawningProspector) {
        Intrinsics.checkNotNullParameter(spawningProspector, "<set-?>");
        this.prospector = spawningProspector;
    }

    @NotNull
    public final AreaContextResolver getResolver() {
        return this.resolver;
    }

    public final void setResolver(@NotNull AreaContextResolver areaContextResolver2) {
        Intrinsics.checkNotNullParameter(areaContextResolver2, "<set-?>");
        this.resolver = areaContextResolver2;
    }

    @NotNull
    public final List<AreaSpawningContextCalculator<?>> getContextCalculators() {
        return this.contextCalculators;
    }

    public final void setContextCalculators(@NotNull List<? extends AreaSpawningContextCalculator<?>> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.contextCalculators = list;
    }

    @Override
    @Nullable
    public Pair<SpawningContext, SpawnDetail> run(@NotNull SpawnCause cause) {
        SpawningArea constrainedArea;
        SpawningArea area;
        Intrinsics.checkNotNullParameter(cause, "cause");
        SpawningArea spawningArea = area = this.getArea(cause);
        SpawningArea spawningArea2 = constrainedArea = spawningArea != null ? this.constrainArea(spawningArea) : null;
        if (constrainedArea != null) {
            int chunksCovered;
            int numberNearby = constrainedArea.getWorld().method_8390(PokemonEntity.class, class_238.method_30048((class_243)new class_243(Vec3ExtensionsKt.toVec3f(constrainedArea.getCenter())), (double)96.0, (double)1000.0, (double)96.0), AreaSpawner::run$lambda-0).size();
            if ((float)numberNearby / (float)(chunksCovered = 9) >= Cobblemon.INSTANCE.getConfig().getPokemonPerChunk()) {
                return null;
            }
            WorldSlice slice = this.prospector.prospect(this, constrainedArea);
            List<AreaSpawningContext> contexts = this.resolver.resolve(this, this.contextCalculators, slice);
            return this.getSpawningSelector().select(this, contexts);
        }
        return null;
    }

    public final boolean isValidStartPoint(@NotNull class_1937 world, @NotNull class_2791 chunk, @NotNull class_2338.class_2339 startPos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        Intrinsics.checkNotNullParameter(startPos, "startPos");
        int y = startPos.method_10264();
        if (!world.method_8477((class_2338)startPos) || !world.method_8477((class_2338)startPos.method_33098(y + 1))) {
            return false;
        }
        class_2680 mid = chunk.method_8320((class_2338)startPos.method_33098(y));
        class_2680 above = chunk.method_8320((class_2338)startPos.method_33098(y + 1));
        if (!above.method_26171((class_1922)world, (class_2338)startPos, class_10.field_51)) {
            return false;
        }
        return !mid.method_26215();
    }

    @Nullable
    public final SpawningArea constrainArea(@NotNull SpawningArea area) {
        Intrinsics.checkNotNullParameter(area, "area");
        class_2338.class_2339 basePos = new class_2338.class_2339(area.getBaseX(), area.getBaseY(), area.getBaseZ());
        int originalY = area.getBaseY();
        Pair<Integer, Integer> pair = new Pair<Integer, Integer>(class_4076.method_18675((int)area.getBaseX()), class_4076.method_18675((int)area.getBaseZ()));
        int chunkX = ((Number)pair.component1()).intValue();
        int chunkZ = ((Number)pair.component2()).intValue();
        class_2802 class_28022 = area.getWorld().method_8398();
        Intrinsics.checkNotNull(class_28022, "null cannot be cast to non-null type com.cobblemon.mod.common.api.spawning.mixins.CachedOnlyChunkAccessor");
        CachedOnlyChunkAccessor cachedOnlyChunkAccessor = (CachedOnlyChunkAccessor)class_28022;
        class_2806 class_28062 = class_2806.field_12803;
        Intrinsics.checkNotNullExpressionValue(class_28062, "FULL");
        class_2791 class_27912 = cachedOnlyChunkAccessor.cobblemon$request(chunkX, chunkZ, class_28062);
        if (class_27912 == null) {
            return null;
        }
        class_2791 chunk = class_27912;
        boolean valid = this.isValidStartPoint(area.getWorld(), chunk, basePos);
        if (!valid) {
            int offset = 1;
            do {
                class_1937 class_19372 = area.getWorld();
                class_2338.class_2339 class_23392 = basePos.method_33098(originalY + offset);
                Intrinsics.checkNotNullExpressionValue(class_23392, "basePos.setY(originalY + offset)");
                if (this.isValidStartPoint(class_19372, chunk, class_23392)) {
                    valid = true;
                    basePos.method_33098(originalY + offset);
                    break;
                }
                class_1937 class_19373 = area.getWorld();
                class_2338.class_2339 class_23393 = basePos.method_33098(originalY - offset);
                Intrinsics.checkNotNullExpressionValue(class_23393, "basePos.setY(originalY - offset)");
                if (!this.isValidStartPoint(class_19373, chunk, class_23393)) continue;
                valid = true;
                basePos.method_33098(originalY + offset);
                break;
            } while (++offset <= Cobblemon.INSTANCE.getConfig().getMaxVerticalCorrectionBlocks());
        }
        if (valid) {
            class_2338 min = WorldExtensionsKt.squeezeWithinBounds(area.getWorld(), (class_2338)basePos);
            class_1937 class_19374 = area.getWorld();
            class_2338 class_23382 = basePos.method_10069(area.getLength(), area.getHeight(), area.getWidth());
            Intrinsics.checkNotNullExpressionValue(class_23382, "basePos.add(area.length, area.height, area.width)");
            class_2338 max = WorldExtensionsKt.squeezeWithinBounds(class_19374, class_23382);
            if (area.getWorld().method_8477(min) && area.getWorld().method_8477(max) && min.method_10264() != max.method_10264()) {
                return new SpawningArea(area.getCause(), area.getWorld(), min.method_10263(), min.method_10264(), min.method_10260(), area.getLength(), max.method_10264() - min.method_10264(), area.getWidth());
            }
        }
        return null;
    }

    private static final boolean run$lambda-0(PokemonEntity it) {
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/AreaSpawner$Companion;", "", "", "CHUNK_REACH", "I", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

