/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.detail;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.PossibleHeldItem;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b,\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010(\u001a\u00020'8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lcom/cobblemon/mod/common/api/spawning/detail/PokemonSpawnDetail;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "", "autoLabel", "()V", "Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;", "ctx", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "doSpawn", "(Lcom/cobblemon/mod/common/api/spawning/context/SpawningContext;)Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "Lkotlin/ranges/IntRange;", "getDerivedLevelRange", "()Lkotlin/ranges/IntRange;", "Lnet/minecraft/class_5250;", "getName", "()Lnet/minecraft/class_5250;", "Lcom/cobblemon/mod/common/api/drop/DropTable;", "drops", "Lcom/cobblemon/mod/common/api/drop/DropTable;", "getDrops", "()Lcom/cobblemon/mod/common/api/drop/DropTable;", "", "Lcom/cobblemon/mod/common/api/spawning/detail/PossibleHeldItem;", "heldItems", "Ljava/util/List;", "getHeldItems", "()Ljava/util/List;", "levelRange", "Lkotlin/ranges/IntRange;", "getLevelRange", "setLevelRange", "(Lkotlin/ranges/IntRange;)V", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "pokemon", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "getPokemon", "()Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "setPokemon", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;)V", "", "type", "Ljava/lang/String;", "getType", "()Ljava/lang/String;", "<init>", "Companion", "common"})
public final class PokemonSpawnDetail
extends SpawnDetail {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type = TYPE;
    @NotNull
    private PokemonProperties pokemon = new PokemonProperties();
    @SerializedName(value="level", alternate={"levelRange"})
    @Nullable
    private IntRange levelRange;
    @Nullable
    private final DropTable drops;
    @Nullable
    private final List<PossibleHeldItem> heldItems;
    @NotNull
    private static final String TYPE = "pokemon";

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public final PokemonProperties getPokemon() {
        return this.pokemon;
    }

    public final void setPokemon(@NotNull PokemonProperties pokemonProperties) {
        Intrinsics.checkNotNullParameter(pokemonProperties, "<set-?>");
        this.pokemon = pokemonProperties;
    }

    @Nullable
    public final IntRange getLevelRange() {
        return this.levelRange;
    }

    public final void setLevelRange(@Nullable IntRange intRange) {
        this.levelRange = intRange;
    }

    @Nullable
    public final DropTable getDrops() {
        return this.drops;
    }

    @Nullable
    public final List<PossibleHeldItem> getHeldItems() {
        return this.heldItems;
    }

    @Override
    @NotNull
    public class_5250 getName() {
        String speciesString = this.pokemon.getSpecies();
        if (speciesString != null) {
            class_5250 class_52502;
            String string = speciesString.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (Intrinsics.areEqual(string, "random")) {
                class_5250 class_52503 = LocalizationUtilsKt.lang("species.random", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(class_52503, "lang(\"species.random\")");
                return class_52503;
            }
            Species species = PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(speciesString, null, 1, null));
            if (species == null) {
                class_5250 class_52504 = LocalizationUtilsKt.lang("species.unknown", new Object[0]);
                class_52502 = class_52504;
                Intrinsics.checkNotNullExpressionValue(class_52504, "{\n                lang(\"\u2026s.unknown\")\n            }");
            } else {
                class_52502 = species.getTranslatedName();
            }
            return class_52502;
        }
        class_5250 class_52505 = LocalizationUtilsKt.lang("a_pokemon", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(class_52505, "lang(\"a_pokemon\")");
        return class_52505;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void autoLabel() {
        block2: {
            Object object;
            List<String> list;
            block4: {
                Species species;
                block3: {
                    void it;
                    super.autoLabel();
                    if (this.pokemon.getSpecies() == null) break block2;
                    String string = this.pokemon.getSpecies();
                    Intrinsics.checkNotNull(string);
                    species = PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(string, null, 1, null));
                    if (species == null) break block2;
                    list = this.getLabels();
                    object = species.getSecondaryType();
                    if (object == null) break block3;
                    ElementalType elementalType = object;
                    List<String> list2 = list;
                    boolean bl = false;
                    String[] stringArray = new String[2];
                    Intrinsics.checkNotNullExpressionValue(species.getPrimaryType().getName().toLowerCase(Locale.ROOT), "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Intrinsics.checkNotNullExpressionValue(it.getName().toLowerCase(Locale.ROOT), "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    List<String> list3 = CollectionsKt.listOf(stringArray);
                    list = list2;
                    object = list3;
                    if (list3 != null) break block4;
                }
                String string = species.getPrimaryType().getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                object = CollectionsKt.listOf(string);
            }
            list.addAll((Collection)object);
        }
    }

    @NotNull
    public final IntRange getDerivedLevelRange() {
        IntRange intRange;
        IntRange levelRange = this.levelRange;
        boolean bl = false;
        if (levelRange == null && this.pokemon.getLevel() == null) {
            intRange = new IntRange(1, Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel());
        } else if (levelRange == null) {
            Integer n = this.pokemon.getLevel();
            Intrinsics.checkNotNull(n);
            int n2 = n;
            Integer n3 = this.pokemon.getLevel();
            Intrinsics.checkNotNull(n3);
            intRange = new IntRange(n2, n3);
        } else {
            intRange = levelRange;
        }
        return intRange;
    }

    @Override
    @NotNull
    public SpawnAction<?> doSpawn(@NotNull SpawningContext ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        return new PokemonSpawnAction(ctx, this, null, 4, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/spawning/detail/PokemonSpawnDetail$Companion;", "", "", "TYPE", "Ljava/lang/String;", "getTYPE", "()Ljava/lang/String;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTYPE() {
            return TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

