/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.context.calculators;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.WorldSlice;
import com.cobblemon.mod.common.api.spawning.context.SubmergedSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.calculators.AreaSpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.context.calculators.AreaSpawningInput;
import com.cobblemon.mod.common.api.spawning.context.calculators.SpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rR)\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\n0\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/api/spawning/context/calculators/SubmergedSpawningContextCalculator;", "Lcom/cobblemon/mod/common/api/spawning/context/calculators/AreaSpawningContextCalculator;", "Lcom/cobblemon/mod/common/api/spawning/context/SubmergedSpawningContext;", "Lcom/cobblemon/mod/common/api/spawning/context/calculators/AreaSpawningInput;", "input", "calculate", "(Lcom/cobblemon/mod/common/api/spawning/context/calculators/AreaSpawningInput;)Lcom/cobblemon/mod/common/api/spawning/context/SubmergedSpawningContext;", "", "fits", "(Lcom/cobblemon/mod/common/api/spawning/context/calculators/AreaSpawningInput;)Z", "Lkotlin/Function1;", "Lnet/minecraft/class_2680;", "getFluidCondition", "(Lcom/cobblemon/mod/common/api/spawning/context/calculators/AreaSpawningInput;)Lkotlin/jvm/functions/Function1;", "", "fluidConditions", "Ljava/util/List;", "getFluidConditions", "()Ljava/util/List;", "<init>", "()V", "common"})
public final class SubmergedSpawningContextCalculator
implements AreaSpawningContextCalculator<SubmergedSpawningContext> {
    @NotNull
    public static final SubmergedSpawningContextCalculator INSTANCE = new SubmergedSpawningContextCalculator();
    @NotNull
    private static final List<Function1<class_2680, Boolean>> fluidConditions;

    private SubmergedSpawningContextCalculator() {
    }

    @NotNull
    public final List<Function1<class_2680, Boolean>> getFluidConditions() {
        return fluidConditions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean fits(@NotNull AreaSpawningInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        Function1<class_2680, Boolean> condition2 = this.getFluidCondition(input);
        if (condition2 == null) return false;
        WorldSlice worldSlice = input.getSlice();
        class_2338 class_23382 = input.getPosition().method_10074();
        Intrinsics.checkNotNullExpressionValue(class_23382, "input.position.down()");
        if (condition2.invoke(WorldSlice.getBlockState$default(worldSlice, class_23382, null, 2, null)) == false) return false;
        WorldSlice worldSlice2 = input.getSlice();
        class_2338 class_23383 = input.getPosition().method_10084();
        Intrinsics.checkNotNullExpressionValue(class_23383, "input.position.up()");
        if (condition2.invoke(WorldSlice.getBlockState$default(worldSlice2, class_23383, null, 2, null)) == false) return false;
        return true;
    }

    @Nullable
    public final Function1<class_2680, Boolean> getFluidCondition(@NotNull AreaSpawningInput input) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(input, "input");
            Iterable $this$firstOrNull$iv = fluidConditions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                if (!((Boolean)it.invoke(WorldSlice.getBlockState$default(input.getSlice(), input.getPosition(), null, 2, null))).booleanValue()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public SubmergedSpawningContext calculate(@NotNull AreaSpawningInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        Function1<class_2680, Boolean> function1 = this.getFluidCondition(input);
        Intrinsics.checkNotNull(function1);
        Function1<class_2680, Boolean> fluidCondition = function1;
        SpawnCause spawnCause = input.getCause();
        class_1937 class_19372 = input.getWorld();
        class_2338 class_23382 = input.getPosition().method_10062();
        int n = AreaSpawningContextCalculator.DefaultImpls.getLight$default(this, input, 0, 2, null);
        boolean bl = this.getCanSeeSky(input);
        List<SpawningInfluence> list = input.getSpawner().copyInfluences();
        int n2 = AreaSpawningContextCalculator.DefaultImpls.getHorizontalSpace$default(this, input, fluidCondition, Cobblemon.INSTANCE.getConfig().getMaxHorizontalSpace(), 0, 0, 0, 56, null);
        int n3 = AreaSpawningContextCalculator.DefaultImpls.getHeight$default(this, input, fluidCondition, class_3532.method_15386((float)((float)Cobblemon.INSTANCE.getConfig().getMaxVerticalSpace() / 2.0f)), 0, 0, 0, 56, null);
        int n4 = this.getDepth(input, fluidCondition, class_3532.method_15386((float)((float)Cobblemon.INSTANCE.getConfig().getMaxVerticalSpace() / 2.0f)));
        WorldSlice worldSlice = input.getSlice();
        List list2 = AreaSpawningContextCalculator.DefaultImpls.getNearbyBlocks$default(this, input, 0, 0, 6, null);
        Intrinsics.checkNotNullExpressionValue(class_23382, "toImmutable()");
        return new SubmergedSpawningContext(spawnCause, class_19372, class_23382, n, bl, list, n2, n3, n4, list2, worldSlice);
    }

    @Override
    public int getDepth(@NotNull AreaSpawningInput input, @NotNull Function1<? super class_2680, Boolean> condition2, int maximum) {
        return AreaSpawningContextCalculator.DefaultImpls.getDepth(this, input, condition2, maximum);
    }

    @Override
    public int getHeight(@NotNull AreaSpawningInput input, @NotNull Function1<? super class_2680, Boolean> condition2, int maximum, int offsetX, int offsetY, int offsetZ) {
        return AreaSpawningContextCalculator.DefaultImpls.getHeight(this, input, condition2, maximum, offsetX, offsetY, offsetZ);
    }

    @Override
    public int getHorizontalSpace(@NotNull AreaSpawningInput input, @NotNull Function1<? super class_2680, Boolean> condition2, int maximum, int offsetX, int offsetY, int offsetZ) {
        return AreaSpawningContextCalculator.DefaultImpls.getHorizontalSpace(this, input, condition2, maximum, offsetX, offsetY, offsetZ);
    }

    @Override
    public int getLight(@NotNull AreaSpawningInput input, int elseLight) {
        return AreaSpawningContextCalculator.DefaultImpls.getLight(this, input, elseLight);
    }

    @Override
    public boolean getCanSeeSky(@NotNull AreaSpawningInput input) {
        return AreaSpawningContextCalculator.DefaultImpls.getCanSeeSky(this, input);
    }

    @Override
    public int getSkySpaceAbove(@NotNull AreaSpawningInput input) {
        return AreaSpawningContextCalculator.DefaultImpls.getSkySpaceAbove(this, input);
    }

    @Override
    @NotNull
    public List<class_2680> getNearbyBlocks(@NotNull AreaSpawningInput input, int horizontalRadius, int verticalRadius) {
        return AreaSpawningContextCalculator.DefaultImpls.getNearbyBlocks(this, input, horizontalRadius, verticalRadius);
    }

    static {
        Function1[] function1Array = new Function1[]{SpawningContextCalculator.Companion.isWaterCondition(), SpawningContextCalculator.Companion.isLavaCondition()};
        fluidConditions = CollectionsKt.mutableListOf(function1Array);
    }
}

