/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnerManager;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawnerFactory;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001d\u0010\tJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R.\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/api/spawning/CobblemonWorldSpawnerManager;", "Lcom/cobblemon/mod/common/api/spawning/SpawnerManager;", "Lnet/minecraft/class_3222;", "player", "", "onPlayerLogin", "(Lnet/minecraft/class_3222;)V", "onPlayerLogout", "onServerStarted", "()V", "Ldev/architectury/event/events/common/PlayerEvent$PlayerJoin;", "playerJoinListener", "Ldev/architectury/event/events/common/PlayerEvent$PlayerJoin;", "getPlayerJoinListener", "()Ldev/architectury/event/events/common/PlayerEvent$PlayerJoin;", "Ldev/architectury/event/events/common/PlayerEvent$PlayerQuit;", "playerLeaveListener", "Ldev/architectury/event/events/common/PlayerEvent$PlayerQuit;", "getPlayerLeaveListener", "()Ldev/architectury/event/events/common/PlayerEvent$PlayerQuit;", "", "Ljava/util/UUID;", "Lcom/cobblemon/mod/common/api/spawning/spawner/PlayerSpawner;", "spawnersForPlayers", "Ljava/util/Map;", "getSpawnersForPlayers", "()Ljava/util/Map;", "setSpawnersForPlayers", "(Ljava/util/Map;)V", "<init>", "common"})
public final class CobblemonWorldSpawnerManager
extends SpawnerManager {
    @NotNull
    public static final CobblemonWorldSpawnerManager INSTANCE = new CobblemonWorldSpawnerManager();
    @NotNull
    private static Map<UUID, PlayerSpawner> spawnersForPlayers = new LinkedHashMap();
    @NotNull
    private static final PlayerEvent.PlayerJoin playerJoinListener = INSTANCE::onPlayerLogin;
    @NotNull
    private static final PlayerEvent.PlayerQuit playerLeaveListener = INSTANCE::onPlayerLogout;

    private CobblemonWorldSpawnerManager() {
    }

    @NotNull
    public final Map<UUID, PlayerSpawner> getSpawnersForPlayers() {
        return spawnersForPlayers;
    }

    public final void setSpawnersForPlayers(@NotNull Map<UUID, PlayerSpawner> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        spawnersForPlayers = map;
    }

    @NotNull
    public final PlayerEvent.PlayerJoin getPlayerJoinListener() {
        return playerJoinListener;
    }

    @NotNull
    public final PlayerEvent.PlayerQuit getPlayerLeaveListener() {
        return playerLeaveListener;
    }

    @Override
    public void onServerStarted() {
        super.onServerStarted();
        if (!PlayerEvent.PLAYER_JOIN.isRegistered((Object)playerJoinListener)) {
            PlayerEvent.PLAYER_JOIN.register((Object)playerJoinListener);
        }
        if (!PlayerEvent.PLAYER_QUIT.isRegistered((Object)playerLeaveListener)) {
            PlayerEvent.PLAYER_QUIT.register((Object)playerLeaveListener);
        }
    }

    public final void onPlayerLogin(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!Cobblemon.INSTANCE.getConfig().getEnableSpawning()) {
            return;
        }
        PlayerSpawner spawner = PlayerSpawnerFactory.INSTANCE.create(this, player);
        Map<UUID, PlayerSpawner> map = spawnersForPlayers;
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "player.uuid");
        map.put(uUID, spawner);
        this.registerSpawner(spawner);
    }

    public final void onPlayerLogout(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        PlayerSpawner spawner = spawnersForPlayers.get(player.method_5667());
        if (spawner != null) {
            spawnersForPlayers.remove(player.method_5667());
            this.unregisterSpawner(spawner);
        }
    }
}

