/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.scheduling;

import com.cobblemon.mod.common.api.scheduling.ScheduledTaskTracker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u00014BC\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\t\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u00101\u001a\u00020\u001c\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u001c\u0012\b\b\u0002\u0010!\u001a\u00020\u000e\u00a2\u0006\u0004\b2\u00103J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0004R#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00148\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u0007R\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u0011\u001a\u0004\b\"\u0010\u0013R\"\u0010$\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R*\u0010+\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00148\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010\u0016\u001a\u0004\b,\u0010\u0018\"\u0004\b-\u0010.R$\u0010/\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u001c8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b/\u0010\u001e\u001a\u0004\b0\u0010 \u00a8\u00065"}, d2={"Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask;", "", "", "expire", "()V", "", "toString", "()Ljava/lang/String;", "update", "Lkotlin/Function1;", "action", "Lkotlin/jvm/functions/Function1;", "getAction", "()Lkotlin/jvm/functions/Function1;", "", "<set-?>", "currentIteration", "I", "getCurrentIteration", "()I", "", "expired", "Z", "getExpired", "()Z", "identifier", "Ljava/lang/String;", "getIdentifier", "", "intervalSeconds", "F", "getIntervalSeconds", "()F", "iterations", "getIterations", "", "lastExecutedTime", "J", "getLastExecutedTime", "()J", "setLastExecutedTime", "(J)V", "value", "paused", "getPaused", "setPaused", "(Z)V", "secondsRemaining", "getSecondsRemaining", "delaySeconds", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;FFI)V", "Builder", "common"})
public final class ScheduledTask {
    @NotNull
    private final Function1<ScheduledTask, Unit> action;
    @Nullable
    private final String identifier;
    private final float intervalSeconds;
    private final int iterations;
    private int currentIteration;
    private float secondsRemaining;
    private boolean expired;
    private boolean paused;
    private long lastExecutedTime;

    public ScheduledTask(@NotNull Function1<? super ScheduledTask, Unit> action, @Nullable String identifier, float delaySeconds, float intervalSeconds, int iterations) {
        Intrinsics.checkNotNullParameter(action, "action");
        this.action = action;
        this.identifier = identifier;
        this.intervalSeconds = intervalSeconds;
        this.iterations = iterations;
        this.lastExecutedTime = System.currentTimeMillis();
        if (delaySeconds > 0.0f) {
            this.secondsRemaining = delaySeconds;
        }
    }

    public /* synthetic */ ScheduledTask(Function1 function1, String string, float f, float f2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            f2 = -1.0f;
        }
        if ((n2 & 0x10) != 0) {
            n = 1;
        }
        this(function1, string, f, f2, n);
    }

    @NotNull
    public final Function1<ScheduledTask, Unit> getAction() {
        return this.action;
    }

    @Nullable
    public final String getIdentifier() {
        return this.identifier;
    }

    public final float getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public final int getIterations() {
        return this.iterations;
    }

    public final int getCurrentIteration() {
        return this.currentIteration;
    }

    public final float getSecondsRemaining() {
        return this.secondsRemaining;
    }

    public final boolean getExpired() {
        return this.expired;
    }

    public final boolean getPaused() {
        return this.paused;
    }

    public final void setPaused(boolean value) {
        this.paused = value;
        if (!value) {
            this.lastExecutedTime = System.currentTimeMillis();
        }
    }

    public final long getLastExecutedTime() {
        return this.lastExecutedTime;
    }

    public final void setLastExecutedTime(long l) {
        this.lastExecutedTime = l;
    }

    @NotNull
    public String toString() {
        Object object;
        block3: {
            block2: {
                object = this.identifier;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "Task-" + it;
                object = string;
                if (string != null) break block3;
            }
            object = super.toString();
        }
        return object;
    }

    public final void update() {
        long now = System.currentTimeMillis();
        long passed = now - this.lastExecutedTime;
        this.lastExecutedTime = now;
        if (!this.expired && !this.paused) {
            this.secondsRemaining = Math.max(0.0f, this.secondsRemaining - (float)passed / 1000.0f);
            if (this.secondsRemaining == 0.0f) {
                this.action.invoke(this);
                int n = this.currentIteration;
                this.currentIteration = n + 1;
                if (!(this.intervalSeconds == -1.0f || this.currentIteration >= this.iterations && this.iterations != -1)) {
                    this.secondsRemaining = this.intervalSeconds;
                } else {
                    this.expired = true;
                }
            }
        }
    }

    public final void expire() {
        this.expired = true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\f\u001a\u00020\u00002\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016R$\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0017R\u0016\u0010\u0006\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0018R\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0019R\u0016\u0010\u0013\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0018R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask$Builder;", "", "Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask;", "build", "()Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask;", "", "delaySeconds", "delay", "(F)Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask$Builder;", "Lkotlin/Function1;", "", "action", "execute", "(Lkotlin/jvm/functions/Function1;)Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask$Builder;", "", "identifier", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask$Builder;", "infiniteIterations", "()Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask$Builder;", "interval", "", "iterations", "(I)Lcom/cobblemon/mod/common/api/scheduling/ScheduledTask$Builder;", "Lkotlin/jvm/functions/Function1;", "F", "Ljava/lang/String;", "I", "<init>", "()V", "common"})
    public static final class Builder {
        @Nullable
        private Function1<? super ScheduledTask, Unit> action;
        private float delaySeconds;
        private float interval = -1.0f;
        private int iterations = 1;
        @Nullable
        private String identifier;

        @NotNull
        public final Builder identifier(@NotNull String identifier) {
            Intrinsics.checkNotNullParameter(identifier, "identifier");
            this.identifier = identifier;
            return this;
        }

        @NotNull
        public final Builder execute(@NotNull Function1<? super ScheduledTask, Unit> action) {
            Intrinsics.checkNotNullParameter(action, "action");
            this.action = action;
            return this;
        }

        @NotNull
        public final Builder delay(float delaySeconds) {
            if (!(delaySeconds >= 0.0f)) {
                boolean bl = false;
                String string = "Delay must not be below 0";
                throw new IllegalArgumentException(string.toString());
            }
            this.delaySeconds = delaySeconds;
            return this;
        }

        @NotNull
        public final Builder interval(float interval) {
            if (!(interval >= 0.0f)) {
                boolean bl = false;
                String string = "Interval must not be below 0";
                throw new IllegalArgumentException(string.toString());
            }
            this.interval = interval;
            return this;
        }

        @NotNull
        public final Builder iterations(int iterations) {
            if (!(iterations >= -1)) {
                boolean bl = false;
                String string = "Iterations must not be below -1";
                throw new IllegalArgumentException(string.toString());
            }
            this.iterations = iterations;
            return this;
        }

        @NotNull
        public final Builder infiniteIterations() {
            return this.iterations(-1);
        }

        @NotNull
        public final ScheduledTask build() {
            if (this.action == null) {
                boolean bl = false;
                String string = "action must be set";
                throw new IllegalStateException(string.toString());
            }
            Function1<? super ScheduledTask, Unit> function1 = this.action;
            Intrinsics.checkNotNull(function1);
            ScheduledTask task = new ScheduledTask(function1, this.identifier, this.delaySeconds, this.interval, this.iterations);
            ScheduledTaskTracker.INSTANCE.addTask(task);
            return task;
        }
    }
}

