/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pokemon.feature;

import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatureProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatures;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010 \u001a\u00020\b\u0012\u0006\u0010\u001a\u001a\u00020\u0013\u00a2\u0006\u0004\b#\u0010$B\u000f\u0012\u0006\u0010 \u001a\u00020\b\u00a2\u0006\u0004\b#\u0010%J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010\n\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/api/pokemon/feature/FlagSpeciesFeature;", "Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "Lcom/cobblemon/mod/common/api/properties/CustomPokemonProperty;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "apply", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "asString", "()Ljava/lang/String;", "Lcom/google/gson/JsonObject;", "pokemonJSON", "loadFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "Lnet/minecraft/class_2487;", "pokemonNBT", "loadFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "", "matches", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "saveToJSON", "(Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "saveToNBT", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "enabled", "Z", "getEnabled", "()Z", "setEnabled", "(Z)V", "name", "Ljava/lang/String;", "getName", "<init>", "(Ljava/lang/String;Z)V", "(Ljava/lang/String;)V", "common"})
public class FlagSpeciesFeature
implements SpeciesFeature,
CustomPokemonProperty {
    @NotNull
    private final String name;
    private boolean enabled;

    public FlagSpeciesFeature(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public FlagSpeciesFeature(@NotNull String name, boolean enabled) {
        Intrinsics.checkNotNullParameter(name, "name");
        this(name);
        this.enabled = enabled;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    @NotNull
    public class_2487 saveToNBT(@NotNull class_2487 pokemonNBT) {
        Intrinsics.checkNotNullParameter(pokemonNBT, "pokemonNBT");
        pokemonNBT.method_10556(this.getName(), this.enabled);
        return pokemonNBT;
    }

    @Override
    @NotNull
    public SpeciesFeature loadFromNBT(@NotNull class_2487 pokemonNBT) {
        Intrinsics.checkNotNullParameter(pokemonNBT, "pokemonNBT");
        this.enabled = pokemonNBT.method_10545(this.getName()) ? pokemonNBT.method_10577(this.getName()) : this.enabled;
        return this;
    }

    @Override
    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject pokemonJSON) {
        Intrinsics.checkNotNullParameter(pokemonJSON, "pokemonJSON");
        pokemonJSON.addProperty(this.getName(), Boolean.valueOf(this.enabled));
        return pokemonJSON;
    }

    @Override
    @NotNull
    public SpeciesFeature loadFromJSON(@NotNull JsonObject pokemonJSON) {
        Boolean isEnabled;
        Intrinsics.checkNotNullParameter(pokemonJSON, "pokemonJSON");
        JsonElement jsonElement = pokemonJSON.get(this.getName());
        Boolean bl = isEnabled = jsonElement != null ? Boolean.valueOf(jsonElement.getAsBoolean()) : null;
        this.enabled = bl != null ? bl : this.enabled;
        return this;
    }

    @Override
    @NotNull
    public String asString() {
        return this.getName() + "=" + this.enabled;
    }

    @Override
    public void apply(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        SpeciesFeatureProvider<? extends SpeciesFeature> speciesFeatureProvider = SpeciesFeatures.INSTANCE.getFeature(this.getName());
        if (speciesFeatureProvider == null) {
            return;
        }
        SpeciesFeatureProvider<? extends SpeciesFeature> featureProvider = speciesFeatureProvider;
        if (SpeciesFeatures.INSTANCE.getFeaturesFor(pokemon.getSpecies()).contains(featureProvider)) {
            FlagSpeciesFeature existingFeature = (FlagSpeciesFeature)pokemon.getFeature(this.getName());
            if (existingFeature != null) {
                existingFeature.enabled = this.enabled;
            } else {
                pokemon.getFeatures().add(new FlagSpeciesFeature(this.getName(), this.enabled));
            }
            pokemon.updateAspects();
        }
    }

    @Override
    public boolean matches(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        FlagSpeciesFeature flagSpeciesFeature = (FlagSpeciesFeature)pokemon.getFeature(this.getName());
        return flagSpeciesFeature != null ? flagSpeciesFeature.enabled == this.enabled : false;
    }

    @Override
    public void apply(@NotNull PokemonEntity pokemonEntity) {
        CustomPokemonProperty.DefaultImpls.apply(this, pokemonEntity);
    }

    @Override
    public boolean matches(@NotNull PokemonEntity pokemonEntity) {
        return CustomPokemonProperty.DefaultImpls.matches(this, pokemonEntity);
    }
}

