/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pokemon;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.aspect.AspectProvider;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.api.properties.CustomPokemonPropertyType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.cobblemon.mod.common.util.StringExtensionsKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.class_151;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001e\b\u0016\u0018\u0000 g2\u00020\u0001:\u0001gB\u0007\u00a2\u0006\u0004\bf\u0010*J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010\"\u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010\"\u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\"\u0010$J\r\u0010%\u001a\u00020\u0019\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\u001d\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020\u0004\u00a2\u0006\u0004\b)\u0010*R$\u0010+\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R(\u00102\u001a\b\u0012\u0004\u0012\u00020\r018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R(\u0010:\u001a\b\u0012\u0004\u0012\u000209088\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R$\u0010@\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010,\u001a\u0004\bA\u0010.\"\u0004\bB\u00100R$\u0010D\u001a\u0004\u0018\u00010C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR$\u0010K\u001a\u0004\u0018\u00010J8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR$\u0010Q\u001a\u0004\u0018\u00010C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010E\u001a\u0004\bR\u0010G\"\u0004\bS\u0010IR$\u0010T\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bT\u0010,\u001a\u0004\bU\u0010.\"\u0004\bV\u00100R\"\u0010W\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010,\u001a\u0004\bX\u0010.\"\u0004\bY\u00100R$\u0010Z\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bZ\u0010,\u001a\u0004\b[\u0010.\"\u0004\b\\\u00100R$\u0010]\u001a\u0004\u0018\u00010!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b]\u0010^\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR$\u0010c\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bc\u0010,\u001a\u0004\bd\u0010.\"\u0004\be\u00100\u00a8\u0006h"}, d2={"Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "", "apply", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lcom/cobblemon/mod/common/pokemon/RenderablePokemon;", "asRenderablePokemon", "()Lcom/cobblemon/mod/common/pokemon/RenderablePokemon;", "", "separator", "asString", "(Ljava/lang/String;)Ljava/lang/String;", "copy", "()Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "create", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lnet/minecraft/class_1937;", "world", "createEntity", "(Lnet/minecraft/class_1937;)Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lcom/google/gson/JsonObject;", "json", "loadFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "Lnet/minecraft/class_2487;", "tag", "loadFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "", "matches", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "saveToJSON", "()Lcom/google/gson/JsonObject;", "saveToNBT", "()Lnet/minecraft/class_2487;", "updateAspects", "()V", "ability", "Ljava/lang/String;", "getAbility", "()Ljava/lang/String;", "setAbility", "(Ljava/lang/String;)V", "", "aspects", "Ljava/util/Set;", "getAspects", "()Ljava/util/Set;", "setAspects", "(Ljava/util/Set;)V", "", "Lcom/cobblemon/mod/common/api/properties/CustomPokemonProperty;", "customProperties", "Ljava/util/List;", "getCustomProperties", "()Ljava/util/List;", "setCustomProperties", "(Ljava/util/List;)V", "form", "getForm", "setForm", "", "friendship", "Ljava/lang/Integer;", "getFriendship", "()Ljava/lang/Integer;", "setFriendship", "(Ljava/lang/Integer;)V", "Lcom/cobblemon/mod/common/pokemon/Gender;", "gender", "Lcom/cobblemon/mod/common/pokemon/Gender;", "getGender", "()Lcom/cobblemon/mod/common/pokemon/Gender;", "setGender", "(Lcom/cobblemon/mod/common/pokemon/Gender;)V", "level", "getLevel", "setLevel", "nature", "getNature", "setNature", "originalString", "getOriginalString", "setOriginalString", "pokeball", "getPokeball", "setPokeball", "shiny", "Ljava/lang/Boolean;", "getShiny", "()Ljava/lang/Boolean;", "setShiny", "(Ljava/lang/Boolean;)V", "species", "getSpecies", "setSpecies", "<init>", "Companion", "common"})
public class PokemonProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String originalString = "";
    @Nullable
    private String species;
    @Nullable
    private String form;
    @Nullable
    private Boolean shiny;
    @Nullable
    private Gender gender;
    @Nullable
    private Integer level;
    @Nullable
    private Integer friendship;
    @Nullable
    private String pokeball;
    @Nullable
    private String nature;
    @Nullable
    private String ability;
    @NotNull
    private Set<String> aspects = SetsKt.emptySet();
    @NotNull
    private List<CustomPokemonProperty> customProperties = new ArrayList();

    @NotNull
    public final String getOriginalString() {
        return this.originalString;
    }

    public final void setOriginalString(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.originalString = string;
    }

    @Nullable
    public final String getSpecies() {
        return this.species;
    }

    public final void setSpecies(@Nullable String string) {
        this.species = string;
    }

    @Nullable
    public final String getForm() {
        return this.form;
    }

    public final void setForm(@Nullable String string) {
        this.form = string;
    }

    @Nullable
    public final Boolean getShiny() {
        return this.shiny;
    }

    public final void setShiny(@Nullable Boolean bl) {
        this.shiny = bl;
    }

    @Nullable
    public final Gender getGender() {
        return this.gender;
    }

    public final void setGender(@Nullable Gender gender) {
        this.gender = gender;
    }

    @Nullable
    public final Integer getLevel() {
        return this.level;
    }

    public final void setLevel(@Nullable Integer n) {
        this.level = n;
    }

    @Nullable
    public final Integer getFriendship() {
        return this.friendship;
    }

    public final void setFriendship(@Nullable Integer n) {
        this.friendship = n;
    }

    @Nullable
    public final String getPokeball() {
        return this.pokeball;
    }

    public final void setPokeball(@Nullable String string) {
        this.pokeball = string;
    }

    @Nullable
    public final String getNature() {
        return this.nature;
    }

    public final void setNature(@Nullable String string) {
        this.nature = string;
    }

    @Nullable
    public final String getAbility() {
        return this.ability;
    }

    public final void setAbility(@Nullable String string) {
        this.ability = string;
    }

    @NotNull
    public final Set<String> getAspects() {
        return this.aspects;
    }

    public final void setAspects(@NotNull Set<String> set2) {
        Intrinsics.checkNotNullParameter(set2, "<set-?>");
        this.aspects = set2;
    }

    @NotNull
    public final List<CustomPokemonProperty> getCustomProperties() {
        return this.customProperties;
    }

    public final void setCustomProperties(@NotNull List<CustomPokemonProperty> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.customProperties = list;
    }

    @NotNull
    public final RenderablePokemon asRenderablePokemon() {
        Object object;
        block5: {
            block4: {
                Species species;
                object = this.species;
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                try {
                    species = PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(it, null, 1, null));
                }
                catch (class_151 e) {
                    species = PokemonSpecies.INSTANCE.random();
                }
                Species species2 = species;
                object = species2;
                if (species2 != null) break block5;
            }
            object = PokemonSpecies.INSTANCE.random();
        }
        Set<String> set2 = this.aspects;
        Object object2 = object;
        return new RenderablePokemon((Species)object2, set2);
    }

    public final void apply(@NotNull Pokemon pokemon) {
        Object object;
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        String string = this.species;
        if (string != null) {
            Species species;
            Object it = string;
            boolean bl = false;
            try {
                species = Intrinsics.areEqual(it, "random") ? (Species)CollectionsKt.random((Collection)PokemonSpecies.INSTANCE.getImplemented(), Random.Default) : PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default((String)it, null, 1, null));
            }
            catch (class_151 e) {
                species = null;
            }
            Species species2 = species;
            if (species2 != null) {
                it = species2;
                boolean bl2 = false;
                pokemon.setSpecies((Species)it);
            }
        }
        if ((object = this.form) != null) {
            Object v1;
            block17: {
                String formID = object;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = pokemon.getSpecies().getForms();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FormData it = (FormData)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.equals(it.formOnlyShowdownId(), formID, true)) continue;
                    v1 = element$iv;
                    break block17;
                }
                v1 = null;
            }
            FormData formData = v1;
            object = formData;
            if (formData != null) {
                Object form2 = object;
                boolean bl = false;
                pokemon.setForm((FormData)form2);
            }
        }
        Boolean bl = this.shiny;
        if (bl != null) {
            boolean it = bl;
            boolean bl4 = false;
            pokemon.setShiny(it);
        }
        Gender gender = this.gender;
        if (gender != null) {
            Gender it = gender;
            boolean bl5 = false;
            pokemon.setGender(it);
        }
        Integer n = this.level;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl6 = false;
            pokemon.setLevel(it);
        }
        Integer n2 = this.friendship;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl7 = false;
            Pokemon.setFriendship$default(pokemon, it, false, 2, null);
        }
        String string2 = this.pokeball;
        if (string2 != null) {
            String it = string2;
            boolean bl8 = false;
            PokeBall pokeBall = PokeBalls.INSTANCE.getPokeBall(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(it, null, 1, null));
            if (pokeBall != null) {
                PokeBall pokeball = pokeBall;
                boolean bl9 = false;
                pokemon.setCaughtBall(pokeball);
            }
        }
        String string3 = this.nature;
        if (string3 != null) {
            String it = string3;
            boolean bl10 = false;
            Nature nature = Natures.INSTANCE.getNature(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(it, null, 1, null));
            if (nature != null) {
                Nature nature2 = nature;
                boolean bl11 = false;
                pokemon.setNature(nature2);
            }
        }
        String string4 = this.ability;
        if (string4 != null) {
            String it = string4;
            boolean bl12 = false;
            Ability ability = Abilities.INSTANCE.getOrException(it).create(true);
            boolean bl13 = false;
            pokemon.setAbility(ability);
        }
        Iterable $this$forEach$iv = this.customProperties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CustomPokemonProperty it = (CustomPokemonProperty)element$iv;
            boolean bl14 = false;
            it.apply(pokemon);
        }
    }

    public final void apply(@NotNull PokemonEntity pokemonEntity) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter(pokemonEntity, "pokemonEntity");
        String string = this.species;
        if (string != null) {
            Species species;
            String it2 = string;
            bl = false;
            try {
                species = Intrinsics.areEqual(it2, "random") ? CollectionsKt.random(PokemonSpecies.INSTANCE.getSpecies(), Random.Default) : PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(it2, null, 1, null));
            }
            catch (class_151 e) {
                species = null;
            }
            Species species2 = species;
            if (species2 != null) {
                Species it = species2;
                boolean bl2 = false;
                pokemonEntity.getPokemon().setSpecies(it);
            }
        }
        if ((object = this.form) != null) {
            Object v1;
            block17: {
                String formID = object;
                bl = false;
                Iterable $this$firstOrNull$iv = pokemonEntity.getPokemon().getSpecies().getForms();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FormData it3 = (FormData)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.equals(it3.formOnlyShowdownId(), formID, true)) continue;
                    v1 = element$iv;
                    break block17;
                }
                v1 = null;
            }
            FormData formData = v1;
            object = formData;
            if (formData != null) {
                Object form2 = object;
                bl = false;
                pokemonEntity.getPokemon().setForm((FormData)form2);
            }
        }
        Integer n = this.level;
        if (n != null) {
            int n2 = ((Number)n).intValue();
            boolean bl2 = false;
            pokemonEntity.getPokemon().setLevel(n2);
        }
        Boolean bl3 = this.shiny;
        if (bl3 != null) {
            boolean bl4 = bl3;
            boolean bl42 = false;
            pokemonEntity.getPokemon().setShiny(bl4);
        }
        Gender gender = this.gender;
        if (gender != null) {
            Gender gender2 = gender;
            boolean bl5 = false;
            pokemonEntity.getPokemon().setGender(gender2);
        }
        Integer n3 = this.friendship;
        if (n3 != null) {
            int n4 = ((Number)n3).intValue();
            boolean bl6 = false;
            Pokemon.setFriendship$default(pokemonEntity.getPokemon(), n4, false, 2, null);
        }
        String string2 = this.pokeball;
        if (string2 != null) {
            String string3 = string2;
            boolean bl7 = false;
            PokeBall pokeBall = PokeBalls.INSTANCE.getPokeBall(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(string3, null, 1, null));
            if (pokeBall != null) {
                PokeBall pokeball = pokeBall;
                boolean bl8 = false;
                pokemonEntity.getPokemon().setCaughtBall(pokeball);
            }
        }
        String string4 = this.nature;
        if (string4 != null) {
            String string5 = string4;
            boolean bl9 = false;
            Nature nature = Natures.INSTANCE.getNature(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(string5, null, 1, null));
            if (nature != null) {
                Nature nature2 = nature;
                boolean bl10 = false;
                pokemonEntity.getPokemon().setNature(nature2);
            }
        }
        String string6 = this.ability;
        if (string6 != null) {
            String string7 = string6;
            boolean bl11 = false;
            Ability ability = Abilities.INSTANCE.getOrException(string7).create(true);
            boolean bl12 = false;
            pokemonEntity.getPokemon().setAbility(ability);
        }
        Iterable $this$forEach$iv = this.customProperties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CustomPokemonProperty it9 = (CustomPokemonProperty)element$iv;
            boolean bl13 = false;
            it9.apply(pokemonEntity);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean matches(@NotNull Pokemon pokemon) {
        boolean bl;
        String string;
        String string2;
        String string3;
        Integer n;
        String string4;
        Object object;
        Object object2;
        block27: {
            Gender gender;
            Boolean bl2;
            int it;
            Intrinsics.checkNotNullParameter(pokemon, "pokemon");
            Integer n2 = this.level;
            if (n2 != null) {
                object2 = n2;
                it = ((Number)object2).intValue();
                boolean bl3 = false;
                Object object3 = object = it != pokemon.getLevel() ? object2 : null;
                if (object != null) {
                    it = ((Number)object).intValue();
                    return false;
                }
            }
            if ((bl2 = this.shiny) != null) {
                object2 = bl2;
                it = ((Boolean)object2).booleanValue() ? 1 : 0;
                boolean bl4 = false;
                Object object4 = object = it != pokemon.getShiny() ? object2 : null;
                if (object != null) {
                    it = ((Boolean)object).booleanValue() ? 1 : 0;
                    return false;
                }
            }
            if ((gender = this.gender) != null) {
                Object it2 = object2 = gender;
                boolean bl5 = false;
                Object object5 = object = it2 != pokemon.getGender() ? object2 : null;
                if (object != null) {
                    it2 = object;
                    return false;
                }
            }
            String string5 = this.species;
            if (string5 != null) {
                String $this$matches_u24lambda_u2d39 = string5;
                boolean bl6 = false;
                try {
                    Species species;
                    if (Intrinsics.areEqual($this$matches_u24lambda_u2d39, "random")) {
                        species = CollectionsKt.random(PokemonSpecies.INSTANCE.getSpecies(), Random.Default);
                    } else {
                        species = PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default($this$matches_u24lambda_u2d39, null, 1, null));
                        if (species == null) break block27;
                    }
                    Species species2 = species;
                    if (!Intrinsics.areEqual(pokemon.getSpecies(), species2)) {
                        return false;
                    }
                }
                catch (class_151 e) {
                    return false;
                }
            }
        }
        if ((string4 = this.form) != null) {
            object2 = string4;
            Object it = object2;
            boolean bl7 = false;
            Object object6 = object = !StringsKt.equals((String)it, pokemon.getForm().getName(), true) ? object2 : null;
            if (object != null) {
                it = object;
                return false;
            }
        }
        if ((n = this.friendship) != null) {
            object2 = n;
            int it = ((Number)object2).intValue();
            boolean bl8 = false;
            Object object7 = object = it != pokemon.getFriendship() ? object2 : null;
            if (object != null) {
                it = ((Number)object).intValue();
                return false;
            }
        }
        if ((string3 = this.pokeball) != null) {
            object2 = string3;
            Object it = object2;
            boolean bl9 = false;
            Object object8 = object = !Intrinsics.areEqual(it, pokemon.getCaughtBall().getName().toString()) ? object2 : null;
            if (object != null) {
                it = object;
                return false;
            }
        }
        if ((string2 = this.nature) != null) {
            object2 = string2;
            Object it = object2;
            boolean bl10 = false;
            Object object9 = object = !Intrinsics.areEqual(it, pokemon.getNature().getName().toString()) ? object2 : null;
            if (object != null) {
                it = object;
                return false;
            }
        }
        if ((string = this.ability) != null) {
            object2 = string;
            Object it = object2;
            boolean bl11 = false;
            Object object10 = object = !Intrinsics.areEqual(it, pokemon.getAbility().getName()) ? object2 : null;
            if (object != null) {
                it = object;
                return false;
            }
        }
        Iterable iterable = this.customProperties;
        boolean $i$f$none = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return true;
        }
        object2 = iterable.iterator();
        do {
            if (!object2.hasNext()) {
                return true;
            }
            Object element$iv = object2.next();
            CustomPokemonProperty it = (CustomPokemonProperty)element$iv;
            boolean bl12 = false;
            if (!it.matches(pokemon)) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    public final boolean matches(@NotNull PokemonEntity pokemonEntity) {
        boolean bl;
        block26: {
            Object object;
            Object object2;
            Object object3;
            block25: {
                int it;
                Intrinsics.checkNotNullParameter(pokemonEntity, "pokemonEntity");
                object3 = this.level;
                if (object3 != null) {
                    object2 = object3;
                    it = ((Number)object2).intValue();
                    boolean bl2 = false;
                    Object object4 = object = it != pokemonEntity.getPokemon().getLevel() ? object2 : null;
                    if (object != null) {
                        it = ((Number)object).intValue();
                        boolean bl3 = false;
                        return false;
                    }
                }
                if ((object3 = this.shiny) != null) {
                    object2 = object3;
                    it = ((Boolean)object2).booleanValue() ? 1 : 0;
                    boolean bl4 = false;
                    Object object5 = object = it != pokemonEntity.getPokemon().getAspects().contains("shiny") ? object2 : null;
                    if (object != null) {
                        it = ((Boolean)object).booleanValue() ? 1 : 0;
                        boolean bl5 = false;
                        return false;
                    }
                }
                if ((object3 = this.gender) != null) {
                    object2 = object3;
                    Integer it2 = object2;
                    boolean bl6 = false;
                    Object object6 = object = it2 != pokemonEntity.getPokemon().getGender() ? object2 : null;
                    if (object != null) {
                        it2 = object;
                        boolean bl7 = false;
                        return false;
                    }
                }
                String string = this.species;
                if (string != null) {
                    String $this$matches_u24lambda_u2d57 = string;
                    boolean bl8 = false;
                    try {
                        Species species;
                        if (Intrinsics.areEqual($this$matches_u24lambda_u2d57, "random")) {
                            species = CollectionsKt.random(PokemonSpecies.INSTANCE.getSpecies(), Random.Default);
                        } else {
                            species = PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default($this$matches_u24lambda_u2d57, null, 1, null));
                            if (species == null) break block25;
                        }
                        Species species2 = species;
                        if (!Intrinsics.areEqual(pokemonEntity.getPokemon().getSpecies(), species2)) {
                            return false;
                        }
                    }
                    catch (class_151 species2) {
                    }
                }
            }
            if ((object3 = this.form) != null) {
                object2 = object3;
                Integer it = object2;
                boolean bl9 = false;
                Object object7 = object = !StringsKt.equals((String)((Object)it), pokemonEntity.getPokemon().getForm().getName(), true) ? object2 : null;
                if (object != null) {
                    it = object;
                    boolean bl10 = false;
                    return false;
                }
            }
            if ((object3 = this.friendship) != null) {
                object2 = object3;
                int it = ((Number)object2).intValue();
                boolean bl11 = false;
                Object object8 = object = it != pokemonEntity.getPokemon().getFriendship() ? object2 : null;
                if (object != null) {
                    it = ((Number)object).intValue();
                    boolean bl12 = false;
                    return false;
                }
            }
            if ((object3 = this.pokeball) != null) {
                object2 = object3;
                Integer it = object2;
                boolean bl13 = false;
                Object object9 = object = !Intrinsics.areEqual(it, pokemonEntity.getPokemon().getCaughtBall().getName().toString()) ? object2 : null;
                if (object != null) {
                    it = object;
                    boolean bl14 = false;
                    return false;
                }
            }
            if ((object3 = this.nature) != null) {
                object2 = object3;
                Integer it = object2;
                boolean bl15 = false;
                Object object10 = object = !Intrinsics.areEqual(it, pokemonEntity.getPokemon().getNature().getName().toString()) ? object2 : null;
                if (object != null) {
                    it = object;
                    boolean bl16 = false;
                    return false;
                }
            }
            if ((object3 = this.ability) != null) {
                Object it = object2 = object3;
                boolean bl17 = false;
                Object object11 = object = !Intrinsics.areEqual(it, pokemonEntity.getPokemon().getAbility().getName()) ? object2 : null;
                if (object != null) {
                    it = object;
                    boolean bl18 = false;
                    return false;
                }
            }
            Iterable $this$none$iv = this.customProperties;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    CustomPokemonProperty it = (CustomPokemonProperty)element$iv;
                    boolean bl19 = false;
                    if (!(!it.matches(pokemonEntity))) continue;
                    bl = false;
                    break block26;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final Pokemon create() {
        Pokemon pokemon = new Pokemon();
        this.apply(pokemon);
        pokemon.setSpecies(pokemon.getSpecies());
        Pokemon.initializeMoveset$default(pokemon, false, 1, null);
        return pokemon;
    }

    @NotNull
    public final PokemonEntity createEntity(@NotNull class_1937 world) {
        Intrinsics.checkNotNullParameter(world, "world");
        return new PokemonEntity(world, this.create(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final class_2487 saveToNBT() {
        void $this$mapTo$iv$iv;
        class_2487 nbt = new class_2487();
        String it2 = this.originalString;
        boolean bl = false;
        nbt.method_10582("OriginalText", it2);
        Integer n = this.level;
        if (n != null) {
            int n2 = ((Number)n).intValue();
            boolean bl2 = false;
            nbt.method_10569("Level", n2);
        }
        Boolean bl2 = this.shiny;
        if (bl2 != null) {
            boolean bl3 = bl2;
            boolean bl4 = false;
            nbt.method_10556("Shiny", bl3);
        }
        Gender gender = this.gender;
        if (gender != null) {
            Gender gender2 = gender;
            boolean bl5 = false;
            nbt.method_10582("Gender", gender2.name());
        }
        String string = this.species;
        if (string != null) {
            String string2 = string;
            boolean bl6 = false;
            nbt.method_10582("SpeciesText", string2);
        }
        String string3 = this.form;
        if (string3 != null) {
            String string4 = string3;
            boolean bl7 = false;
            nbt.method_10582("FormId", string4);
        }
        Integer n3 = this.friendship;
        if (n3 != null) {
            int n4 = ((Number)n3).intValue();
            boolean bl8 = false;
            nbt.method_10569("Friendship", n4);
        }
        String string5 = this.pokeball;
        if (string5 != null) {
            String string6 = string5;
            boolean bl9 = false;
            nbt.method_10582("CaughtBall", string6);
        }
        String string7 = this.nature;
        if (string7 != null) {
            String string8 = string7;
            boolean bl10 = false;
            nbt.method_10582("Nature", string8);
        }
        String string9 = this.ability;
        if (string9 != null) {
            String string10 = string9;
            boolean bl11 = false;
            nbt.method_10582("Ability", string10);
        }
        class_2499 custom = new class_2499();
        Iterable $this$map$iv = this.customProperties;
        boolean bl4 = false;
        Iterable bl11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it10;
            CustomPokemonProperty customPokemonProperty = (CustomPokemonProperty)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl12 = false;
            collection.add(class_2519.method_23256((String)it10.asString()));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean bl5 = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2519 it11 = (class_2519)element$iv;
            boolean bl13 = false;
            custom.add((Object)it11);
        }
        nbt.method_10566("CustomProperties", (class_2520)custom);
        return nbt;
    }

    @NotNull
    public final PokemonProperties loadFromNBT(@NotNull class_2487 tag) {
        Gender gender;
        Intrinsics.checkNotNullParameter(tag, "tag");
        String string = tag.method_10558("OriginalText");
        Intrinsics.checkNotNullExpressionValue(string, "tag.getString(DataKeys.P\u2026PROPERTIES_ORIGINAL_TEXT)");
        this.originalString = string;
        this.level = tag.method_10545("Level") ? Integer.valueOf(tag.method_10550("Level")) : null;
        Boolean bl = this.shiny = tag.method_10545("Shiny") ? Boolean.valueOf(tag.method_10577("Shiny")) : null;
        if (tag.method_10545("Gender")) {
            String string2 = tag.method_10558("Gender");
            Intrinsics.checkNotNullExpressionValue(string2, "tag.getString(DataKeys.POKEMON_GENDER)");
            gender = Gender.valueOf(string2);
        } else {
            gender = null;
        }
        this.gender = gender;
        this.species = tag.method_10545("SpeciesText") ? tag.method_10558("SpeciesText") : null;
        this.form = tag.method_10545("FormId") ? tag.method_10558("FormId") : null;
        this.friendship = tag.method_10545("Friendship") ? Integer.valueOf(tag.method_10550("Friendship")) : null;
        this.pokeball = tag.method_10545("CaughtBall") ? tag.method_10558("CaughtBall") : null;
        this.nature = tag.method_10545("Nature") ? tag.method_10558("Nature") : null;
        this.ability = tag.method_10545("Ability") ? tag.method_10558("Ability") : null;
        class_2499 custom = tag.method_10554("CustomProperties", 8);
        Intrinsics.checkNotNullExpressionValue(custom, "custom");
        Iterable $this$forEach$iv = (Iterable)custom;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2520 it = (class_2520)element$iv;
            boolean bl2 = false;
            String string3 = it.method_10714();
            Intrinsics.checkNotNullExpressionValue(string3, "it.asString()");
            this.customProperties.addAll((Collection<CustomPokemonProperty>)com.cobblemon.mod.common.api.pokemon.PokemonProperties$Companion.parse$default((Companion)PokemonProperties.Companion, (String)string3, null, null, (int)6, null).customProperties);
        }
        this.updateAspects();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonObject saveToJSON() {
        void $this$mapTo$iv$iv;
        JsonObject json = new JsonObject();
        String it2 = this.originalString;
        boolean bl = false;
        json.addProperty("OriginalText", it2);
        Integer n = this.level;
        if (n != null) {
            int n2 = ((Number)n).intValue();
            boolean bl2 = false;
            json.addProperty("Level", (Number)n2);
        }
        Boolean bl2 = this.shiny;
        if (bl2 != null) {
            boolean bl3 = bl2;
            boolean bl4 = false;
            json.addProperty("Shiny", Boolean.valueOf(bl3));
        }
        Gender gender = this.gender;
        if (gender != null) {
            Gender gender2 = gender;
            boolean bl5 = false;
            json.addProperty("Gender", gender2.name());
        }
        String string = this.species;
        if (string != null) {
            String string2 = string;
            boolean bl6 = false;
            json.addProperty("SpeciesText", string2);
        }
        String string3 = this.form;
        if (string3 != null) {
            String string4 = string3;
            boolean bl7 = false;
            json.addProperty("FormId", string4);
        }
        Integer n3 = this.friendship;
        if (n3 != null) {
            int n4 = ((Number)n3).intValue();
            boolean bl8 = false;
            json.addProperty("Friendship", (Number)n4);
        }
        String string5 = this.pokeball;
        if (string5 != null) {
            String string6 = string5;
            boolean bl9 = false;
            json.addProperty("CaughtBall", string6);
        }
        String string7 = this.nature;
        if (string7 != null) {
            String string8 = string7;
            boolean bl10 = false;
            json.addProperty("Nature", string8);
        }
        String string9 = this.ability;
        if (string9 != null) {
            String string10 = string9;
            boolean bl11 = false;
            json.addProperty("Ability", string10);
        }
        JsonArray custom = new JsonArray();
        Iterable $this$map$iv = this.customProperties;
        boolean bl4 = false;
        Iterable bl11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it10;
            CustomPokemonProperty customPokemonProperty = (CustomPokemonProperty)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl12 = false;
            collection.add(it10.asString());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean bl5 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it11 = (String)element$iv;
            boolean bl13 = false;
            custom.add(it11);
        }
        json.add("CustomProperties", (JsonElement)custom);
        return json;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PokemonProperties loadFromJSON(@NotNull JsonObject json) {
        JsonArray custom;
        Gender gender;
        Intrinsics.checkNotNullParameter(json, "json");
        JsonElement jsonElement = json.get("OriginalText");
        String string = jsonElement != null ? jsonElement.getAsString() : null;
        if (string == null) {
            string = "";
        }
        this.originalString = string;
        JsonElement jsonElement2 = json.get("Level");
        this.level = jsonElement2 != null ? Integer.valueOf(jsonElement2.getAsInt()) : null;
        JsonElement jsonElement3 = json.get("Shiny");
        this.shiny = jsonElement3 != null ? Boolean.valueOf(jsonElement3.getAsBoolean()) : null;
        PokemonProperties pokemonProperties = this;
        Object object = json.get("Gender");
        if (object != null && (object = object.getAsString()) != null) {
            void it;
            JsonElement jsonElement4 = object;
            PokemonProperties pokemonProperties2 = pokemonProperties;
            boolean bl = false;
            gender = Gender.valueOf((String)it);
            pokemonProperties = pokemonProperties2;
        } else {
            gender = null;
        }
        pokemonProperties.gender = gender;
        JsonElement jsonElement5 = json.get("SpeciesText");
        this.species = jsonElement5 != null ? jsonElement5.getAsString() : null;
        JsonElement jsonElement6 = json.get("FormId");
        this.form = jsonElement6 != null ? jsonElement6.getAsString() : null;
        JsonElement jsonElement7 = json.get("Friendship");
        this.friendship = jsonElement7 != null ? Integer.valueOf(jsonElement7.getAsInt()) : null;
        JsonElement jsonElement8 = json.get("CaughtBall");
        this.pokeball = jsonElement8 != null ? jsonElement8.getAsString() : null;
        JsonElement jsonElement9 = json.get("Nature");
        this.nature = jsonElement9 != null ? jsonElement9.getAsString() : null;
        JsonElement jsonElement10 = json.get("Ability");
        this.ability = jsonElement10 != null ? jsonElement10.getAsString() : null;
        JsonElement jsonElement11 = json.get("CustomProperties");
        JsonArray jsonArray = custom = jsonElement11 != null ? jsonElement11.getAsJsonArray() : null;
        if (jsonArray != null) {
            Iterable $this$forEach$iv = (Iterable)jsonArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement it = (JsonElement)element$iv;
                boolean bl = false;
                String string2 = it.getAsString();
                Intrinsics.checkNotNullExpressionValue(string2, "it.asString");
                this.customProperties.addAll((Collection<CustomPokemonProperty>)com.cobblemon.mod.common.api.pokemon.PokemonProperties$Companion.parse$default((Companion)PokemonProperties.Companion, (String)string2, null, null, (int)6, null).customProperties);
            }
        }
        this.updateAspects();
        return this;
    }

    @NotNull
    public final String asString(@NotNull String separator) {
        String it;
        Intrinsics.checkNotNullParameter(separator, "separator");
        List pieces = new ArrayList();
        String string = this.species;
        if (string != null) {
            it = string;
            boolean bl = false;
            pieces.add(it);
        }
        String string2 = this.form;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            pieces.add("form=" + it);
        }
        Integer n = this.level;
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            pieces.add("level=" + it2);
        }
        Boolean bl = this.shiny;
        if (bl != null) {
            boolean it3 = bl;
            boolean bl2 = false;
            pieces.add("shiny=" + it3);
        }
        Gender gender = this.gender;
        if (gender != null) {
            Gender it4 = gender;
            boolean bl3 = false;
            pieces.add("gender=" + it4);
        }
        Integer n2 = this.friendship;
        if (n2 != null) {
            int it5 = ((Number)n2).intValue();
            boolean bl4 = false;
            pieces.add("friendship=" + it5);
        }
        String string3 = this.pokeball;
        if (string3 != null) {
            String it6 = string3;
            boolean bl5 = false;
            pieces.add("pokeball=" + it6);
        }
        String string4 = this.nature;
        if (string4 != null) {
            String it7 = string4;
            boolean bl6 = false;
            pieces.add("nature=" + it7);
        }
        String string5 = this.ability;
        if (string5 != null) {
            String it8 = string5;
            boolean bl7 = false;
            pieces.add("ability=" + it8);
        }
        Iterable $this$forEach$iv = this.customProperties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CustomPokemonProperty it9 = (CustomPokemonProperty)element$iv;
            boolean bl8 = false;
            pieces.add(it9.asString());
        }
        return CollectionsKt.joinToString$default(pieces, separator, null, null, 0, null, null, 62, null);
    }

    public static /* synthetic */ String asString$default(PokemonProperties pokemonProperties, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asString");
        }
        if ((n & 1) != 0) {
            string = " ";
        }
        return pokemonProperties.asString(string);
    }

    public final void updateAspects() {
        Set aspects = new LinkedHashSet();
        Iterable $this$forEach$iv = AspectProvider.Companion.getProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AspectProvider it = (AspectProvider)element$iv;
            boolean bl = false;
            aspects.addAll((Collection)it.provide(this));
        }
        this.aspects = CollectionsKt.toSet(aspects);
    }

    @NotNull
    public final PokemonProperties copy() {
        return new PokemonProperties().loadFromJSON(this.saveToJSON());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b&\u0010'JI\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00032\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ;\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J-\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0002H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014JQ\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0017H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ;\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ-\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0002H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0014JQ\u0010 \u001a\u0004\u0018\u00010\u00042\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0017H\u0002\u00a2\u0006\u0004\b \u0010\u001bJi\u0010$\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010!*\b\u0012\u0004\u0012\u00028\u00000\u00062\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\b\u0002\u0010\"\u001a\u00020\u00102\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u0017H\u0002\u00a2\u0006\u0004\b$\u0010%\u00a8\u0006("}, d2={"Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties$Companion;", "", "", "Lkotlin/Pair;", "", "keyPairs", "", "labels", "getMatchedKeyPair", "(Ljava/util/List;Ljava/lang/Iterable;)Lkotlin/Pair;", "string", "delimiter", "assigner", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "parse", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "", "parseBooleanProperty", "(Ljava/util/List;Ljava/lang/Iterable;)Ljava/lang/Boolean;", "parseForm", "(Ljava/util/List;)Ljava/lang/String;", "", "validKeys", "Lkotlin/Function1;", "Lnet/minecraft/class_2960;", "valueFetcher", "parseIdentifierOfRegistry", "(Ljava/util/List;Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "", "parseIntProperty", "(Ljava/util/List;Ljava/lang/Iterable;)Ljava/lang/Integer;", "parseSpeciesIdentifier", "parseStringOfRegistry", "T", "labelsOptional", "stringer", "parsePropertyOfCollection", "(Ljava/lang/Iterable;Ljava/util/List;Ljava/lang/Iterable;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PokemonProperties parse(@NotNull String string, @NotNull String delimiter, @NotNull String assigner) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(string, "string");
            Intrinsics.checkNotNullParameter(delimiter, "delimiter");
            Intrinsics.checkNotNullParameter(assigner, "assigner");
            PokemonProperties props = new PokemonProperties();
            props.setOriginalString(string);
            List<Pair<String, String>> keyPairs = StringExtensionsKt.splitMap(string, delimiter, assigner);
            String[] stringArray = (String[])CustomPokemonProperty.Companion.getProperties();
            PokemonProperties pokemonProperties = props;
            boolean $i$f$mapNotNull = false;
            void var8_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object v4;
                Object object;
                CustomPokemonPropertyType property;
                block8: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    property = (CustomPokemonPropertyType)element$iv$iv;
                    boolean bl2 = false;
                    Iterable iterable = keyPairs;
                    for (Object object2 : iterable) {
                        Pair it = (Pair)object2;
                        boolean bl3 = false;
                        Iterable<String> iterable2 = property.getKeys();
                        String string2 = ((String)it.getFirst()).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                        if (!CollectionsKt.contains(iterable2, string2)) continue;
                        object = object2;
                        break block8;
                    }
                    object = null;
                }
                Pair matchedKeyPair = (Pair)object;
                if (matchedKeyPair == null) {
                    if (!property.getNeedsKey()) {
                        Object v3;
                        Object savedProperty;
                        block9: {
                            Object object2;
                            savedProperty = null;
                            object2 = keyPairs;
                            Iterator iterator3 = object2.iterator();
                            while (iterator3.hasNext()) {
                                Object t = iterator3.next();
                                Pair keyPair = (Pair)t;
                                boolean bl = false;
                                savedProperty = property.fromString((String)keyPair.getSecond());
                                if (!(savedProperty != null)) continue;
                                v3 = t;
                                break block9;
                            }
                            v3 = null;
                        }
                        Pair keyPair = v3;
                        if (keyPair != null) {
                            keyPairs.remove(keyPair);
                        }
                        v4 = savedProperty;
                    } else {
                        v4 = null;
                    }
                } else {
                    keyPairs.remove(matchedKeyPair);
                    v4 = property.fromString((String)matchedKeyPair.getSecond());
                }
                if (v4 == null) continue;
                Object it$iv$iv = v4;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            pokemonProperties.setCustomProperties(CollectionsKt.toMutableList((List)destination$iv$iv));
            props.setGender((Gender)((Object)this.parsePropertyOfCollection((Iterable)ArraysKt.toList(Gender.values()), keyPairs, (Iterable<String>)CollectionsKt.listOf("gender"), true, parse.2.INSTANCE)));
            String[] stringArray2 = new String[]{"level", "lvl", "l"};
            Integer n = this.parseIntProperty(keyPairs, (Iterable<String>)CollectionsKt.listOf(stringArray2));
            props.setLevel(n != null ? Integer.valueOf(RangesKt.coerceIn(n, 1, Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel())) : null);
            stringArray = new String[]{"shiny", "s"};
            props.setShiny(this.parseBooleanProperty(keyPairs, (Iterable<String>)CollectionsKt.listOf(stringArray)));
            props.setSpecies(this.parseSpeciesIdentifier(keyPairs));
            props.setForm(this.parseForm(keyPairs));
            Integer n2 = this.parseIntProperty(keyPairs, (Iterable<String>)CollectionsKt.listOf("friendship"));
            props.setFriendship(n2 != null ? Integer.valueOf(RangesKt.coerceIn(n2, 0, Cobblemon.INSTANCE.getConfig().getMaxPokemonFriendship())) : null);
            props.setPokeball(this.parseIdentifierOfRegistry(keyPairs, CollectionsKt.listOf("pokeball"), parse.3.INSTANCE));
            props.setNature(this.parseIdentifierOfRegistry(keyPairs, CollectionsKt.listOf("nature"), parse.4.INSTANCE));
            props.setAbility(this.parseStringOfRegistry(keyPairs, CollectionsKt.listOf("ability"), parse.5.INSTANCE));
            props.updateAspects();
            return props;
        }

        public static /* synthetic */ PokemonProperties parse$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = " ";
            }
            if ((n & 4) != 0) {
                string3 = "=";
            }
            return companion.parse(string, string2, string3);
        }

        private final Pair<String, String> getMatchedKeyPair(List<Pair<String, String>> keyPairs, Iterable<String> labels) {
            Pair<String, String> pair;
            block1: {
                List<Pair<String, String>> list = keyPairs;
                ListIterator<Pair<String, String>> listIterator = list.listIterator(list.size());
                while (listIterator.hasPrevious()) {
                    Pair<String, String> pair2;
                    Pair<String, String> it = pair2 = listIterator.previous();
                    boolean bl = false;
                    if (!CollectionsKt.contains(labels, it.getFirst())) continue;
                    pair = pair2;
                    break block1;
                }
                pair = null;
            }
            return pair;
        }

        private final Integer parseIntProperty(List<Pair<String, String>> keyPairs, Iterable<String> labels) {
            Pair<String, String> pair = this.getMatchedKeyPair(keyPairs, labels);
            if (pair == null) {
                return null;
            }
            Pair<String, String> matchingKeyPair = pair;
            String value = matchingKeyPair.getSecond();
            return value == null || !MiscUtilsKt.isInt(value) ? (Integer)null : Integer.valueOf(Integer.parseInt(value));
        }

        private final String parseIdentifierOfRegistry(List<Pair<String, String>> keyPairs, List<String> validKeys, Function1<? super class_2960, String> valueFetcher) {
            String string;
            String string2;
            block7: {
                block6: {
                    Pair<String, String> pair = this.getMatchedKeyPair(keyPairs, (Iterable<String>)validKeys);
                    if (pair == null) {
                        return null;
                    }
                    Pair<String, String> matched = pair;
                    string2 = matched.getSecond();
                    if (string2 == null) break block6;
                    String string3 = string2.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    string2 = string3;
                    if (string3 != null) break block7;
                }
                return null;
            }
            String value = string2;
            try {
                class_2960 identifier = ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(value, null, 1, null);
                string = valueFetcher.invoke((class_2960)identifier);
            }
            catch (class_151 class_1512) {
                string = null;
            }
            return string;
        }

        private final String parseStringOfRegistry(List<Pair<String, String>> keyPairs, List<String> validKeys, Function1<? super String, String> valueFetcher) {
            String string;
            String string2;
            block7: {
                block6: {
                    Pair<String, String> pair = this.getMatchedKeyPair(keyPairs, (Iterable<String>)validKeys);
                    if (pair == null) {
                        return null;
                    }
                    Pair<String, String> matched = pair;
                    string2 = matched.getSecond();
                    if (string2 == null) break block6;
                    String string3 = string2.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    string2 = string3;
                    if (string3 != null) break block7;
                }
                return null;
            }
            String value = string2;
            try {
                string = valueFetcher.invoke(value);
            }
            catch (class_151 class_1512) {
                string = null;
            }
            return string;
        }

        /*
         * Unable to fully structure code
         */
        private final String parseSpeciesIdentifier(List<Pair<String, String>> keyPairs) {
            block16: {
                block17: {
                    block19: {
                        block18: {
                            matched = this.getMatchedKeyPair(keyPairs, (Iterable<String>)CollectionsKt.listOf("species"));
                            if (matched == null) break block17;
                            v0 = matched.getSecond();
                            if (v0 == null) break block18;
                            v1 = v0.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(v1, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                            v0 = v1;
                            if (v1 != null) break block19;
                        }
                        return null;
                    }
                    value = v0;
                    v2 = value.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(v2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    if (!Intrinsics.areEqual(v2, "random")) {
                        try {
                            v3 = PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(value, null, 1, null));
                            if (v3 == null) {
                                return null;
                            }
                            species = v3;
                            return Intrinsics.areEqual(species.getResourceIdentifier().method_12836(), "cobblemon") != false ? species.getResourceIdentifier().method_12832() : species.getResourceIdentifier().toString();
                        }
                        catch (class_151 e) {
                            return null;
                        }
                    }
                    return "random";
                }
                species = null;
                var6_8 = keyPairs;
                for (T var8_10 : var6_8) {
                    block15: {
                        pair = (Pair)var8_10;
                        $i$a$-find-PokemonProperties$Companion$parseSpeciesIdentifier$keyPair$1 = false;
                        if (pair.getSecond() != null) ** GOTO lbl-1000
                        v4 = ((String)pair.getFirst()).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(v4, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                        if (Intrinsics.areEqual(v4, "random")) {
                            v5 = "random";
                        } else lbl-1000:
                        // 2 sources

                        {
                            try {
                                identifier = ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default((String)pair.getFirst(), null, 1, null);
                                if (PokemonSpecies.INSTANCE.getByIdentifier(identifier) == null) {
                                    v6 = false;
                                    break block15;
                                }
                                var11_13 = Intrinsics.areEqual(found.getResourceIdentifier().method_12836(), "cobblemon") != false ? found.getResourceIdentifier().method_12832() : found.getResourceIdentifier().toString();
                            }
                            catch (class_151 e) {
                                v6 = false;
                                break block15;
                            }
                            v5 = var11_13;
                        }
                        species = v5;
                        v6 = species != null;
                    }
                    if (!v6) continue;
                    v7 = var8_10;
                    break block16;
                }
                v7 = null;
            }
            keyPair = v7;
            if (keyPair != null) {
                keyPairs.remove(keyPair);
            }
            return species;
        }

        private final String parseForm(List<Pair<String, String>> keyPairs) {
            Pair<String, String> pair = this.getMatchedKeyPair(keyPairs, (Iterable<String>)CollectionsKt.listOf("form"));
            if (pair == null) {
                return null;
            }
            Pair<String, String> matchingKeyPair = pair;
            keyPairs.remove(matchingKeyPair);
            return matchingKeyPair.getSecond();
        }

        /*
         * Unable to fully structure code
         */
        private final Boolean parseBooleanProperty(List<Pair<String, String>> keyPairs, Iterable<String> labels) {
            block12: {
                block11: {
                    v0 = this.getMatchedKeyPair(keyPairs, labels);
                    if (v0 == null) {
                        return null;
                    }
                    matchingKeyPair = v0;
                    keyPairs.remove(matchingKeyPair);
                    v1 = matchingKeyPair.getSecond();
                    if (v1 != null) {
                        v2 = v1.toLowerCase(Locale.ROOT);
                        v3 = v2;
                        Intrinsics.checkNotNullExpressionValue(v2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    } else {
                        v3 = null;
                    }
                    v4 = var4_4 = v3;
                    if (v4 == null) ** GOTO lbl31
                    switch (v4.hashCode()) {
                        case 3521: {
                            if (!var4_4.equals("no")) {
                                ** break;
                            }
                            break block11;
                        }
                        case 119527: {
                            if (var4_4.equals("yes")) break;
                            ** break;
                        }
                        case 3569038: {
                            if (var4_4.equals("true")) break;
                            ** break;
                        }
                        case 97196323: {
                            if (!var4_4.equals("false")) {
                                ** break;
                            }
                            break block11;
                        }
lbl31:
                        // 1 sources

                        v5 = true;
                        break block12;
                    }
                    v5 = true;
                    break block12;
                }
                v5 = false;
                break block12;
lbl38:
                // 5 sources

                v5 = null;
            }
            return v5;
        }

        private final <T> T parsePropertyOfCollection(Iterable<? extends T> $this$parsePropertyOfCollection, List<Pair<String, String>> keyPairs, Iterable<String> labels, boolean labelsOptional, Function1<? super T, String> stringer) {
            Pair<String, String> matchingKeyPair = this.getMatchedKeyPair(keyPairs, labels);
            if (matchingKeyPair != null) {
                Object v3;
                String value;
                String string = matchingKeyPair.getSecond();
                if (string != null) {
                    String string2 = string.toLowerCase(Locale.ROOT);
                    v2 = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                } else {
                    v2 = value = null;
                }
                if (value == null) {
                    v3 = null;
                } else {
                    Object matched;
                    block14: {
                        Object v5;
                        Iterable<T> iterable = $this$parsePropertyOfCollection;
                        Iterator<T> iterator2 = iterable.iterator();
                        while (iterator2.hasNext()) {
                            T t;
                            T it = t = iterator2.next();
                            boolean bl = false;
                            String string3 = stringer.invoke(it).toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                            if (!Intrinsics.areEqual(string3, value)) continue;
                            v5 = t;
                            break block14;
                        }
                        v5 = matched = null;
                    }
                    if (matched != null) {
                        keyPairs.remove(matchingKeyPair);
                    }
                    v3 = matched;
                }
                return v3;
            }
            if (labelsOptional) {
                Object v8;
                block16: {
                    Iterable $this$firstOrNull$iv = keyPairs;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        boolean bl;
                        block15: {
                            Pair pair = (Pair)element$iv;
                            boolean bl2 = false;
                            Iterable<T> $this$any$iv = $this$parsePropertyOfCollection;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                Iterator<T> iterator3 = $this$any$iv.iterator();
                                while (iterator3.hasNext()) {
                                    T element$iv2;
                                    T it = element$iv2 = iterator3.next();
                                    boolean bl3 = false;
                                    String string = stringer.invoke(it).toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                                    if (!Intrinsics.areEqual(string, pair.getFirst())) continue;
                                    bl = true;
                                    break block15;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        v8 = element$iv;
                        break block16;
                    }
                    v8 = null;
                }
                Pair keyPair = v8;
                if (keyPair != null) {
                    Object element$iv;
                    block17: {
                        keyPairs.remove(keyPair);
                        Iterable<T> $this$first$iv = $this$parsePropertyOfCollection;
                        boolean $i$f$first = false;
                        Iterator<Object> iterator4 = $this$first$iv.iterator();
                        while (iterator4.hasNext()) {
                            Object it = element$iv = iterator4.next();
                            boolean bl = false;
                            String string = stringer.invoke(it).toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                            if (!Intrinsics.areEqual(string, keyPair.getFirst())) continue;
                            break block17;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    return element$iv;
                }
            }
            return null;
        }

        static /* synthetic */ Object parsePropertyOfCollection$default(Companion companion, Iterable iterable, List list, Iterable iterable2, boolean bl, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.parsePropertyOfCollection(iterable, list, iterable2, bl, function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

