/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.moves;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.MoveTarget;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.cobblemon.mod.common.net.messages.client.data.MovesRegistrySyncPacket;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b8\u00109J\u0013\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u001a\u001a\u00020\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010 \u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001a\u0010\u000e\u001a\u00020)8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010*\u001a\u0004\b+\u0010,R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010(R \u0010/\u001a\b\u0012\u0004\u0012\u00020\u00000.8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u001a\u00104\u001a\u0002038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107\u00a8\u0006:"}, d2={"Lcom/cobblemon/mod/common/api/moves/Moves;", "Lcom/cobblemon/mod/common/api/data/DataRegistry;", "", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "all", "()Ljava/util/List;", "", "count", "()I", "", "name", "getByName", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "getByNameOrDummy", "id", "getByNumericalId", "(I)Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "getExceptional", "()Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "", "names", "()Ljava/util/Collection;", "moves", "", "receiveSyncPacket$common", "(Ljava/util/Collection;)V", "receiveSyncPacket", "move", "register", "(Lcom/cobblemon/mod/common/api/moves/MoveTemplate;)V", "Lnet/minecraft/class_3300;", "manager", "reload", "(Lnet/minecraft/class_3300;)V", "Lnet/minecraft/class_3222;", "player", "sync", "(Lnet/minecraft/class_3222;)V", "", "allMoves", "Ljava/util/Map;", "Lnet/minecraft/class_2960;", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "idMapping", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "Lnet/minecraft/class_3264;", "type", "Lnet/minecraft/class_3264;", "getType", "()Lnet/minecraft/class_3264;", "<init>", "()V", "common"})
public final class Moves
implements DataRegistry {
    @NotNull
    public static final Moves INSTANCE = new Moves();
    @NotNull
    private static final class_2960 id = MiscUtilsKt.cobblemonResource("moves");
    @NotNull
    private static final class_3264 type = class_3264.field_14190;
    @NotNull
    private static final SimpleObservable<Moves> observable = new SimpleObservable();
    @NotNull
    private static final Map<String, MoveTemplate> allMoves = new LinkedHashMap();
    @NotNull
    private static final Map<Integer, MoveTemplate> idMapping = new LinkedHashMap();

    private Moves() {
    }

    @Override
    @NotNull
    public class_2960 getId() {
        return id;
    }

    @Override
    @NotNull
    public class_3264 getType() {
        return type;
    }

    @NotNull
    public SimpleObservable<Moves> getObservable() {
        return observable;
    }

    @Override
    public void reload(@NotNull class_3300 manager) {
        Intrinsics.checkNotNullParameter(manager, "manager");
        allMoves.clear();
        idMapping.clear();
        JsonArray movesJson = ShowdownService.Companion.get().getMoves();
        int n = movesJson.size();
        for (int i = 0; i < n; ++i) {
            JsonObject jsMove = movesJson.get(i).getAsJsonObject();
            String id = jsMove.get("id").getAsString();
            try {
                int num = jsMove.get("num").getAsInt();
                String string = jsMove.get("type").getAsString();
                Intrinsics.checkNotNullExpressionValue(string, "jsMove.get(\"type\").asString");
                ElementalType elementalType = ElementalTypes.INSTANCE.getOrException(string);
                String string2 = jsMove.get("category").getAsString();
                Intrinsics.checkNotNullExpressionValue(string2, "jsMove.get(\"category\").asString");
                DamageCategory damageCategory = DamageCategories.INSTANCE.getOrException(string2);
                double power = jsMove.get("basePower").getAsDouble();
                String string3 = jsMove.get("target").getAsString();
                Intrinsics.checkNotNullExpressionValue(string3, "jsMove.get(\"target\").asString");
                MoveTarget target = MoveTarget.Companion.fromShowdownId(string3);
                JsonPrimitive accuracyJson = jsMove.get("accuracy").getAsJsonPrimitive();
                double accuracy = accuracyJson.isNumber() ? accuracyJson.getAsDouble() : -1.0;
                int pp = jsMove.get("pp").getAsInt();
                int priority = jsMove.get("priority").getAsInt();
                JsonElement jsonElement = jsMove.get("critRatio");
                double critRatio = jsonElement != null ? jsonElement.getAsDouble() : 1.0;
                ArrayList effectChances = new ArrayList();
                JsonElement secondariesMember = jsMove.get("secondaries");
                JsonElement secondaryMember = jsMove.get("secondary");
                if (secondariesMember != null && secondariesMember instanceof JsonArray) {
                    int n2 = ((JsonArray)secondariesMember).size();
                    for (int j = 0; j < n2; ++j) {
                        JsonObject element = ((JsonArray)secondariesMember).get(j).getAsJsonObject();
                        if (!element.has("chance")) continue;
                        ((Collection)effectChances).add(element.get("chance").getAsDouble());
                    }
                } else if (secondaryMember != null && secondaryMember instanceof JsonObject && ((JsonObject)secondaryMember).has("chance")) {
                    ((Collection)effectChances).add(((JsonObject)secondaryMember).get("chance").getAsDouble());
                }
                Intrinsics.checkNotNullExpressionValue(id, "id");
                Collection $this$toTypedArray$iv = effectChances;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Double[] doubleArray = thisCollection$iv.toArray(new Double[0]);
                Intrinsics.checkNotNull(doubleArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                MoveTemplate move = new MoveTemplate(id, num, elementalType, damageCategory, power, target, accuracy, pp, priority, critRatio, doubleArray);
                this.register(move);
                continue;
            }
            catch (Exception e) {
                Cobblemon.INSTANCE.getLOGGER().error("Caught exception trying to resolve the move '{}'", (Object)id, (Object)e);
            }
        }
        Cobblemon.INSTANCE.getLOGGER().info("Loaded {} moves", (Object)allMoves.size());
        Moves[] movesArray = new Moves[]{this};
        this.getObservable().emit((Moves[])movesArray);
    }

    @Override
    public void sync(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        new MovesRegistrySyncPacket(this.all()).sendToPlayer(player);
    }

    @Nullable
    public final MoveTemplate getByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return allMoves.get(string);
    }

    @Nullable
    public final MoveTemplate getByNumericalId(int id) {
        return idMapping.get(id);
    }

    @NotNull
    public final MoveTemplate getByNameOrDummy(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        MoveTemplate moveTemplate = allMoves.get(string);
        if (moveTemplate == null) {
            String string2 = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            moveTemplate = MoveTemplate.Companion.dummy(string2);
        }
        return moveTemplate;
    }

    @NotNull
    public final MoveTemplate getExceptional() {
        MoveTemplate moveTemplate = this.getByName("tackle");
        if (moveTemplate == null) {
            moveTemplate = CollectionsKt.random(allMoves.values(), Random.Default);
        }
        return moveTemplate;
    }

    public final int count() {
        return allMoves.size();
    }

    @NotNull
    public final Collection<String> names() {
        return CollectionsKt.toSet((Iterable)allMoves.keySet());
    }

    @NotNull
    public final List<MoveTemplate> all() {
        return CollectionsKt.toList((Iterable)allMoves.values());
    }

    public final void receiveSyncPacket$common(@NotNull Collection<? extends MoveTemplate> moves) {
        Intrinsics.checkNotNullParameter(moves, "moves");
        Iterable $this$forEach$iv = moves;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MoveTemplate p0 = (MoveTemplate)element$iv;
            boolean bl = false;
            this.register(p0);
        }
    }

    private final void register(MoveTemplate move) {
        allMoves.put(move.getName(), move);
        idMapping.put(move.getNum(), move);
    }
}

