/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.moves;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.MoveTarget;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.google.gson.annotations.SerializedName;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 >2\u00020\u0001:\u0002>?Be\u0012\u0006\u0010*\u001a\u00020)\u0012\u0006\u0010.\u001a\u00020\u0005\u0012\u0006\u0010\"\u001a\u00020!\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u00101\u001a\u00020\n\u0012\u0006\u00108\u001a\u000207\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u00103\u001a\u00020\u0005\u0012\u0006\u00105\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001c\u00a2\u0006\u0004\b<\u0010=J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\u0007J\u001d\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\u00020!8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0011\u0010(\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0017\u0010*\u001a\u00020)8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010.\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u0010'R\u0017\u00101\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b1\u0010\f\u001a\u0004\b2\u0010\u000eR\u0017\u00103\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b3\u0010/\u001a\u0004\b4\u0010'R\u0017\u00105\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b5\u0010/\u001a\u0004\b6\u0010'R\u0017\u00108\u001a\u0002078\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\u00a8\u0006@"}, d2={"Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "", "Lcom/cobblemon/mod/common/api/moves/Move;", "create", "()Lcom/cobblemon/mod/common/api/moves/Move;", "", "currentPp", "(I)Lcom/cobblemon/mod/common/api/moves/Move;", "raisedPpStages", "(II)Lcom/cobblemon/mod/common/api/moves/Move;", "", "accuracy", "D", "getAccuracy", "()D", "critRatio", "getCritRatio", "Lcom/cobblemon/mod/common/api/moves/categories/DamageCategory;", "damageCategory", "Lcom/cobblemon/mod/common/api/moves/categories/DamageCategory;", "getDamageCategory", "()Lcom/cobblemon/mod/common/api/moves/categories/DamageCategory;", "Lnet/minecraft/class_5250;", "getDescription", "()Lnet/minecraft/class_5250;", "description", "getDisplayName", "displayName", "", "effectChances", "[Ljava/lang/Double;", "getEffectChances", "()[Ljava/lang/Double;", "Lcom/cobblemon/mod/common/api/types/ElementalType;", "elementalType", "Lcom/cobblemon/mod/common/api/types/ElementalType;", "getElementalType", "()Lcom/cobblemon/mod/common/api/types/ElementalType;", "getMaxPp", "()I", "maxPp", "", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "num", "I", "getNum", "power", "getPower", "pp", "getPp", "priority", "getPriority", "Lcom/cobblemon/mod/common/battles/MoveTarget;", "target", "Lcom/cobblemon/mod/common/battles/MoveTarget;", "getTarget", "()Lcom/cobblemon/mod/common/battles/MoveTarget;", "<init>", "(Ljava/lang/String;ILcom/cobblemon/mod/common/api/types/ElementalType;Lcom/cobblemon/mod/common/api/moves/categories/DamageCategory;DLcom/cobblemon/mod/common/battles/MoveTarget;DIID[Ljava/lang/Double;)V", "Companion", "Dummy", "common"})
public class MoveTemplate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int num;
    @SerializedName(value="type")
    @NotNull
    private final ElementalType elementalType;
    @NotNull
    private final DamageCategory damageCategory;
    private final double power;
    @NotNull
    private final MoveTarget target;
    private final double accuracy;
    private final int pp;
    private final int priority;
    private final double critRatio;
    @NotNull
    private final Double[] effectChances;

    public MoveTemplate(@NotNull String name, int num, @NotNull ElementalType elementalType, @NotNull DamageCategory damageCategory, double power, @NotNull MoveTarget target, double accuracy, int pp, int priority, double critRatio, @NotNull Double[] effectChances) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(elementalType, "elementalType");
        Intrinsics.checkNotNullParameter(damageCategory, "damageCategory");
        Intrinsics.checkNotNullParameter((Object)target, "target");
        Intrinsics.checkNotNullParameter(effectChances, "effectChances");
        this.name = name;
        this.num = num;
        this.elementalType = elementalType;
        this.damageCategory = damageCategory;
        this.power = power;
        this.target = target;
        this.accuracy = accuracy;
        this.pp = pp;
        this.priority = priority;
        this.critRatio = critRatio;
        this.effectChances = effectChances;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getNum() {
        return this.num;
    }

    @NotNull
    public final ElementalType getElementalType() {
        return this.elementalType;
    }

    @NotNull
    public final DamageCategory getDamageCategory() {
        return this.damageCategory;
    }

    public final double getPower() {
        return this.power;
    }

    @NotNull
    public final MoveTarget getTarget() {
        return this.target;
    }

    public final double getAccuracy() {
        return this.accuracy;
    }

    public final int getPp() {
        return this.pp;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final double getCritRatio() {
        return this.critRatio;
    }

    @NotNull
    public final Double[] getEffectChances() {
        return this.effectChances;
    }

    @NotNull
    public final class_5250 getDisplayName() {
        class_5250 class_52502 = LocalizationUtilsKt.lang("move." + this.name, new Object[0]);
        Intrinsics.checkNotNullExpressionValue(class_52502, "lang(\"move.$name\")");
        return class_52502;
    }

    @NotNull
    public final class_5250 getDescription() {
        class_5250 class_52502 = LocalizationUtilsKt.lang("move." + this.name + ".desc", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(class_52502, "lang(\"move.$name.desc\")");
        return class_52502;
    }

    public final int getMaxPp() {
        return 8 * this.pp / 5;
    }

    @NotNull
    public final Move create() {
        return this.create(this.pp);
    }

    @NotNull
    public final Move create(int currentPp) {
        return this.create(currentPp, 0);
    }

    @NotNull
    public final Move create(int currentPp, int raisedPpStages) {
        return new Move(this, currentPp, raisedPpStages);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/cobblemon/mod/common/api/moves/MoveTemplate$Dummy;", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "", "name", "<init>", "(Ljava/lang/String;)V", "common"})
    public static final class Dummy
    extends MoveTemplate {
        public Dummy(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            boolean $i$f$emptyArray = false;
            super(name, -1, ElementalTypes.INSTANCE.getNORMAL(), DamageCategories.INSTANCE.getSTATUS(), 0.0, MoveTarget.all, 100.0, 5, 0, 0.0, (Double[])((Object[])new Double[0]));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/moves/MoveTemplate$Companion;", "", "", "name", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate$Dummy;", "dummy", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/moves/MoveTemplate$Dummy;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dummy dummy(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new Dummy(name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

