/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.battles.model.actor;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BallActionResponse;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.exception.IllegalActionChoiceException;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMakeChoicePacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMessagePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010b\u001a\u00020\r\u0012\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u000201\u00a2\u0006\u0004\bf\u0010gJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH&\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001cH&\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'J\u001b\u0010+\u001a\u00020\u00062\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(\u00a2\u0006\u0004\b+\u0010,J\r\u0010-\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020\u0006\u00a2\u0006\u0004\b/\u0010.J\r\u00100\u001a\u00020\u0006\u00a2\u0006\u0004\b0\u0010.R\u001d\u00103\u001a\b\u0012\u0004\u0012\u000202018\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\"\u00108\u001a\u0002078\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\"\u0010>\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\"\u0010D\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\"\u0010J\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010?\u001a\u0004\bK\u0010A\"\u0004\bL\u0010CR\u001d\u0010M\u001a\b\u0012\u0004\u0012\u00020\u0002018\u0006\u00a2\u0006\f\n\u0004\bM\u00104\u001a\u0004\bN\u00106R$\u0010P\u001a\u0004\u0018\u00010O8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR(\u0010*\u001a\b\u0012\u0004\u0012\u00020)018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u00104\u001a\u0004\bV\u00106\"\u0004\bW\u0010,R\"\u0010X\u001a\u00020\u001c8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bX\u0010Y\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u0014\u0010a\u001a\u00020^8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010`R\u0017\u0010b\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\bb\u0010c\u001a\u0004\bd\u0010e\u00a8\u0006h"}, d2={"Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "", "experience", "", "awardExperience", "(Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;I)V", "Lnet/minecraft/class_5250;", "getName", "()Lnet/minecraft/class_5250;", "", "Ljava/util/UUID;", "getPlayerUUIDs", "()Ljava/lang/Iterable;", "Lcom/cobblemon/mod/common/battles/BattleSide;", "getSide", "()Lcom/cobblemon/mod/common/battles/BattleSide;", "Lnet/minecraft/class_3222;", "serverPlayerEntity", "", "isForPlayer", "(Lnet/minecraft/class_3222;)Z", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "isForPokemon", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "", "name", "nameOwned", "(Ljava/lang/String;)Lnet/minecraft/class_5250;", "Lnet/minecraft/class_2561;", "component", "sendMessage", "(Lnet/minecraft/class_2561;)V", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "packet", "sendUpdate", "(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "", "Lcom/cobblemon/mod/common/battles/ShowdownActionResponse;", "responses", "setActionResponses", "(Ljava/util/List;)V", "turn", "()V", "upkeep", "writeShowdownResponse", "", "Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;", "activePokemon", "Ljava/util/List;", "getActivePokemon", "()Ljava/util/List;", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "getBattle", "()Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "setBattle", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "canDynamax", "Z", "getCanDynamax", "()Z", "setCanDynamax", "(Z)V", "expectingCaptureActions", "I", "getExpectingCaptureActions", "()I", "setExpectingCaptureActions", "(I)V", "mustChoose", "getMustChoose", "setMustChoose", "pokemonList", "getPokemonList", "Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;", "request", "Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;", "getRequest", "()Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;", "setRequest", "(Lcom/cobblemon/mod/common/battles/ShowdownActionRequest;)V", "getResponses", "setResponses", "showdownId", "Ljava/lang/String;", "getShowdownId", "()Ljava/lang/String;", "setShowdownId", "(Ljava/lang/String;)V", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "getType", "()Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "type", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;Ljava/util/List;)V", "common"})
public abstract class BattleActor {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final List<BattlePokemon> pokemonList;
    public String showdownId;
    public PokemonBattle battle;
    @NotNull
    private final List<ActiveBattlePokemon> activePokemon;
    private boolean canDynamax;
    @Nullable
    private ShowdownActionRequest request;
    @NotNull
    private List<ShowdownActionResponse> responses;
    private int expectingCaptureActions;
    private boolean mustChoose;

    public BattleActor(@NotNull UUID uuid2, @NotNull List<BattlePokemon> pokemonList) {
        Intrinsics.checkNotNullParameter(uuid2, "uuid");
        Intrinsics.checkNotNullParameter(pokemonList, "pokemonList");
        this.uuid = uuid2;
        this.pokemonList = pokemonList;
        Iterable $this$forEach$iv = this.pokemonList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BattlePokemon it = (BattlePokemon)element$iv;
            boolean bl = false;
            it.setActor(this);
        }
        this.activePokemon = new ArrayList();
        this.responses = new ArrayList();
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final List<BattlePokemon> getPokemonList() {
        return this.pokemonList;
    }

    @NotNull
    public final String getShowdownId() {
        String string = this.showdownId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("showdownId");
        return null;
    }

    public final void setShowdownId(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.showdownId = string;
    }

    @NotNull
    public final PokemonBattle getBattle() {
        PokemonBattle pokemonBattle = this.battle;
        if (pokemonBattle != null) {
            return pokemonBattle;
        }
        Intrinsics.throwUninitializedPropertyAccessException("battle");
        return null;
    }

    public final void setBattle(@NotNull PokemonBattle pokemonBattle) {
        Intrinsics.checkNotNullParameter(pokemonBattle, "<set-?>");
        this.battle = pokemonBattle;
    }

    @NotNull
    public final List<ActiveBattlePokemon> getActivePokemon() {
        return this.activePokemon;
    }

    public final boolean getCanDynamax() {
        return this.canDynamax;
    }

    public final void setCanDynamax(boolean bl) {
        this.canDynamax = bl;
    }

    @Nullable
    public final ShowdownActionRequest getRequest() {
        return this.request;
    }

    public final void setRequest(@Nullable ShowdownActionRequest showdownActionRequest) {
        this.request = showdownActionRequest;
    }

    @NotNull
    public final List<ShowdownActionResponse> getResponses() {
        return this.responses;
    }

    public final void setResponses(@NotNull List<ShowdownActionResponse> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.responses = list;
    }

    public final int getExpectingCaptureActions() {
        return this.expectingCaptureActions;
    }

    public final void setExpectingCaptureActions(int n) {
        this.expectingCaptureActions = n;
    }

    public final boolean getMustChoose() {
        return this.mustChoose;
    }

    public final void setMustChoose(boolean bl) {
        this.mustChoose = bl;
    }

    @NotNull
    public abstract ActorType getType();

    @NotNull
    public final BattleSide getSide() {
        return ArraysKt.contains(this.getBattle().getSide1().getActors(), this) ? this.getBattle().getSide1() : this.getBattle().getSide2();
    }

    @NotNull
    public Iterable<UUID> getPlayerUUIDs() {
        return CollectionsKt.emptyList();
    }

    public boolean isForPlayer(@NotNull class_3222 serverPlayerEntity) {
        Intrinsics.checkNotNullParameter(serverPlayerEntity, "serverPlayerEntity");
        return CollectionsKt.contains(this.getPlayerUUIDs(), serverPlayerEntity.method_5667());
    }

    public boolean isForPokemon(@NotNull PokemonEntity pokemonEntity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(pokemonEntity, "pokemonEntity");
            Iterable $this$any$iv = this.activePokemon;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ActiveBattlePokemon it = (ActiveBattlePokemon)element$iv;
                    boolean bl2 = false;
                    Object object = it.getBattlePokemon();
                    if (!Intrinsics.areEqual(object != null && (object = ((BattlePokemon)object).getEffectedPokemon()) != null ? ((Pokemon)object).getEntity() : null, pokemonEntity)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void turn() {
        ShowdownActionRequest showdownActionRequest = this.request;
        if (showdownActionRequest == null) {
            return;
        }
        ShowdownActionRequest request = showdownActionRequest;
        this.responses.clear();
        this.mustChoose = true;
        this.sendUpdate(new BattleMakeChoicePacket());
        List<ShowdownMoveset> requestActive = request.getActive();
        if (requestActive == null || requestActive.isEmpty() || request.getWait()) {
            this.request = null;
            this.expectingCaptureActions = 0;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void upkeep() {
        void $this$mapIndexedNotNullTo$iv$iv;
        ShowdownActionRequest showdownActionRequest = this.request;
        if (showdownActionRequest == null) {
            return;
        }
        ShowdownActionRequest request = showdownActionRequest;
        Iterable $this$mapIndexedNotNull$iv = request.getForceSwitch();
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            ActiveBattlePokemon it$iv$iv;
            void b;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            boolean bl2 = (Boolean)element$iv$iv;
            int index = index$iv$iv;
            boolean bl3 = false;
            if ((b != false ? this.activePokemon.get(index) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List forceSwitchPokemon = (List)destination$iv$iv;
        if (forceSwitchPokemon.isEmpty()) {
            return;
        }
        this.sendUpdate(new BattleMakeChoicePacket());
        this.mustChoose = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void setActionResponses(@NotNull List<? extends ShowdownActionResponse> responses) {
        Intrinsics.checkNotNullParameter(responses, "responses");
        ShowdownActionRequest showdownActionRequest = this.request;
        if (showdownActionRequest == null) {
            return;
        }
        ShowdownActionRequest request = showdownActionRequest;
        int originalCaptureActions = this.expectingCaptureActions;
        Iterable $this$forEachIndexed$iv = responses;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void response;
            ShowdownMoveset showdownMoveset;
            List<Object> it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ShowdownActionResponse showdownActionResponse = (ShowdownActionResponse)item$iv;
            int index = n;
            boolean bl = false;
            List<ActiveBattlePokemon> it2 = this.activePokemon;
            boolean bl2 = false;
            if (it2.size() <= index) {
                return;
            }
            ActiveBattlePokemon activeBattlePokemon = it2.get(index);
            List<ShowdownMoveset> list = request.getActive();
            if (list != null) {
                it = list;
                boolean bl3 = false;
                showdownMoveset = it.size() > index ? (ShowdownMoveset)it.get(index) : null;
            } else {
                showdownMoveset = null;
            }
            ShowdownMoveset showdownMoveSet = showdownMoveset;
            it = request.getForceSwitch();
            boolean bl4 = false;
            boolean forceSwitch = it.size() > index ? (Boolean)it.get(index) : false;
            if (!response.isValid(activeBattlePokemon, showdownMoveSet, forceSwitch)) {
                this.expectingCaptureActions = originalCaptureActions;
                BattlePokemon battlePokemon = activeBattlePokemon.getBattlePokemon();
                Intrinsics.checkNotNull(battlePokemon);
                throw new IllegalActionChoiceException(this, "Invalid action choice for " + battlePokemon.getName().getString() + ": " + (ShowdownActionResponse)response);
            }
            if (response instanceof BallActionResponse) {
                int n2 = this.expectingCaptureActions;
                this.expectingCaptureActions = n2 + -1;
            }
            this.responses.add((ShowdownActionResponse)response);
        }
        if (this.expectingCaptureActions > 0) {
            throw new IllegalActionChoiceException(this, "Invalid action choice: a capture was expected. Are you hacking me?");
        }
        this.expectingCaptureActions = originalCaptureActions;
        this.mustChoose = false;
        this.getBattle().checkForInputDispatch();
    }

    public final void writeShowdownResponse() {
        List showdownMessages = new ArrayList();
        Ref.IntRef index = new Ref.IntRef();
        ShowdownActionRequest showdownActionRequest = this.request;
        Intrinsics.checkNotNull(showdownActionRequest);
        showdownActionRequest.iterate(this.activePokemon, (Function3)new Function3<ActiveBattlePokemon, ShowdownMoveset, Boolean, Integer>((List<String>)showdownMessages, this, index){
            final /* synthetic */ List<String> $showdownMessages;
            final /* synthetic */ BattleActor this$0;
            final /* synthetic */ Ref.IntRef $index;
            {
                this.$showdownMessages = $showdownMessages;
                this.this$0 = $receiver;
                this.$index = $index;
                super(3);
            }

            @NotNull
            public final Integer invoke(@NotNull ActiveBattlePokemon activeBattlePokemon, @Nullable ShowdownMoveset showdownMoveSet, boolean forceSwitch) {
                Intrinsics.checkNotNullParameter(activeBattlePokemon, "activeBattlePokemon");
                this.$showdownMessages.add(this.this$0.getResponses().get(this.$index.element).toShowdownString(activeBattlePokemon, showdownMoveSet));
                int n = this.$index.element;
                this.$index.element = n + 1;
                return n;
            }
        });
        this.responses.clear();
        this.request = null;
        this.expectingCaptureActions = 0;
        String[] stringArray = new String[]{">" + this.getShowdownId() + " " + CollectionsKt.joinToString$default(showdownMessages, null, null, null, 0, null, null, 63, null)};
        this.getBattle().writeShowdownAction(stringArray);
    }

    @NotNull
    public abstract class_5250 getName();

    @NotNull
    public abstract class_5250 nameOwned(@NotNull String var1);

    public void sendMessage(@NotNull class_2561 component) {
        Intrinsics.checkNotNullParameter(component, "component");
        class_2561[] class_2561Array = new class_2561[]{component};
        this.sendUpdate(new BattleMessagePacket(class_2561Array));
    }

    public void awardExperience(@NotNull BattlePokemon battlePokemon, int experience) {
        Intrinsics.checkNotNullParameter(battlePokemon, "battlePokemon");
    }

    public void sendUpdate(@NotNull NetworkPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
    }
}

