/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.abilities;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010,\u001a\u00020+\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b2\u00103J\u0017\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010#\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\"\u0010%\u001a\u00020$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010,\u001a\u00020+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00064"}, d2={"Lcom/cobblemon/mod/common/api/abilities/Ability;", "", "Lcom/google/gson/JsonObject;", "json", "loadFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/api/abilities/Ability;", "Lnet/minecraft/class_2487;", "nbt", "loadFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/api/abilities/Ability;", "saveToJSON", "(Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "saveToNBT", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "", "getDescription", "()Ljava/lang/String;", "description", "getDisplayName", "displayName", "", "forced", "Z", "getForced", "()Z", "setForced", "(Z)V", "", "index", "I", "getIndex", "()I", "setIndex", "(I)V", "getName", "name", "Lcom/cobblemon/mod/common/api/Priority;", "priority", "Lcom/cobblemon/mod/common/api/Priority;", "getPriority", "()Lcom/cobblemon/mod/common/api/Priority;", "setPriority", "(Lcom/cobblemon/mod/common/api/Priority;)V", "Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;", "template", "Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;", "getTemplate", "()Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;", "setTemplate", "(Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;)V", "<init>", "(Lcom/cobblemon/mod/common/api/abilities/AbilityTemplate;Z)V", "common"})
public class Ability {
    @NotNull
    private AbilityTemplate template;
    private boolean forced;
    private int index;
    @NotNull
    private Priority priority;

    public Ability(@NotNull AbilityTemplate template, boolean forced) {
        Intrinsics.checkNotNullParameter(template, "template");
        this.template = template;
        this.forced = forced;
        this.index = -1;
        this.priority = Priority.LOWEST;
    }

    @NotNull
    public final AbilityTemplate getTemplate() {
        return this.template;
    }

    public final void setTemplate(@NotNull AbilityTemplate abilityTemplate) {
        Intrinsics.checkNotNullParameter(abilityTemplate, "<set-?>");
        this.template = abilityTemplate;
    }

    public final boolean getForced() {
        return this.forced;
    }

    public final void setForced(boolean bl) {
        this.forced = bl;
    }

    @NotNull
    public final String getName() {
        return this.template.getName();
    }

    @NotNull
    public final String getDisplayName() {
        return this.template.getDisplayName();
    }

    @NotNull
    public final String getDescription() {
        return this.template.getDescription();
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @NotNull
    public final Priority getPriority() {
        return this.priority;
    }

    public final void setPriority(@NotNull Priority priority) {
        Intrinsics.checkNotNullParameter((Object)priority, "<set-?>");
        this.priority = priority;
    }

    @NotNull
    public class_2487 saveToNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        nbt.method_10582("AbilityName", this.getName());
        nbt.method_10556("AbilityForced", this.forced);
        nbt.method_10569("AbilityIndex", this.index);
        nbt.method_10582("AbilityPriority", this.priority.name());
        return nbt;
    }

    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        json.addProperty("AbilityName", this.getName());
        json.addProperty("AbilityForced", Boolean.valueOf(this.forced));
        json.addProperty("AbilityIndex", (Number)this.index);
        json.addProperty("AbilityPriority", this.priority.name());
        return json;
    }

    @NotNull
    public Ability loadFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        this.forced = nbt.method_10577("AbilityForced");
        if (nbt.method_10545("AbilityIndex") && nbt.method_10545("AbilityPriority")) {
            this.index = nbt.method_10550("AbilityIndex");
            String string = nbt.method_10558("AbilityPriority");
            Intrinsics.checkNotNullExpressionValue(string, "nbt.getString(DataKeys.POKEMON_ABILITY_PRIORITY)");
            this.priority = Priority.valueOf(string);
        }
        return this;
    }

    @NotNull
    public Ability loadFromJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        JsonElement jsonElement = json.get("AbilityForced");
        boolean bl = this.forced = jsonElement != null ? jsonElement.getAsBoolean() : false;
        if (json.has("AbilityIndex") && json.has("AbilityPriority")) {
            this.index = json.get("AbilityIndex").getAsInt();
            String string = json.get("AbilityPriority").getAsString();
            Intrinsics.checkNotNullExpressionValue(string, "json.get(DataKeys.POKEMO\u2026BILITY_PRIORITY).asString");
            this.priority = Priority.valueOf(string);
        }
        return this;
    }
}

