/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.StringJoiner;
import java.util.function.Function;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.bookshelf.impl.commands.args.HandArgument;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class CommandHand {
    public static LiteralArgumentBuilder<class_2168> build() {
        LiteralArgumentBuilder hand = class_2170.method_9247((String)"hand");
        hand.then(HandArgument.arg().executes(CommandHand::printHeldStack));
        return hand;
    }

    private static int printHeldStack(CommandContext<class_2168> context) throws CommandSyntaxException {
        OutputType type = HandArgument.get(context);
        class_1297 sender = ((class_2168)context.getSource()).method_9228();
        if (sender instanceof class_1309) {
            class_1309 living = (class_1309)sender;
            String stackOutput = type.converter.apply(living.method_6047());
            ((class_2168)context.getSource()).method_9226((class_2561)TextHelper.textWithCopy(stackOutput), false);
        }
        return 1;
    }

    public static enum OutputType {
        STRING(OutputType::getAsString),
        INGREDIENT(OutputType::getAsIngredient),
        STACK_JSON(OutputType::getAsStackJson),
        ID(OutputType::getAsID),
        TAGS(OutputType::getTags);

        private final Function<class_1799, String> converter;

        private OutputType(Function<class_1799, String> converter) {
            this.converter = converter;
        }

        private static String getAsString(class_1799 stack) {
            return stack.toString();
        }

        private static String getAsIngredient(class_1799 stack) {
            return Serializers.INGREDIENT.toJSON(class_1856.method_8101((class_1799[])new class_1799[]{stack})).toString();
        }

        private static String getAsStackJson(class_1799 stack) {
            return Serializers.ITEM_STACK.toJSON(stack).toString();
        }

        public static String getAsID(class_1799 stack) {
            class_2960 id = Services.REGISTRIES.items().getId(stack.method_7909());
            return id != null ? id.toString() : null;
        }

        public static String getTags(class_1799 stack) {
            StringJoiner joiner = new StringJoiner("\n");
            stack.method_7909().method_40131().method_40228().forEach(tag -> joiner.add(tag.comp_327().toString()));
            return joiner.toString();
        }
    }
}

