/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.api.util.MathsHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3545;
import net.minecraft.class_3959;

public final class EntityHelper {
    private static final Map<class_1299<?>, class_3545<Integer, Integer>> eggColorCache = new HashMap();

    public static double getDistanceFromEntity(class_1297 firstEntity, class_1297 secondEntity) {
        return MathsHelper.getDistanceBetweenPoints(firstEntity.method_19538(), secondEntity.method_19538());
    }

    public static double getDistaceFromPos(class_1297 entity, class_2338 pos) {
        return MathsHelper.getDistanceBetweenPoints(entity.method_19538(), class_243.method_24953((class_2382)pos));
    }

    public static void pushTowards(class_1297 entityToMove, class_2350 direction, double force) {
        EntityHelper.pushTowards(entityToMove, entityToMove.method_24515().method_10079(direction.method_10153(), 1), force);
    }

    public static void pushTowards(class_1297 entityToMove, class_2338 pos, double force) {
        double distanceZ;
        double distanceY;
        class_2338 entityPos = entityToMove.method_24515();
        double distanceX = (double)pos.method_10263() - (double)entityPos.method_10263();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)pos.method_10264() - (double)entityPos.method_10264()) * distanceY + (distanceZ = (double)pos.method_10260() - (double)entityPos.method_10260()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.method_18799(new class_243(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowards(class_1297 entityToMove, class_1297 destination, double force) {
        double distanceZ;
        double distanceY;
        double distanceX = destination.method_23317() - entityToMove.method_23317();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = destination.method_23318() - entityToMove.method_23318()) * distanceY + (distanceZ = destination.method_23321() - entityToMove.method_23321()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.method_18799(new class_243(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowardsDirection(class_1297 entityToMove, class_2350 direction, double force) {
        double distanceZ;
        double distanceY;
        class_2338 entityPos = entityToMove.method_24515();
        class_2338 destination = entityToMove.method_24515().method_10079(direction.method_10153(), 1);
        double distanceX = (double)destination.method_10263() - (double)entityPos.method_10263();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)destination.method_10264() - (double)entityPos.method_10264()) * distanceY + (distanceZ = (double)destination.method_10260() - (double)entityPos.method_10260()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.method_18799(new class_243(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static boolean areEntitiesCloseEnough(class_1297 firstEntity, class_1297 secondEntity, double maxDistance) {
        return EntityHelper.getDistanceFromEntity(firstEntity, secondEntity) < maxDistance * maxDistance;
    }

    public static <T extends class_1297> List<T> getEntitiesInArea(Class<T> entityClass, class_1937 world, class_2338 pos, int range) {
        return EntityHelper.getEntitiesInArea(entityClass, world, pos, (float)range);
    }

    public static <T extends class_1297> List<T> getEntitiesInArea(Class<T> entityClass, class_1937 world, class_2338 pos, float range) {
        return world.method_18467(entityClass, new class_238(pos.method_10080((double)(-range), (double)(-range), (double)(-range)), pos.method_10080((double)(range + 1.0f), (double)(range + 1.0f), (double)(range + 1.0f))));
    }

    public static boolean isWearingFullSet(class_1308 living, Class<class_1792> armorClass) {
        for (class_1304 slot : class_1304.values()) {
            class_1799 armor;
            if (!slot.method_5925().equals((Object)class_1304.class_1305.field_6178) || !(armor = living.method_6118(slot)).method_7960() && armor.method_7909().getClass().equals(armorClass)) continue;
            return false;
        }
        return true;
    }

    public static class_239 rayTrace(class_1309 entity, double length, class_3959.class_3960 blockMode, class_3959.class_242 fluidMode) {
        class_243 startingPosition = new class_243(entity.method_23317(), entity.method_23318() + (double)entity.method_5751(), entity.method_23321());
        class_243 lookVector = entity.method_5720();
        class_243 endingPosition = startingPosition.method_1031(lookVector.field_1352 * length, lookVector.field_1351 * length, lookVector.field_1350 * length);
        return entity.field_6002.method_17742(new class_3959(startingPosition, endingPosition, blockMode, fluidMode, (class_1297)entity));
    }

    public static boolean isAffectedByFire(class_1309 toCheck) {
        return !toCheck.method_5753() && !toCheck.method_6059(class_1294.field_5918);
    }

    public static void clearEffects(class_1309 entity, boolean removePositive, boolean removeNegative) {
        HashSet<class_1291> toClear = new HashSet<class_1291>();
        for (class_1293 class_12932 : entity.method_6026()) {
            boolean isGood = class_12932.method_5579().method_5573();
            if ((!isGood || !removePositive) && (isGood || !removeNegative)) continue;
            toClear.add(class_12932.method_5579());
        }
        for (class_1291 class_12912 : toClear) {
            entity.method_6016(class_12912);
        }
    }

    public static class_3545<Integer, Integer> getEggColors(class_1299<?> type) {
        return eggColorCache.computeIfAbsent(type, key -> {
            class_1826 item = class_1826.method_8019((class_1299)key);
            if (item != null) {
                return new class_3545((Object)item.method_8016(0), (Object)item.method_8016(1));
            }
            return new class_3545((Object)0, (Object)0);
        });
    }
}

