/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.shape;

import org.popcraft.chunky.Selection;
import org.popcraft.chunky.shape.Circle;
import org.popcraft.chunky.shape.Diamond;
import org.popcraft.chunky.shape.Ellipse;
import org.popcraft.chunky.shape.Pentagon;
import org.popcraft.chunky.shape.Rectangle;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.Square;
import org.popcraft.chunky.shape.Star;
import org.popcraft.chunky.shape.Triangle;

public final class ShapeFactory {
    private ShapeFactory() {
    }

    public static Shape getShape(Selection selection) {
        return ShapeFactory.getShape(selection, true);
    }

    public static Shape getShape(Selection selection, boolean chunkAligned) {
        return switch (selection.shape()) {
            case "circle" -> new Circle(selection, chunkAligned);
            case "diamond" -> new Diamond(selection, chunkAligned);
            case "ellipse", "oval" -> new Ellipse(selection, chunkAligned);
            case "pentagon" -> new Pentagon(selection, chunkAligned);
            case "rectangle" -> new Rectangle(selection, chunkAligned);
            case "star" -> new Star(selection, chunkAligned);
            case "triangle" -> new Triangle(selection, chunkAligned);
            default -> new Square(selection, chunkAligned);
        };
    }
}

