/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.util.math.Vec2i;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_6833;
import net.minecraft.class_6862;
import net.minecraft.class_6871;
import net.minecraft.class_6872;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public class StructureLocator {
    private static int dist(class_2338 pos1, class_2338 pos2) {
        int i = pos2.method_10263() - pos1.method_10263();
        int j = pos2.method_10260() - pos1.method_10260();
        return (int)class_3532.method_15355((float)(i * i + j * j));
    }

    @Nullable
    public static Pair<class_2338, class_6880<class_3195>> findNearestRandomMapFeature(class_3218 level, class_6862<class_3195> tagKey, class_2338 pos, int maximumChunkDistance, boolean newlyGenerated) {
        List<Pair<class_2338, class_6880<class_3195>>> found = StructureLocator.findNearestMapFeatures(level, tagKey, pos, maximumChunkDistance, newlyGenerated, 1, false);
        if (!found.isEmpty()) {
            return found.get(0);
        }
        return null;
    }

    public static List<Pair<class_2338, class_6880<class_3195>>> findNearestMapFeatures(class_3218 level, class_6862<class_3195> tagKey, class_2338 pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount) {
        return StructureLocator.findNearestMapFeatures(level, tagKey, pos, maximumChunkDistance, newlyGenerated, requiredCount, false);
    }

    public static List<Pair<class_2338, class_6880<class_3195>>> findNearestMapFeatures(class_3218 level, class_6862<class_3195> tagKey, class_2338 pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, boolean selectRandom) {
        ArrayList<Pair<class_2338, class_6880<class_3195>>> foundStructures = new ArrayList<Pair<class_2338, class_6880<class_3195>>>();
        if (!level.method_8503().method_27728().method_28057().method_28029()) {
            return foundStructures;
        }
        Optional taggedStructures = level.method_30349().method_30530(class_2378.field_25915).method_40266(tagKey);
        if (taggedStructures.isEmpty()) {
            return foundStructures;
        }
        List<Object> selectedTargets = ((class_6885.class_6888)taggedStructures.get()).method_40239().toList();
        class_2794 chunkGenerator = level.method_14178().method_12129();
        double maxDist = Double.MAX_VALUE;
        if (selectRandom) {
            class_6880 selected = (class_6880)selectedTargets.get(level.field_9229.method_43048(selectedTargets.size()));
            selectedTargets = List.of(selected);
        }
        Object2ObjectArrayMap reachableTargetsMap = new Object2ObjectArrayMap();
        for (class_6880 holder : selectedTargets) {
            for (class_6874 structureplacement : chunkGenerator.method_41055(holder, level.method_14178().method_41248())) {
                reachableTargetsMap.computeIfAbsent(structureplacement, placement -> new ObjectArraySet()).add(holder);
            }
        }
        ArrayList<Pair> list = new ArrayList<Pair>(reachableTargetsMap.size());
        int maxSpacing = 1;
        class_5138 structuremanager = level.method_27056();
        for (Map.Entry entry : reachableTargetsMap.entrySet()) {
            class_6874 placement2 = (class_6874)entry.getKey();
            if (placement2 instanceof class_6871) {
                double d1;
                class_6871 concentricringsstructureplacement = (class_6871)placement2;
                Pair foundPair = chunkGenerator.method_40148((Set)entry.getValue(), level, structuremanager, pos, newlyGenerated, concentricringsstructureplacement);
                if (foundPair == null || !((d1 = pos.method_10262((class_2382)foundPair.getFirst())) < maxDist)) continue;
                maxDist = d1;
                foundStructures.add((Pair<class_2338, class_6880<class_3195>>)foundPair);
                continue;
            }
            if (!(placement2 instanceof class_6872)) continue;
            class_6872 randomPlacement = (class_6872)placement2;
            list.add(Pair.of((Object)randomPlacement, (Object)((Set)entry.getValue())));
            maxSpacing = Math.max(maxSpacing, randomPlacement.method_41632());
        }
        if (!list.isEmpty()) {
            int chunkX = class_4076.method_18675((int)pos.method_10263());
            int n = class_4076.method_18675((int)pos.method_10260());
            long seed = level.method_8412();
            class_5138 manager = level.method_27056();
            block3: for (int k = 0; k <= maximumChunkDistance / maxSpacing; ++k) {
                int outerRing = (k + 1) * maxSpacing;
                int innerRing = k * maxSpacing;
                boolean lessPrecision = innerRing * 16 > 2000;
                TreeMap possiblePositions = new TreeMap();
                for (Pair pair : list) {
                    class_6872 placement3 = (class_6872)pair.getFirst();
                    int spacing = placement3.method_41632();
                    for (int r = innerRing; r < outerRing; r += spacing) {
                        StructureLocator.addAllPossibleFeatureChunksAtDistance(chunkX, n, r, seed, placement3, c -> {
                            List ll;
                            Vec2i v = new Vec2i(c.field_9181 - chunkX, c.field_9180 - chunkZ);
                            if (possiblePositions.containsKey(v)) {
                                boolean bl = true;
                            }
                            if ((ll = possiblePositions.computeIfAbsent(v, o -> new ArrayList())).contains(p)) {
                                boolean bl = true;
                            } else {
                                ll.add(p);
                            }
                        });
                    }
                }
                for (Map.Entry entry : possiblePositions.entrySet()) {
                    Vec2i vec2i = (Vec2i)entry.getKey();
                    class_1923 chunkPos = new class_1923(vec2i.x() + chunkX, vec2i.y() + n);
                    List structuresThatCanSpawnAtChunkPos = (List)entry.getValue();
                    for (Pair pp : structuresThatCanSpawnAtChunkPos) {
                        foundStructures.addAll(StructureLocator.getStructuresAtChunkPos((Set)pp.getSecond(), (class_4538)level, manager, newlyGenerated, (class_6872)pp.getFirst(), chunkPos));
                    }
                    if (foundStructures.size() < requiredCount) continue;
                    break block3;
                }
            }
        }
        foundStructures.sort(Comparator.comparingDouble(f -> pos.method_10262((class_2382)f.getFirst())));
        if (foundStructures.size() >= requiredCount) {
            return (List)Lists.partition(foundStructures, (int)requiredCount).get(0);
        }
        return foundStructures;
    }

    private static void addAllPossibleFeatureChunksAtDistance(int chunkX, int chunkZ, int radius, long seed, class_6872 placement, Consumer<class_1923> positionConsumer) {
        for (int j = -radius; j <= radius; ++j) {
            boolean flag = j == -radius || j == radius;
            for (int k = -radius; k <= radius; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -radius || k == radius;
                if (!flag && !flag1) continue;
                int px = chunkX + j;
                int pz = chunkZ + k;
                class_1923 chunkpos = placement.method_40169(seed, px, pz);
                positionConsumer.accept(chunkpos);
            }
        }
    }

    private static Set<Pair<class_2338, class_6880<class_3195>>> getStructuresAtChunkPos(Set<class_6880<class_3195>> targets, class_4538 level, class_5138 structureManager, boolean newChunk, class_6872 placement, class_1923 chunkpos) {
        HashSet<Pair<class_2338, class_6880<class_3195>>> foundStructures = new HashSet<Pair<class_2338, class_6880<class_3195>>>();
        for (class_6880<class_3195> holder : targets) {
            class_2791 chunkaccess;
            class_3449 structurestart;
            class_6833 structurecheckresult = structureManager.method_39783(chunkpos, (class_3195)holder.comp_349(), newChunk);
            if (structurecheckresult == class_6833.field_36240) continue;
            if (!newChunk && structurecheckresult == class_6833.field_36239) {
                foundStructures.add((Pair<class_2338, class_6880<class_3195>>)Pair.of((Object)placement.method_41636(chunkpos), holder));
            }
            if ((structurestart = structureManager.method_26975(class_4076.method_33705((class_2791)(chunkaccess = level.method_22342(chunkpos.field_9181, chunkpos.field_9180, class_2806.field_16423))), (class_3195)holder.comp_349(), (class_2810)chunkaccess)) == null || !structurestart.method_16657() || newChunk && !StructureLocator.tryAddReference(structureManager, structurestart)) continue;
            foundStructures.add((Pair<class_2338, class_6880<class_3195>>)Pair.of((Object)placement.method_41636(structurestart.method_34000()), holder));
        }
        return foundStructures;
    }

    private static boolean tryAddReference(class_5138 manager, class_3449 start) {
        if (start.method_14979()) {
            manager.method_39784(start);
            return true;
        }
        return false;
    }

    @Nullable
    private static Set<Pair<class_2338, class_6880<class_3195>>> getNearestGeneratedStructureAtDistance(Set<class_6880<class_3195>> targets, class_4538 level, class_5138 featureManager, int x, int z, int distance, boolean newChunk, long seed, class_6872 placement) {
        int i = placement.method_41632();
        for (int j = -distance; j <= distance; ++j) {
            boolean flag = j == -distance || j == distance;
            for (int k = -distance; k <= distance; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -distance || k == distance;
                if (!flag && !flag1) continue;
                int px = x + i * j;
                int pz = z + i * k;
                class_1923 chunkpos = placement.method_40169(seed, px, pz);
                return StructureLocator.getStructuresAtChunkPos(targets, level, featureManager, newChunk, placement, chunkpos);
            }
        }
        return null;
    }

    @Nullable
    public class_2338 findRandomMapFeature(class_6862<class_3195> tagKey, class_2338 pos, int radius, boolean unexplored, class_3218 level) {
        if (!level.method_8503().method_27728().method_28057().method_28029()) {
            return null;
        }
        Optional optional = level.method_30349().method_30530(class_2378.field_25915).method_40266(tagKey);
        if (optional.isEmpty()) {
            return null;
        }
        class_6885.class_6888 set = (class_6885.class_6888)optional.get();
        List list = set.method_40239().toList();
        class_6880 chosen = (class_6880)list.get(level.field_9229.method_43048(list.size()));
        Pair pair = level.method_14178().method_12129().method_12103(level, (class_6885)class_6885.method_40246((class_6880[])new class_6880[]{chosen}), pos, radius, unexplored);
        return pair != null ? (class_2338)pair.getFirst() : null;
    }
}

