/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapTrade;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ModMapMarkers;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7045;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdventurerMapsHandler
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(AdventurerMapTrade.class, (json, typeOfT, context) -> (AdventurerMapTrade)AdventurerMapTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse structure map trade: {}", e))).create();
    public static final class_3302 RELOAD_INSTANCE = new AdventurerMapsHandler();
    public static final int SEARCH_RADIUS = 150;
    private static final List<AdventurerMapTrade> CUSTOM_MAPS_TRADES = new ArrayList<AdventurerMapTrade>();
    private static final Map<class_6862<class_3195>, Pair<class_2960, Integer>> DEFAULT_STRUCTURE_MARKERS = new HashMap<class_6862<class_3195>, Pair<class_2960, Integer>>();

    public AdventurerMapsHandler() {
        super(GSON, "structure_maps");
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        CUSTOM_MAPS_TRADES.clear();
        jsons.forEach((key, json) -> {
            DataResult v = AdventurerMapTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
            AdventurerMapTrade data = (AdventurerMapTrade)v.getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse structure map trade: {}", e));
            CUSTOM_MAPS_TRADES.add(data);
        });
        if (CUSTOM_MAPS_TRADES.size() != 0) {
            Supplementaries.LOGGER.info("Loaded  " + CUSTOM_MAPS_TRADES.size() + " structure maps trades");
        }
    }

    private static void associateStructureMarker(class_6862<class_3195> tag, class_2960 res, int color) {
        DEFAULT_STRUCTURE_MARKERS.put(tag, (Pair<class_2960, Integer>)Pair.of((Object)res, (Object)color));
    }

    private static Pair<class_2960, Integer> getStructureMarker(class_6880<class_3195> structure) {
        class_2960 res = ((class_5321)structure.method_40230().get()).method_29177();
        int color = 0;
        for (Map.Entry<class_6862<class_3195>, Pair<class_2960, Integer>> v : DEFAULT_STRUCTURE_MARKERS.entrySet()) {
            if (!structure.method_40220(v.getKey())) continue;
            res = (class_2960)v.getValue().getFirst();
            color = (Integer)v.getValue().getSecond();
            break;
        }
        return Pair.of((Object)res, (Object)color);
    }

    public static void addTradesCallback() {
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)1, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 1));
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)2, itemListings -> {
            if (CommonConfigs.Tweaks.RANDOM_ADVENTURER_MAPS.get().booleanValue()) {
                itemListings.add(new RandomAdventureMapTrade());
            }
            AdventurerMapsHandler.maybeAddCustomMap(itemListings, 2);
        });
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)3, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 3));
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)4, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 4));
        RegHelper.registerVillagerTrades((class_3852)class_3852.field_17054, (int)5, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 5));
    }

    private static void maybeAddCustomMap(List<class_3853.class_1652> listings, int level) {
        for (AdventurerMapTrade data : CUSTOM_MAPS_TRADES) {
            if (level != data.villagerLevel()) continue;
            listings.add(data);
        }
    }

    private static class_1799 createMapOrQuill(class_2338 pos, class_3218 serverLevel, @Nullable class_6862<class_3195> tag, int zoom, @Nullable class_2960 mapMarker, @Nullable String name, int color) {
        if (CompatHandler.QUARK && CommonConfigs.Tweaks.QUARK_QUILL.get().booleanValue()) {
            class_1799 item = QuarkCompat.makeAdventurerQuill(serverLevel, tag, 150, true, zoom, null, name, color);
            item.method_7977((class_2561)class_2561.method_43471((String)name));
            return item;
        }
        if (!serverLevel.method_8503().method_27728().method_28057().method_28029()) {
            return class_1799.field_8037;
        }
        Pair<class_2338, class_6880<class_3195>> found = StructureLocator.findNearestRandomMapFeature(serverLevel, tag, pos, 150, true);
        if (found != null) {
            class_2338 toPos = (class_2338)found.getFirst();
            return AdventurerMapsHandler.createStructureMap(serverLevel, toPos, (class_6880<class_3195>)((class_6880)found.getSecond()), zoom, mapMarker, name, color);
        }
        return class_1799.field_8037;
    }

    @NotNull
    public static class_1799 createStructureMap(class_3218 level, class_2338 pos, class_6880<class_3195> structure, int zoom, @Nullable class_2960 decoration, @Nullable String name, int color) {
        class_1799 stack = class_1806.method_8005((class_1937)level, (int)pos.method_10263(), (int)pos.method_10260(), (byte)((byte)zoom), (boolean)true, (boolean)true);
        class_1806.method_8002((class_3218)level, (class_1799)stack);
        if (decoration == null) {
            Pair<class_2960, Integer> s = AdventurerMapsHandler.getStructureMarker(structure);
            decoration = (class_2960)s.getFirst();
            if (color == 0) {
                color = (Integer)s.getSecond();
            }
        }
        MapHelper.addDecorationToMap((class_1799)stack, (class_2338)pos, (class_2960)decoration, (int)color);
        if (name != null) {
            stack.method_7977((class_2561)class_2561.method_43471((String)name));
        }
        return stack;
    }

    public static class_1799 createCustomMap(class_1937 world, class_2338 pos, class_2960 structureName, @Nullable String mapName, int mapColor, @Nullable class_2960 mapMarker) {
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            class_6862 destination = class_6862.method_40092((class_5321)class_2378.field_25915, (class_2960)structureName);
            String name = mapName == null ? "filled_map." + structureName.method_12832().toLowerCase(Locale.ROOT) : mapName;
            return AdventurerMapsHandler.createMapOrQuill(pos, serverLevel, (class_6862<class_3195>)destination, 2, mapMarker, name, mapColor);
        }
        return class_1799.field_8037;
    }

    static {
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37047, ModMapMarkers.SHIPWRECK_TYPE, 3416079);
        AdventurerMapsHandler.associateStructureMarker(ModTags.ANCIENT_CITY, ModMapMarkers.ANCIENT_CITY_TYPE, 407920);
        AdventurerMapsHandler.associateStructureMarker(ModTags.IGLOO, ModMapMarkers.IGLOO_TYPE, 10075586);
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37048, ModMapMarkers.RUINED_PORTAL_TYPE, 6238389);
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37045, ModMapMarkers.VILLAGE_TYPE, 12224341);
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37049, ModMapMarkers.OCEAN_RUIN_TYPE, 3828045);
        AdventurerMapsHandler.associateStructureMarker(ModTags.PILLAGER_OUTPOST, ModMapMarkers.PILLAGER_OUTPOST_TYPE, 0x1F1100);
        AdventurerMapsHandler.associateStructureMarker(ModTags.DESERT_PYRAMID, ModMapMarkers.DESERT_PYRAMID_TYPE, 8416575);
        AdventurerMapsHandler.associateStructureMarker(ModTags.JUNGLE_TEMPLE, ModMapMarkers.JUNGLE_TEMPLE_TYPE, 5400120);
        AdventurerMapsHandler.associateStructureMarker(ModTags.BASTION_REMNANT, ModMapMarkers.BASTION_TYPE, 2894127);
        AdventurerMapsHandler.associateStructureMarker(ModTags.END_CITY, ModMapMarkers.END_CITY_TYPE, 10253227);
        AdventurerMapsHandler.associateStructureMarker(ModTags.SWAMP_HUT, ModMapMarkers.SWAMP_HUT_TYPE, 1786143);
        AdventurerMapsHandler.associateStructureMarker(ModTags.NETHER_FORTRESS, ModMapMarkers.NETHER_FORTRESS, 3934219);
        AdventurerMapsHandler.associateStructureMarker((class_6862<class_3195>)class_7045.field_37046, ModMapMarkers.MINESHAFT_TYPE, 0x808080);
    }

    private static class RandomAdventureMapTrade
    implements class_3853.class_1652 {
        private RandomAdventureMapTrade() {
        }

        public class_1914 method_7246(@NotNull class_1297 entity, @NotNull class_5819 random) {
            int maxPrice = 11;
            int minPrice = 6;
            int price = random.method_43048(maxPrice - minPrice + 1) + minPrice;
            class_1799 itemstack = this.createMap(entity.field_6002, entity.method_24515());
            if (itemstack.method_7960()) {
                return null;
            }
            int uses = CommonConfigs.Tweaks.QUILL_MAX_TRADES.get();
            int x = 6;
            int xp = (int)((float)(x * 12) / (float)uses);
            int cost = (int)((double)price * CommonConfigs.Tweaks.QUILL_TRADE_PRICE_MULT.get());
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, cost), new class_1799((class_1935)class_1802.field_8251), itemstack, uses, xp, 0.2f);
        }

        private class_1799 createMap(class_1937 level, class_2338 pos) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                return AdventurerMapsHandler.createMapOrQuill(pos, serverLevel, null, 2, null, "filled_map.adventure", 7869722);
            }
            return class_1799.field_8037;
        }
    }
}

