/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6880;

public class BlockGeneratorBlockTile
extends class_2586 {
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();
    private final AtomicReference<List<Pair<class_2338, class_6880<class_3195>>>> threadResult = new AtomicReference<Object>(null);
    private boolean firstTick = true;

    public BlockGeneratorBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.BLOCK_GENERATOR_TILE.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, BlockGeneratorBlockTile tile) {
        if (tile.firstTick) {
            tile.firstTick = false;
            class_3218 world = (class_3218)level;
            EXECUTORS.submit(() -> {
                try {
                    tile.threadResult.set(StructureLocator.findNearestMapFeatures(world, ModTags.WAY_SIGN_DESTINATIONS, pos, 250, false, 2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        try {
            List<Pair<class_2338, class_6880<class_3195>>> result = tile.threadResult.get();
            if (result != null) {
                RoadSignFeature.applyPostProcess((class_3218)level, pos, result);
            }
        }
        catch (Exception exception) {
            tile.failAndRemove(level, pos, exception);
        }
    }

    private void failAndRemove(class_1937 level, class_2338 pos, Exception e) {
        level.method_8650(pos, false);
        Supplementaries.LOGGER.warn("failed to generate road sign at " + pos + ": " + e);
    }
}

