/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.DecoBlocksCompat;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3709;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3867;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_4770;
import net.minecraft.class_4970;
import net.minecraft.class_5556;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class RopeBlock
extends WaterBlock
implements IRopeConnection {
    public static final class_265 COLLISION_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    private static Map<class_2680, class_265> SHAPES_MAP;
    public static final class_2746 NORTH;
    public static final class_2746 SOUTH;
    public static final class_2746 WEST;
    public static final class_2746 EAST;
    public static final class_2746 UP;
    public static final class_2746 DOWN;
    public static final class_2758 DISTANCE;
    public static final class_2746 KNOT;
    public static final Map<class_2350, class_2746> FACING_TO_PROPERTY_MAP;

    public RopeBlock(class_4970.class_2251 properties) {
        super(properties);
        SHAPES_MAP = this.makeShapes();
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)KNOT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(7))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public boolean method_22358(class_2680 state, class_3611 fluid) {
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return SHAPES_MAP.getOrDefault(((class_2680)state.method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), class_259.method_1077());
    }

    protected Map<class_2680, class_265> makeShapes() {
        HashMap<class_2680, class_265> shapes = new HashMap<class_2680, class_265>();
        class_265 down = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 up = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        class_265 north = class_2248.method_9541((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 south = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        class_265 west = class_2248.method_9541((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        class_265 east = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        class_265 knot = class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        for (class_2680 state : this.field_10647.method_11662()) {
            if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() || (Integer)state.method_11654((class_2769)DISTANCE) != 0) continue;
            class_265 v = class_259.method_1073();
            if (((Boolean)state.method_11654((class_2769)KNOT)).booleanValue()) {
                v = class_259.method_17786((class_265)knot, (class_265[])new class_265[0]);
            }
            if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)down);
            }
            if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)up);
            }
            if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)north);
            }
            if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)south);
            }
            if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)west);
            }
            if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
                v = class_259.method_1084((class_265)v, (class_265)east);
            }
            v = v.method_1097();
            boolean flag = true;
            for (class_265 existing : shapes.values()) {
                if (!existing.equals(v)) continue;
                shapes.put(state, existing);
                flag = false;
                break;
            }
            if (!flag) continue;
            shapes.put(state, v);
        }
        return ImmutableMap.copyOf(shapes);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, WATERLOGGED, DISTANCE, KNOT});
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        class_3727 ec;
        return (Boolean)state.method_11654((class_2769)UP) == false && (context.method_16192(COLLISION_SHAPE, pos, true) || (Boolean)state.method_11654((class_2769)DOWN) == false) || !(context instanceof class_3727) || !((ec = (class_3727)context).method_32480() instanceof class_1309) ? this.method_9530(state, worldIn, pos, context) : class_259.method_1073();
    }

    public boolean shouldConnectToDir(class_2680 thisState, class_2338 currentPos, class_4538 world, class_2350 dir) {
        class_2338 facingPos = currentPos.method_10093(dir);
        return this.shouldConnectToFace(thisState, world.method_8320(facingPos), facingPos, dir, world);
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!worldIn.method_8608()) {
            worldIn.method_39279(currentPos, (class_2248)this, 1);
        }
        if (facing == class_2350.field_11036) {
            stateIn = (class_2680)stateIn.method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(this.shouldConnectToDir(stateIn, currentPos, (class_4538)worldIn, class_2350.field_11033)));
        }
        stateIn = (class_2680)stateIn.method_11657((class_2769)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.shouldConnectToDir(stateIn, currentPos, (class_4538)worldIn, facing)));
        if (facing == class_2350.field_11033 && !worldIn.method_8608() && CompatHandler.DECO_BLOCKS) {
            DecoBlocksCompat.tryConvertingRopeChandelier(facingState, worldIn, facingPos);
        }
        return (class_2680)stateIn.method_11657((class_2769)KNOT, (Comparable)Boolean.valueOf(RopeBlock.hasMiddleKnot(stateIn)));
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        boolean hasWater = context.method_8045().method_8316(pos).method_15772() == class_3612.field_15910;
        class_2680 state = this.method_9564();
        for (class_2350 dir : class_2350.values()) {
            state = (class_2680)state.method_11657((class_2769)FACING_TO_PROPERTY_MAP.get(dir), (Comparable)Boolean.valueOf(this.shouldConnectToDir(state, pos, (class_4538)world, dir)));
        }
        state = (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(hasWater));
        state = (class_2680)((class_2680)state.method_11657((class_2769)KNOT, (Comparable)Boolean.valueOf(RopeBlock.hasMiddleKnot(state)))).method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(this.getDistance((class_4538)world, pos)));
        return state;
    }

    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (!worldIn.field_9236) {
            worldIn.method_39279(pos, (class_2248)this, 1);
            if (CompatHandler.DECO_BLOCKS) {
                class_2338 down = pos.method_10074();
                DecoBlocksCompat.tryConvertingRopeChandelier(worldIn.method_8320(down), (class_1936)worldIn, down);
            }
        }
    }

    public static boolean hasMiddleKnot(class_2680 state) {
        boolean up = (Boolean)state.method_11654((class_2769)UP);
        boolean down = (Boolean)state.method_11654((class_2769)DOWN);
        boolean north = (Boolean)state.method_11654((class_2769)NORTH);
        boolean east = (Boolean)state.method_11654((class_2769)EAST);
        boolean south = (Boolean)state.method_11654((class_2769)SOUTH);
        boolean west = (Boolean)state.method_11654((class_2769)WEST);
        return !(up && down && !north && !south && !east && !west || !up && !down && north && south && !east && !west || !up && !down && !north && !south && east && west);
    }

    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        return this.getDistance(worldIn, pos) < 7;
    }

    protected int getDistance(class_4538 world, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503().method_10098(class_2350.field_11036);
        class_2680 blockstate = world.method_8320((class_2338)mutable);
        int i = 7;
        if (blockstate.method_27852((class_2248)this)) {
            if (((Boolean)blockstate.method_11654((class_2769)DOWN)).booleanValue() || !((Boolean)blockstate.method_11654((class_2769)UP)).booleanValue()) {
                i = (Integer)blockstate.method_11654((class_2769)DISTANCE);
            }
        } else if (IRopeConnection.isSupportingCeiling((class_2338)mutable, world)) {
            return 0;
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338.class_2339 facingPos = mutable.method_25505((class_2382)pos, direction);
            class_2680 sideState = world.method_8320((class_2338)facingPos);
            class_2248 b = sideState.method_26204();
            if (b instanceof RopeBlock) {
                if ((i = Math.min(i, (Integer)sideState.method_11654((class_2769)DISTANCE) + 1)) != 1) continue;
                break;
            }
            if (!this.shouldConnectToFace(this.method_9564(), sideState, (class_2338)facingPos, direction, world)) continue;
            i = 0;
        }
        return i;
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 rand) {
        int i = this.getDistance((class_4538)level, pos);
        class_2680 blockstate = (class_2680)state.method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(i));
        if (i == 7) {
            level.method_22352(pos, true);
            return;
        }
        if (state != blockstate) {
            level.method_8652(pos, blockstate, 3);
        }
        for (class_2350 dir : class_2350.values()) {
            if (dir == class_2350.field_11036 || !level.method_8320(pos.method_10093(dir)).method_26164(class_3481.field_21952)) continue;
            level.method_39279(pos.method_10093(dir), class_2246.field_10036, 2 + level.field_9229.method_43048(1));
            for (class_2350 d2 : class_2350.class_2353.field_11062) {
                class_2338 fp = pos.method_10093(d2);
                if (!class_4770.method_30032((class_1937)level, (class_2338)fp, (class_2350)d2.method_10153())) continue;
                level.method_8501(fp, (class_2680)class_4770.method_24416((class_1922)level, (class_2338)fp).method_11657((class_2769)class_2358.field_11092, (Comparable)Integer.valueOf(14)));
                level.method_39279(pos.method_10093(dir), class_2246.field_10036, 2 + level.field_9229.method_43048(1));
            }
            return;
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        return super.method_9560(state, builder);
    }

    public static boolean findAndRingBell(class_1937 world, class_2338 pos, class_1657 player, int it, Predicate<class_2680> predicate) {
        if (it > CommonConfigs.Tweaks.BELL_CHAIN_LENGTH.get()) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        class_2248 b = state.method_26204();
        if (predicate.test(state)) {
            return RopeBlock.findAndRingBell(world, pos.method_10084(), player, it + 1, predicate);
        }
        if (b instanceof class_3709) {
            class_3709 bellBlock = (class_3709)b;
            if (it != 0) {
                class_2350 d = (class_2350)state.method_11654((class_2769)class_3709.field_16324);
                class_3867 att = (class_3867)state.method_11654((class_2769)class_3709.field_16326);
                if (att == class_3867.field_17100 || att == class_3867.field_17101 || !Utils.getID((class_2248)b).method_12836().equals("create")) {
                    d = d.method_10170();
                }
                class_3965 hit = new class_3965(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5), d, pos, true);
                return bellBlock.method_19285(world, state, hit, player, true);
            }
        }
        return false;
    }

    private static boolean findConnectedPulley(class_1937 world, class_2338 pos, class_1657 player, int it, class_2470 rot) {
        if (it > 64) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        class_2248 b = state.method_26204();
        if (b instanceof RopeBlock) {
            return RopeBlock.findConnectedPulley(world, pos.method_10084(), player, it + 1, rot);
        }
        if (b instanceof PulleyBlock) {
            class_2586 class_25862;
            PulleyBlock pulley = (PulleyBlock)b;
            if (it != 0 && (class_25862 = world.method_8321(pos)) instanceof PulleyBlockTile) {
                PulleyBlockTile tile = (PulleyBlockTile)class_25862;
                if (tile.method_5442() && !player.method_5715()) {
                    tile.setDisplayedItem(new class_1799((class_1935)ModRegistry.ROPE.get()));
                    boolean ret = pulley.windPulley(state, pos, (class_1936)world, rot, null);
                    tile.getDisplayedItem().method_7934(1);
                    return ret;
                }
                return pulley.windPulley(state, pos, (class_1936)world, rot, null);
            }
        }
        return false;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        class_1799 stack = player.method_5998(handIn);
        class_1792 i = stack.method_7909();
        if (i == this.method_8389()) {
            if (hit.method_17780().method_10166() == class_2350.class_2351.field_11052 || ((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
                if (((Boolean)state.method_11654((class_2769)UP)).booleanValue() && !((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
                    state = (class_2680)state.method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(true));
                    world.method_8652(pos, state, 0);
                }
                if (RopeBlock.addRope(pos.method_10074(), world, player, handIn, (class_2248)this)) {
                    class_2498 soundtype = state.method_26231();
                    world.method_8396(player, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    return class_1269.method_29236((boolean)world.field_9236);
                }
            }
            return class_1269.field_5811;
        }
        if (stack.method_7960()) {
            if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
                if (CommonConfigs.Tweaks.BELL_CHAIN.get().booleanValue() && RopeBlock.findAndRingBell(world, pos, player, 0, s -> s.method_26204() == this)) {
                    return class_1269.method_29236((boolean)world.field_9236);
                }
                if (RopeBlock.findConnectedPulley(world, pos, player, 0, player.method_5715() ? class_2470.field_11465 : class_2470.field_11463)) {
                    return class_1269.method_29236((boolean)world.field_9236);
                }
            }
            if (!player.method_5715() && handIn == class_1268.field_5808 && world.method_8320(pos.method_10074()).method_26204() == this && RopeBlock.removeRope(pos.method_10074(), world, (class_2248)this)) {
                world.method_8396(player, pos, class_3417.field_15062, class_3419.field_15245, 1.0f, 0.6f);
                if (!player.method_31549().field_7477) {
                    ItemsUtil.addStackToExisting(player, new class_1799((class_1935)this), true);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
        } else if (i instanceof class_1820) {
            if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
                if (!world.field_9236) {
                    world.method_8396(null, pos, class_3417.field_22273, player == null ? class_3419.field_15245 : class_3419.field_15248, 0.8f, 1.3f);
                    class_2680 newState = (class_2680)((class_2680)state.method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)KNOT, (Comparable)Boolean.valueOf(true));
                    world.method_8652(pos, newState, 3);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public static boolean removeRope(class_2338 pos, class_1937 world, class_2248 ropeBlock) {
        class_2680 state = world.method_8320(pos);
        if (ropeBlock == state.method_26204()) {
            return RopeBlock.removeRope(pos.method_10074(), world, ropeBlock);
        }
        class_2338 up = pos.method_10084();
        if (world.method_8320(up).method_26204() != ropeBlock) {
            return false;
        }
        class_3610 fromFluid = world.method_8316(up);
        boolean water = fromFluid.method_15772() == class_3612.field_15910 && fromFluid.method_15771();
        world.method_8501(up, water ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564());
        RopeBlock.tryMove(pos, up, world);
        return true;
    }

    public static boolean addRope(class_2338 pos, class_1937 world, @Nullable class_1657 player, class_1268 hand, class_2248 ropeBlock) {
        class_2680 state = world.method_8320(pos);
        if (ropeBlock == state.method_26204()) {
            return RopeBlock.addRope(pos.method_10074(), world, player, hand, ropeBlock);
        }
        return RopeBlock.tryPlaceAndMove(player, hand, world, pos, ropeBlock);
    }

    public static boolean tryPlaceAndMove(@Nullable class_1657 player, class_1268 hand, class_1937 world, class_2338 pos, class_2248 ropeBlock) {
        class_2680 state;
        class_1799 stack = new class_1799((class_1935)ropeBlock);
        class_1750 context = new class_1750(world, player, hand, stack, new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11036, pos, false));
        if (!context.method_7716()) {
            class_2338 downPos = pos.method_10074();
            if (!world.method_8320(downPos).method_26207().method_15800() || !RopeBlock.tryMove(pos, downPos, world)) {
                return false;
            }
            context = new class_1750(world, player, hand, stack, new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11036, pos, false));
        }
        if ((state = ItemsUtil.getPlacementState(context, ropeBlock)) == null) {
            return false;
        }
        if (state == world.method_8320(context.method_8037())) {
            return false;
        }
        if (world.method_8652(context.method_8037(), state, 11)) {
            class_2680 placedState;
            class_2248 block;
            if (player != null && (block = (placedState = world.method_8320(context.method_8037())).method_26204()) == state.method_26204()) {
                block.method_9567(world, context.method_8037(), placedState, (class_1309)player, stack);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_1191.method_9087(serverPlayer, context.method_8037(), stack);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isBlockMovable(class_2680 state, class_1937 level, class_2338 pos) {
        return !state.method_26215() && !state.method_27852(class_2246.field_10540) && !state.method_27852(class_2246.field_10260) && !state.method_27852(class_2246.field_22423) && !state.method_27852(class_2246.field_23152) && state.method_26214((class_1922)level, pos) != -1.0f;
    }

    private static boolean tryMove(class_2338 fromPos, class_2338 toPos, class_1937 world) {
        if (toPos.method_10264() < world.method_31607() || toPos.method_10264() > world.method_31600()) {
            return false;
        }
        class_2680 state = world.method_8320(fromPos);
        class_3619 push = state.method_26223();
        if (RopeBlock.isBlockMovable(state, world, fromPos) && ((push == class_3619.field_15974 || toPos.method_10264() < fromPos.method_10264() && push == class_3619.field_15970) && state.method_26184((class_4538)world, toPos) || state.method_26164(ModTags.ROPE_HANG_TAG))) {
            class_3610 fromFluid;
            class_3611 fluidState;
            class_2586 tile = world.method_8321(fromPos);
            if (tile != null) {
                if (CompatHandler.QUARK && !QuarkCompat.canMoveBlockEntity(state)) {
                    return false;
                }
                tile.method_11012();
            }
            boolean waterFluid = (fluidState = world.method_8316(toPos).method_15772()) == class_3612.field_15910;
            boolean canHoldWater = false;
            if (state.method_28498((class_2769)WATERLOGGED)) {
                canHoldWater = state.method_26164(ModTags.WATER_HOLDER);
                if (!canHoldWater) {
                    state = (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterFluid));
                }
            } else if (state.method_26204() instanceof class_2275) {
                if (waterFluid && state.method_27852(class_2246.field_10593) || state.method_27852(class_2246.field_27097)) {
                    state = (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(3));
                }
                if (fluidState == class_3612.field_15908 && state.method_27852(class_2246.field_10593) || state.method_27852(class_2246.field_27098)) {
                    state = (class_2680)class_2246.field_27098.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(3));
                }
            }
            boolean leaveWater = (fromFluid = world.method_8316(fromPos)).method_15772() == class_3612.field_15910 && fromFluid.method_15771() && !canHoldWater;
            world.method_8501(fromPos, leaveWater ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564());
            class_2680 newState = class_2248.method_9510((class_2680)state, (class_1936)world, (class_2338)toPos);
            world.method_8501(toPos, newState);
            if (tile != null) {
                class_2487 tag = tile.method_38244();
                class_2586 te = world.method_8321(toPos);
                if (te != null) {
                    te.method_11014(tag);
                }
            }
            world.method_8492(toPos, state.method_26204(), toPos);
            return true;
        }
        return false;
    }

    public void method_9548(class_2680 state, class_1937 worldIn, class_2338 pos, class_1297 entityIn) {
        super.method_9548(state, worldIn, pos, entityIn);
        if (entityIn instanceof class_1667 && !worldIn.field_9236) {
            worldIn.method_8651(pos, true, entityIn);
            worldIn.method_8396(null, pos, class_3417.field_15184, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public boolean method_9522(class_2680 pState, class_2680 pAdjacentBlockState, class_2350 pSide) {
        return pAdjacentBlockState.method_27852((class_2248)this) || super.method_9522(pState, pAdjacentBlockState, pSide);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            default -> state;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            default -> super.method_9569(state, mirror);
        };
    }

    @Override
    public boolean canSideAcceptConnection(class_2680 state, class_2350 direction) {
        return true;
    }

    public static boolean playEntitySlideSound(class_1309 entity, int ropeTicks) {
        if (ropeTicks % 14 == 0) {
            if (!entity.method_5701()) {
                class_1657 pl;
                class_1657 p = entity instanceof class_1657 ? (pl = (class_1657)entity) : null;
                entity.field_6002.method_43128(p, entity.method_23317(), entity.method_23318(), entity.method_23321(), ModSounds.ROPE_SLIDE.get(), entity.method_5634(), 0.1f, 1.0f);
            }
            return true;
        }
        return false;
    }

    static {
        NORTH = class_2741.field_12489;
        SOUTH = class_2741.field_12540;
        WEST = class_2741.field_12527;
        EAST = class_2741.field_12487;
        UP = class_2741.field_12519;
        DOWN = class_2741.field_12546;
        DISTANCE = class_2741.field_16503;
        KNOT = ModBlockProperties.KNOT;
        FACING_TO_PROPERTY_MAP = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), directions -> {
            directions.put(class_2350.field_11043, NORTH);
            directions.put(class_2350.field_11034, EAST);
            directions.put(class_2350.field_11035, SOUTH);
            directions.put(class_2350.field_11039, WEST);
            directions.put(class_2350.field_11036, UP);
            directions.put(class_2350.field_11033, DOWN);
        });
    }
}

