/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpBlock;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.GunpowderExplosion;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.DecoBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2413;
import net.minecraft.class_2415;
import net.minecraft.class_2459;
import net.minecraft.class_2470;
import net.minecraft.class_2527;
import net.minecraft.class_2530;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2773;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5540;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class GunpowderBlock
extends LightUpBlock {
    public static final class_2754<class_2773> NORTH = class_2741.field_12495;
    public static final class_2754<class_2773> EAST = class_2741.field_12523;
    public static final class_2754<class_2773> SOUTH = class_2741.field_12551;
    public static final class_2754<class_2773> WEST = class_2741.field_12504;
    public static final class_2758 BURNING = ModBlockProperties.BURNING;
    public static final Map<class_2350, class_2754<class_2773>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, NORTH, (Object)class_2350.field_11034, EAST, (Object)class_2350.field_11035, SOUTH, (Object)class_2350.field_11039, WEST));
    private static final class_265 SHAPE_DOT = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<class_2350, class_265> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<class_2350, class_265> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_259.method_1084((class_265)SHAPES_FLOOR.get(class_2350.field_11043), (class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)class_2350.field_11035, (Object)class_259.method_1084((class_265)SHAPES_FLOOR.get(class_2350.field_11035), (class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)class_2350.field_11034, (Object)class_259.method_1084((class_265)SHAPES_FLOOR.get(class_2350.field_11034), (class_265)class_2248.method_9541((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)class_2350.field_11039, (Object)class_259.method_1084((class_265)SHAPES_FLOOR.get(class_2350.field_11039), (class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<class_2680, class_265> SHAPES_CACHE;
    private final class_2680 crossState;

    private static int getDelay() {
        return CommonConfigs.Tweaks.GUNPOWDER_BURN_SPEED.get();
    }

    private static int getSpreadAge() {
        return CommonConfigs.Tweaks.GUNPOWDER_SPREAD_AGE.get();
    }

    public GunpowderBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(NORTH, (Comparable)class_2773.field_12687)).method_11657(EAST, (Comparable)class_2773.field_12687)).method_11657(SOUTH, (Comparable)class_2773.field_12687)).method_11657(WEST, (Comparable)class_2773.field_12687)).method_11657((class_2769)BURNING, (Comparable)Integer.valueOf(0)));
        this.crossState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(NORTH, (Comparable)class_2773.field_12689)).method_11657(EAST, (Comparable)class_2773.field_12689)).method_11657(SOUTH, (Comparable)class_2773.field_12689)).method_11657(WEST, (Comparable)class_2773.field_12689)).method_11657((class_2769)BURNING, (Comparable)Integer.valueOf(0));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (class_2680 blockstate : this.method_9595().method_11662()) {
            if ((Integer)blockstate.method_11654((class_2769)BURNING) != 0) continue;
            builder.put((Object)blockstate, (Object)this.calculateVoxelShape(blockstate));
        }
        this.SHAPES_CACHE = builder.build();
        RegHelper.registerBlockFlammability((class_2248)this, (int)60, (int)300);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, BURNING});
    }

    private class_265 calculateVoxelShape(class_2680 state) {
        class_265 voxelshape = SHAPE_DOT;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2773 redstoneside = (class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == class_2773.field_12689) {
                voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneside != class_2773.field_12686) continue;
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)SHAPES_UP.get(direction));
        }
        return voxelshape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.SHAPES_CACHE.get(state.method_11657((class_2769)BURNING, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        return this.getConnectionState((class_1922)context.method_8045(), this.crossState, context.method_8037());
    }

    @Override
    public boolean method_22358(class_2680 state, class_3611 fluid) {
        return this.field_23158.method_15800() || !this.field_23158.method_15799();
    }

    private class_2680 getConnectionState(class_1922 world, class_2680 state, class_2338 pos) {
        boolean flag = GunpowderBlock.isDot(state);
        state = this.getMissingConnections(world, (class_2680)this.method_9564().method_11657((class_2769)BURNING, (Comparable)((Integer)state.method_11654((class_2769)BURNING))), pos);
        if (!flag || !GunpowderBlock.isDot(state)) {
            boolean flag6;
            boolean flag1 = ((class_2773)state.method_11654(NORTH)).method_27855();
            boolean flag2 = ((class_2773)state.method_11654(SOUTH)).method_27855();
            boolean flag3 = ((class_2773)state.method_11654(EAST)).method_27855();
            boolean flag4 = ((class_2773)state.method_11654(WEST)).method_27855();
            boolean flag5 = !flag1 && !flag2;
            boolean bl = flag6 = !flag3 && !flag4;
            if (!flag4 && flag5) {
                state = (class_2680)state.method_11657(WEST, (Comparable)class_2773.field_12689);
            }
            if (!flag3 && flag5) {
                state = (class_2680)state.method_11657(EAST, (Comparable)class_2773.field_12689);
            }
            if (!flag1 && flag6) {
                state = (class_2680)state.method_11657(NORTH, (Comparable)class_2773.field_12689);
            }
            if (!flag2 && flag6) {
                state = (class_2680)state.method_11657(SOUTH, (Comparable)class_2773.field_12689);
            }
        }
        return state;
    }

    private class_2680 getMissingConnections(class_1922 world, class_2680 state, class_2338 pos) {
        boolean flag = !world.method_8320(pos.method_10084()).method_26212(world, pos);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (((class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).method_27855()) continue;
            class_2773 redstoneside = this.getConnectingSide(world, pos, direction, flag);
            state = (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside);
        }
        return state;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 otherState, class_1936 world, class_2338 pos, class_2338 otherPos) {
        class_2773 redstoneside;
        class_2680 newState = direction == class_2350.field_11033 ? (this.method_9558(state, (class_4538)world, pos) ? state : class_2246.field_10124.method_9564()) : (direction == class_2350.field_11036 ? this.getConnectionState((class_1922)world, state, pos) : ((redstoneside = this.getConnectingSide((class_1922)world, pos, direction)).method_27855() == ((class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).method_27855() && !GunpowderBlock.isCross(state) ? (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside) : this.getConnectionState((class_1922)world, (class_2680)((class_2680)this.crossState.method_11657((class_2769)BURNING, (Comparable)((Integer)state.method_11654((class_2769)BURNING)))).method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside), pos)));
        return newState;
    }

    private static boolean isCross(class_2680 state) {
        return ((class_2773)state.method_11654(NORTH)).method_27855() && ((class_2773)state.method_11654(SOUTH)).method_27855() && ((class_2773)state.method_11654(EAST)).method_27855() && ((class_2773)state.method_11654(WEST)).method_27855();
    }

    private static boolean isDot(class_2680 state) {
        return !((class_2773)state.method_11654(NORTH)).method_27855() && !((class_2773)state.method_11654(SOUTH)).method_27855() && !((class_2773)state.method_11654(EAST)).method_27855() && !((class_2773)state.method_11654(WEST)).method_27855();
    }

    public void method_9517(class_2680 state, class_1936 world, class_2338 pos, int var1, int var2) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2773 redstoneside = (class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == class_2773.field_12687 || world.method_8320((class_2338)mutable.method_25505((class_2382)pos, direction)).method_27852((class_2248)this)) continue;
            mutable.method_10098(class_2350.field_11033);
            class_2680 blockstate = world.method_8320((class_2338)mutable);
            if (!blockstate.method_27852(class_2246.field_10282)) {
                class_2338 blockpos = mutable.method_10093(direction.method_10153());
                class_2680 blockstate1 = blockstate.method_26191(direction.method_10153(), world.method_8320(blockpos), world, (class_2338)mutable, blockpos);
                GunpowderBlock.method_9611((class_2680)blockstate, (class_2680)blockstate1, (class_1936)world, (class_2338)mutable, (int)var1, (int)var2);
            }
            mutable.method_25505((class_2382)pos, direction).method_10098(class_2350.field_11036);
            class_2680 blockstate3 = world.method_8320((class_2338)mutable);
            if (blockstate3.method_27852(class_2246.field_10282)) continue;
            class_2338 pos1 = mutable.method_10093(direction.method_10153());
            class_2680 blockstate2 = blockstate3.method_26191(direction.method_10153(), world.method_8320(pos1), world, (class_2338)mutable, pos1);
            GunpowderBlock.method_9611((class_2680)blockstate3, (class_2680)blockstate2, (class_1936)world, (class_2338)mutable, (int)var1, (int)var2);
        }
    }

    private class_2773 getConnectingSide(class_1922 world, class_2338 pos, class_2350 dir) {
        return this.getConnectingSide(world, pos, dir, !world.method_8320(pos.method_10084()).method_26212(world, pos));
    }

    private class_2773 getConnectingSide(class_1922 world, class_2338 pos, class_2350 dir, boolean canClimbUp) {
        boolean flag;
        class_2338 blockpos = pos.method_10093(dir);
        class_2680 blockstate = world.method_8320(blockpos);
        if (canClimbUp && (flag = this.canSurviveOn(world, blockpos, blockstate)) && this.canConnectTo(world.method_8320(blockpos.method_10084()), world, blockpos.method_10084(), null)) {
            if (blockstate.method_26206(world, blockpos, dir.method_10153())) {
                return class_2773.field_12686;
            }
            return class_2773.field_12689;
        }
        return !this.canConnectTo(blockstate, world, blockpos, dir) && (blockstate.method_26212(world, blockpos) || !this.canConnectTo(world.method_8320(blockpos.method_10074()), world, blockpos.method_10074(), null)) ? class_2773.field_12687 : class_2773.field_12689;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_2680 blockstate = world.method_8320(blockpos);
        return this.canSurviveOn((class_1922)world, blockpos, blockstate);
    }

    private boolean canSurviveOn(class_1922 world, class_2338 pos, class_2680 state) {
        return state.method_26206(world, pos, class_2350.field_11036) || state.method_27852(class_2246.field_10312);
    }

    protected boolean canConnectTo(class_2680 state, class_1922 world, class_2338 pos, @Nullable class_2350 dir) {
        class_2248 b = state.method_26204();
        return b instanceof ILightable || b instanceof class_2530 || b instanceof class_3922 || b instanceof class_5540 || CompatHandler.DECO_BLOCKS && DecoBlocksCompat.isBrazier(b);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((class_2773)state.method_11654(SOUTH)))).method_11657(EAST, (Comparable)((class_2773)state.method_11654(WEST)))).method_11657(SOUTH, (Comparable)((class_2773)state.method_11654(NORTH)))).method_11657(WEST, (Comparable)((class_2773)state.method_11654(EAST)));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((class_2773)state.method_11654(EAST)))).method_11657(EAST, (Comparable)((class_2773)state.method_11654(SOUTH)))).method_11657(SOUTH, (Comparable)((class_2773)state.method_11654(WEST)))).method_11657(WEST, (Comparable)((class_2773)state.method_11654(NORTH)));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((class_2773)state.method_11654(WEST)))).method_11657(EAST, (Comparable)((class_2773)state.method_11654(NORTH)))).method_11657(SOUTH, (Comparable)((class_2773)state.method_11654(EAST)))).method_11657(WEST, (Comparable)((class_2773)state.method_11654(SOUTH)));
            default -> state;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((class_2773)state.method_11654(SOUTH)))).method_11657(SOUTH, (Comparable)((class_2773)state.method_11654(NORTH)));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657(EAST, (Comparable)((class_2773)state.method_11654(WEST)))).method_11657(WEST, (Comparable)((class_2773)state.method_11654(EAST)));
            default -> super.method_9569(state, mirror);
        };
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moving) {
        if (!oldState.method_27852(state.method_26204()) && !world.field_9236) {
            world.method_39279(pos, (class_2248)this, GunpowderBlock.getDelay());
            for (class_2350 direction : class_2350.class_2353.field_11064) {
                world.method_8452(pos.method_10093(direction), (class_2248)this);
            }
            this.updateNeighborsOfNeighboringWires(world, pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!isMoving && !state.method_27852(newState.method_26204())) {
            super.method_9536(state, world, pos, newState, isMoving);
            if (!world.field_9236) {
                for (class_2350 direction : class_2350.values()) {
                    world.method_8452(pos.method_10093(direction), (class_2248)this);
                }
                this.updateNeighborsOfNeighboringWires(world, pos);
            }
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean moving) {
        super.method_9612(state, world, pos, neighborBlock, neighborPos, moving);
        if (!world.field_9236) {
            world.method_39279(pos, (class_2248)this, GunpowderBlock.getDelay());
        }
    }

    private void updateNeighborsOfNeighboringWires(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            this.checkCornerChangeAt(world, pos.method_10093(direction));
        }
        for (class_2350 direction1 : class_2350.class_2353.field_11062) {
            class_2338 blockpos = pos.method_10093(direction1);
            if (world.method_8320(blockpos).method_26212((class_1922)world, blockpos)) {
                this.checkCornerChangeAt(world, blockpos.method_10084());
                continue;
            }
            this.checkCornerChangeAt(world, blockpos.method_10074());
        }
    }

    private void checkCornerChangeAt(class_1937 world, class_2338 pos) {
        if (world.method_8320(pos).method_27852((class_2248)this)) {
            world.method_8452(pos, (class_2248)this);
            for (class_2350 direction : class_2350.values()) {
                world.method_8452(pos.method_10093(direction), (class_2248)this);
            }
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 lightUp = super.method_9534(state, world, pos, player, hand, hit);
        if (lightUp.method_23665()) {
            return lightUp;
        }
        if (Utils.mayBuild((class_1657)player, (class_2338)pos) && (GunpowderBlock.isCross(state) || GunpowderBlock.isDot(state))) {
            class_2680 blockstate = GunpowderBlock.isCross(state) ? this.method_9564() : this.crossState;
            blockstate = (class_2680)blockstate.method_11657((class_2769)BURNING, (Comparable)((Integer)state.method_11654((class_2769)BURNING)));
            if ((blockstate = this.getConnectionState((class_1922)world, blockstate, pos)) != state) {
                world.method_8652(pos, blockstate, 3);
                this.updatesOnShapeChange(world, pos, state, blockstate);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private void updatesOnShapeChange(class_1937 world, class_2338 pos, class_2680 state, class_2680 newState) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 blockpos = pos.method_10093(direction);
            if (((class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).method_27855() == ((class_2773)newState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).method_27855() || !world.method_8320(blockpos).method_26212((class_1922)world, blockpos)) continue;
            world.method_8508(blockpos, newState.method_26204(), direction.method_10153());
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int burning = (Integer)state.method_11654((class_2769)BURNING);
        if (!world.field_9236) {
            if (burning == 8) {
                world.method_8650(pos, false);
                GunpowderBlock.createMiniExplosion((class_1937)world, pos, false);
            } else if (burning > 0) {
                if (burning >= GunpowderBlock.getSpreadAge()) {
                    this.lightUpNeighbouringWires(pos, state, (class_1937)world);
                }
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)BURNING, (Comparable)Integer.valueOf(burning + 1)));
                world.method_39279(pos, (class_2248)this, GunpowderBlock.getDelay());
            } else {
                for (class_2350 dir : class_2350.values()) {
                    class_2338 p = pos.method_10093(dir);
                    if (!this.isFireSource((class_1936)world, p)) continue;
                    this.lightUp(null, state, pos, (class_1936)world, ILightable.FireSourceType.FLAMING_ARROW);
                    world.method_39279(pos, (class_2248)this, GunpowderBlock.getDelay());
                    break;
                }
            }
        }
    }

    public static void createMiniExplosion(class_1937 world, class_2338 pos, boolean alwaysFire) {
        GunpowderExplosion explosion = new GunpowderExplosion(world, null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 0.5f);
        if (ForgeHelper.onExplosionStart((class_1937)world, (class_1927)explosion)) {
            return;
        }
        explosion.method_8348();
        explosion.method_8350(alwaysFire);
    }

    public boolean lightUp(class_1297 entity, class_2680 state, class_2338 pos, class_1936 world, ILightable.FireSourceType fireSourceType) {
        boolean ret = super.lightUp(entity, state, pos, world, fireSourceType);
        if (ret) {
            if (!world.method_8608()) {
                ((class_1937)world).method_8427(pos, (class_2248)this, 0, 0);
            }
            world.method_39279(pos, (class_2248)this, GunpowderBlock.getDelay());
        }
        return ret;
    }

    private void lightUpByWire(class_2680 state, class_2338 pos, class_1936 world) {
        if (!this.isLitUp(state)) {
            if (!world.method_8608()) {
                ((class_1937)world).method_8427(pos, (class_2248)this, 0, 0);
            }
            world.method_8652(pos, this.toggleLitState(state, true), 11);
            world.method_8396(null, pos, ModSounds.GUNPOWDER_IGNITE.get(), class_3419.field_15245, 2.0f, 1.9f + world.method_8409().method_43057() * 0.1f);
        }
    }

    protected void lightUpNeighbouringWires(class_2338 pos, class_2680 state, class_1937 world) {
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2680 neighbourState;
            class_2338 p;
            class_2773 side = (class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(dir));
            if (side == class_2773.field_12686) {
                p = pos.method_10093(dir).method_10084();
                neighbourState = world.method_8320(p);
            } else {
                if (side != class_2773.field_12689) continue;
                p = pos.method_10093(dir);
                neighbourState = world.method_8320(p);
                if (!neighbourState.method_27852((class_2248)this) && !neighbourState.method_26212((class_1922)world, pos)) {
                    p = p.method_10074();
                    neighbourState = world.method_8320(p);
                }
            }
            if (!neighbourState.method_27852((class_2248)this)) continue;
            world.method_39279(p, (class_2248)this, Math.max(GunpowderBlock.getDelay() - 1, 1));
            this.lightUpByWire(neighbourState, p, (class_1936)world);
        }
    }

    private boolean isFireSource(class_1936 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2248 b = state.method_26204();
        if (b instanceof class_2358 || b instanceof class_2413 || b instanceof class_2527 && !(b instanceof class_2459) || b == ModRegistry.BLAZE_ROD_BLOCK.get()) {
            return true;
        }
        if (b instanceof class_3922 || CompatHandler.DECO_BLOCKS && DecoBlocksCompat.isBrazier(b)) {
            return (Boolean)state.method_11654((class_2769)class_3922.field_17352);
        }
        return world.method_8316(pos).method_15772() == class_3612.field_15908;
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float height) {
        super.method_9554(world, state, pos, entity, height);
        if (height > 1.0f) {
            this.extinguish(entity, world.method_8320(pos), pos, (class_1936)world);
        }
    }

    @Override
    public boolean isLitUp(class_2680 state) {
        return (Integer)state.method_11654((class_2769)BURNING) != 0;
    }

    @Override
    public class_2680 toggleLitState(class_2680 state, boolean lit) {
        return (class_2680)state.method_11657((class_2769)BURNING, (Comparable)Integer.valueOf(lit ? 1 : 0));
    }

    public boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int eventID, int eventParam) {
        if (eventID == 0) {
            this.method_9496((class_2680)state.method_11657((class_2769)BURNING, (Comparable)Integer.valueOf(1)), world, pos, world.field_9229);
            return true;
        }
        return super.method_9592(state, world, pos, eventID, eventParam);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        int i = (Integer)state.method_11654((class_2769)BURNING);
        if (i != 0) {
            block4: for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2773 redstoneside = (class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneside) {
                    case field_12686: {
                        this.spawnParticlesAlongLine(world, random, pos, i, direction, class_2350.field_11036, -0.5f, 0.5f);
                    }
                    case field_12689: {
                        this.spawnParticlesAlongLine(world, random, pos, i, class_2350.field_11033, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(world, random, pos, i, class_2350.field_11033, direction, 0.0f, 0.3f);
            }
        }
    }

    private void spawnParticlesAlongLine(class_1937 world, class_5819 rand, class_2338 pos, int burning, class_2350 dir1, class_2350 dir2, float from, float to) {
        float f = to - from;
        float in = (7.5f - (float)(burning - 1)) / 7.5f;
        if (rand.method_43057() < 1.0f * f * in) {
            float f2 = from + f * rand.method_43057();
            double x = (double)pos.method_10263() + 0.5 + (double)(0.4375f * (float)dir1.method_10148()) + (double)(f2 * (float)dir2.method_10148());
            double y = (double)pos.method_10264() + 0.5 + (double)(0.4375f * (float)dir1.method_10164()) + (double)(f2 * (float)dir2.method_10164());
            double z = (double)pos.method_10260() + 0.5 + (double)(0.4375f * (float)dir1.method_10165()) + (double)(f2 * (float)dir2.method_10165());
            float velY = (float)burning / 15.0f * 0.03f;
            float velX = rand.method_43057() * 0.02f - 0.01f;
            float velZ = rand.method_43057() * 0.02f - 0.01f;
            world.method_8406((class_2394)class_2398.field_11240, x, y, z, (double)velX, (double)velY, (double)velZ);
            world.method_8406((class_2394)class_2398.field_11237, x, y, z, (double)velX, (double)velY, (double)velZ);
        }
    }
}

