/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeData;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_638;

public class GlobeManager {
    private static final Map<String, TextureInstance> TEXTURE_CACHE = Maps.newHashMap();
    private static final HashMap<class_2960, List<Integer>> DIMENSION_COLOR_MAP = new HashMap();
    private static final List<Integer> SEPIA_COLORS = new ArrayList<Integer>();

    public static void refreshTextures() {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            GlobeManager.getTextureInstance((class_1937)world, false).updateTexture((class_1937)world);
        }
    }

    public static class_1921 getRenderType(class_1937 world, boolean sepia) {
        return GlobeManager.getTextureInstance((class_1937)world, (boolean)sepia).renderType;
    }

    private static TextureInstance getTextureInstance(class_1937 world, boolean sepia) {
        return TEXTURE_CACHE.computeIfAbsent(GlobeManager.getTextureId(world, sepia), i -> new TextureInstance(world, sepia));
    }

    private static String getTextureId(class_1937 level, boolean sepia) {
        Object id = level.method_27983().method_29177().method_12832();
        if (sepia) {
            id = (String)id + "_sepia";
        }
        return id;
    }

    public static void refreshColorsAndTextures(class_3300 manager) {
        DIMENSION_COLOR_MAP.clear();
        int targetColors = 13;
        for (class_2960 res : manager.method_14488("textures/entity/globes/palettes", r -> r.method_12832().endsWith(".png")).keySet()) {
            List l = SpriteUtils.parsePaletteStrip((class_3300)manager, (class_2960)res, (int)targetColors);
            String name = res.method_12832();
            if ((name = name.substring(name.lastIndexOf("/") + 1).replace(".png", "")).equals("sepia")) {
                SEPIA_COLORS.clear();
                SEPIA_COLORS.addAll(l);
                continue;
            }
            DIMENSION_COLOR_MAP.put(new class_2960(name.replace(".", ":")), l);
        }
        if (DIMENSION_COLOR_MAP.isEmpty()) {
            Supplementaries.LOGGER.error("Could not find any globe palette in textures/entity/globes/palettes");
        }
        GlobeManager.refreshTextures();
    }

    private static class TextureInstance
    implements AutoCloseable {
        private final class_2960 textureLocation;
        private final class_1043 texture;
        private final class_1921 renderType;
        private final class_2960 dimensionId;
        private final boolean sepia;

        private TextureInstance(class_1937 world, boolean sepia) {
            this.sepia = sepia;
            this.dimensionId = world.method_27983().method_29177();
            this.texture = new class_1043(32, 16, false);
            this.updateTexture(world);
            this.textureLocation = class_310.method_1551().method_1531().method_4617("globe/" + this.dimensionId.toString().replace(":", "_"), this.texture);
            this.renderType = class_1921.method_23572((class_2960)this.textureLocation);
        }

        private void updateTexture(class_1937 world) {
            GlobeData data = GlobeData.get(world);
            if (data == null) {
                return;
            }
            byte[][] pixels = data.globePixels;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.texture.method_4525().method_4305(j, i, -13061505);
                }
            }
            for (int y = 0; y < pixels.length; ++y) {
                for (int x = 0; x < pixels[y].length; ++x) {
                    this.texture.method_4525().method_4305(y, x, TextureInstance.getRGBA(pixels[y][x], this.dimensionId, this.sepia));
                }
            }
            this.texture.method_4524();
        }

        @Override
        public void close() {
            this.texture.close();
            class_310.method_1551().method_1531().method_4615(this.textureLocation);
        }

        private static int getRGBA(byte b, class_2960 dimension, boolean sepia) {
            if (sepia) {
                return SEPIA_COLORS.get(b);
            }
            List<Integer> l = DIMENSION_COLOR_MAP.getOrDefault(dimension, DIMENSION_COLOR_MAP.get(new class_2960("overworld")));
            if (l != null) {
                return l.get(b);
            }
            return 1;
        }
    }
}

