/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.remap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.betterfabricconsole.remap.MappingsCache;
import xyz.jpenilla.betterfabricconsole.remap.Remapper;
import xyz.jpenilla.betterfabricconsole.util.StringPool;
import xyz.jpenilla.betterfabricconsole.util.ThrowingConsumer;
import xyz.jpenilla.betterfabricconsole.util.Util;

@DefaultQualifier(value=NonNull.class)
record RemapperImpl(Map<String, String> classes, Map<String, String> methods) implements Remapper
{
    @Override
    public void remapThrowable(Throwable throwable) {
        throwable.setStackTrace(this.remapStacktrace(throwable.getStackTrace()));
        Throwable cause = throwable.getCause();
        if (cause != null) {
            this.remapThrowable(cause);
        }
        for (Throwable suppressed : throwable.getSuppressed()) {
            this.remapThrowable(suppressed);
        }
    }

    @Override
    public StackTraceElement[] remapStacktrace(StackTraceElement[] trace) {
        StackTraceElement[] newTrace = new StackTraceElement[trace.length];
        for (int i = 0; i < trace.length; ++i) {
            String mapped;
            StackTraceElement old = trace[i];
            @Nullable String sourceFile = old.getFileName();
            Object newSourceFile = sourceFile == null ? null : ((mapped = this.classes.get("net.minecraft." + sourceFile.replace(".java", ""))) == null ? sourceFile : mapped.substring(mapped.lastIndexOf(46) + 1) + ".java");
            newTrace[i] = new StackTraceElement(old.getClassLoaderName(), old.getModuleName(), old.getModuleVersion(), this.classes.getOrDefault(old.getClassName(), old.getClassName()), this.methods.getOrDefault(old.getMethodName(), old.getMethodName()), (String)newSourceFile, old.getLineNumber());
        }
        return newTrace;
    }

    @Override
    public String remapClassName(String name) {
        return this.classes.getOrDefault(name, name);
    }

    static Remapper create(String toNamespace, ThrowingConsumer<MemoryMappingTree, IOException> populator, Path serializedMappings) throws IOException {
        RemapperImpl remapper;
        long start = System.currentTimeMillis();
        if (Files.isRegularFile(serializedMappings, new LinkOption[0])) {
            LOGGER.info("Reading mappings...");
            try (BufferedReader reader = Util.gzipBufferedReader(serializedMappings);){
                SerializedMappings deserialized = (SerializedMappings)Util.GSON.fromJson((Reader)reader, SerializedMappings.class);
                HashMap<String, String> classMap = new HashMap<String, String>();
                HashMap<String, String> methodMap = new HashMap<String, String>();
                StringPool pool = new StringPool(new HashMap<String, String>());
                deserialized.classMap.forEach((k, v) -> classMap.put(pool.string((String)k), pool.string((String)v)));
                deserialized.methodMap.forEach((k, v) -> methodMap.put(pool.string((String)k), pool.string((String)v)));
                remapper = new RemapperImpl(classMap, methodMap);
            }
        }
        LOGGER.info("Reading mappings (building cache, subsequent runs will be faster)...");
        remapper = RemapperImpl.fromMappingTree(toNamespace, populator);
        SerializedMappings serialized = new SerializedMappings(remapper.classes, remapper.methods);
        try (BufferedWriter bufferedWriter = Util.gzipBufferedWriter(serializedMappings);){
            Util.GSON.toJson((Object)serialized, (Appendable)bufferedWriter);
        }
        LOGGER.info("Done in {} seconds.", (Object)MappingsCache.DECIMAL_FORMAT.format((double)(System.currentTimeMillis() - start) / 1000.0));
        return remapper;
    }

    private static RemapperImpl fromMappingTree(String toNamespace, ThrowingConsumer<MemoryMappingTree, IOException> populator) throws IOException {
        MemoryMappingTree tree = new MemoryMappingTree();
        populator.accept(tree);
        StringPool stringPool = new StringPool(new HashMap<String, String>());
        HashMap<String, String> classMapBuilder = new HashMap<String, String>();
        HashMap<String, String> methodMapBuilder = new HashMap<String, String>();
        for (MappingTree.ClassMapping clazz : tree.getClasses()) {
            @Nullable String icName = clazz.getName("intermediary");
            @Nullable String cName = clazz.getName(toNamespace);
            if (icName != null && cName != null) {
                classMapBuilder.put(RemapperImpl.slashToDot(icName), RemapperImpl.slashToDot(cName));
            }
            for (MappingTree.MethodMapping method : clazz.getMethods()) {
                @Nullable String imName = method.getName("intermediary");
                @Nullable String mName = method.getName(toNamespace);
                if (imName == null || mName == null) continue;
                methodMapBuilder.put(imName, stringPool.string(mName));
            }
        }
        return new RemapperImpl(Map.copyOf(classMapBuilder), Map.copyOf(methodMapBuilder));
    }

    private static String slashToDot(String slahsed) {
        return slahsed.replace("/", ".");
    }

    private record SerializedMappings(Map<String, String> classMap, Map<String, String> methodMap) {
    }
}

