/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.remap;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.betterfabricconsole.remap.MappingsCache;
import xyz.jpenilla.betterfabricconsole.remap.MappingsDownloader;
import xyz.jpenilla.betterfabricconsole.util.Util;

@DefaultQualifier(value=NonNull.class)
final class MojangMappingsDownloader
implements MappingsDownloader<MojangMappingsData> {
    private static final String MC_MANIFEST_PATH = "data/mc-manifest.json.gz";
    private static final String MC_VERSION_MANIFEST_PATH = "data/mc-version-" + MappingsCache.MINECRAFT_VERSION + ".json";
    private static final String MOJANG_MAPPINGS_PATH = "mappings/mojang";
    private static final String MOJANG_SERVER_MAPPINGS_PATH = "mappings/mojang/" + MappingsCache.MINECRAFT_VERSION + "-server.txt.gz";
    private static final String MOJANG_CLIENT_MAPPINGS_PATH = "mappings/mojang/" + MappingsCache.MINECRAFT_VERSION + "-client.txt.gz";
    private static final String SERIALIZED_MAPPINGS_PATH = "mappings/mojang/" + MappingsCache.MINECRAFT_VERSION + "-serialized.json.gz";
    private static final String INTERMEDIARY_MAPPINGS_PATH = "mappings/intermediary/" + MappingsCache.MINECRAFT_VERSION + ".jar";
    private static final String INTERMEDIARY_URL = "https://maven.fabricmc.net/net/fabricmc/intermediary/{}/intermediary-{}-v2.jar";
    private static final String MC_MANIFEST_URL = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";
    private final Path cache;

    MojangMappingsDownloader(MappingsCache cache) {
        this.cache = cache.cache;
    }

    private McManifestResult mcManifest(boolean forceDownload) throws IOException {
        JsonObject mcManifest;
        boolean download;
        Path mcManifestPath = this.cache.resolve(MC_MANIFEST_PATH);
        boolean bl = download = forceDownload || !Files.exists(mcManifestPath, new LinkOption[0]);
        if (download) {
            MappingsCache.downloadFileAndGzip(MC_MANIFEST_URL, mcManifestPath);
        }
        try (BufferedReader reader = Util.gzipBufferedReader(mcManifestPath);){
            mcManifest = (JsonObject)Util.GSON.fromJson((Reader)reader, JsonObject.class);
        }
        return new McManifestResult(download, mcManifest);
    }

    @Override
    public MojangMappingsData downloadMappings() throws IOException {
        Path intermediaryMappings;
        Path clientMappings;
        Path mcVersionManifestPath = this.cache.resolve(MC_VERSION_MANIFEST_PATH);
        if (!Files.exists(mcVersionManifestPath, new LinkOption[0])) {
            McManifestResult mcManifest = this.mcManifest(false);
            @Nullable String versionManifestUrl = MojangMappingsDownloader.findVersionManifestUrl(MappingsCache.MINECRAFT_VERSION, mcManifest.result());
            if (versionManifestUrl == null && !mcManifest.didDownload()) {
                mcManifest = this.mcManifest(true);
                versionManifestUrl = MojangMappingsDownloader.findVersionManifestUrl(MappingsCache.MINECRAFT_VERSION, mcManifest.result());
            }
            if (versionManifestUrl == null) {
                throw new IllegalArgumentException("Could not find version manifest for Minecraft version '" + MappingsCache.MINECRAFT_VERSION + "' in Minecraft manifest.");
            }
            MappingsCache.downloadFile(versionManifestUrl, mcVersionManifestPath);
        }
        Supplier downloads = Suppliers.memoize(() -> {
            JsonObject mcVersionManifest;
            try (BufferedReader reader = Files.newBufferedReader(mcVersionManifestPath);){
                mcVersionManifest = (JsonObject)Util.GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (IOException e) {
                throw Util.rethrow(e);
            }
            return mcVersionManifest.get("downloads").getAsJsonObject();
        });
        Path serverMappings = this.serverMappings();
        if (!Files.exists(serverMappings, new LinkOption[0])) {
            String serverMappingsUrl = ((JsonObject)downloads.get()).get("server_mappings").getAsJsonObject().get("url").getAsString();
            MappingsCache.downloadFileAndGzip(serverMappingsUrl, serverMappings);
        }
        if (!Files.exists(clientMappings = this.clientMappings(), new LinkOption[0])) {
            String clientMappingsUrl = ((JsonObject)downloads.get()).get("client_mappings").getAsJsonObject().get("url").getAsString();
            MappingsCache.downloadFileAndGzip(clientMappingsUrl, clientMappings);
        }
        if (!Files.exists(intermediaryMappings = this.intermediaryMappingsJar(), new LinkOption[0])) {
            MappingsCache.downloadFile(INTERMEDIARY_URL.replace("{}", MappingsCache.MINECRAFT_VERSION), intermediaryMappings);
        }
        return new MojangMappingsData(this.serverMappings(), this.clientMappings(), this.intermediaryMappingsJar(), this.serializedMappings());
    }

    private Path serverMappings() {
        return this.cache.resolve(MOJANG_SERVER_MAPPINGS_PATH);
    }

    private Path clientMappings() {
        return this.cache.resolve(MOJANG_CLIENT_MAPPINGS_PATH);
    }

    private Path serializedMappings() {
        return this.cache.resolve(SERIALIZED_MAPPINGS_PATH);
    }

    private Path intermediaryMappingsJar() {
        return this.cache.resolve(INTERMEDIARY_MAPPINGS_PATH);
    }

    private static @Nullable String findVersionManifestUrl(String minecraftVersion, JsonObject mcManifest) {
        return StreamSupport.stream(mcManifest.get("versions").getAsJsonArray().spliterator(), false).filter(version -> version.getAsJsonObject().get("id").getAsString().equals(minecraftVersion)).findFirst().map(v -> v.getAsJsonObject().get("url").getAsString()).orElse(null);
    }

    private record McManifestResult(boolean didDownload, JsonObject result) {
    }

    public record MojangMappingsData(Path serverMappings, Path clientMappings, Path intermediaryMappingsJar, Path serialized) {
    }
}

