/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.console;

import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.jline.reader.LineReader;

@DefaultQualifier(value=NonNull.class)
final class ConsoleAppender
extends AbstractAppender {
    private final LineReader lineReader;
    private final @Nullable RewritePolicy rewriter;

    ConsoleAppender(LineReader lineReader, String logPattern, @Nullable RewritePolicy rewritePolicy) {
        super("Console", null, (Layout)PatternLayout.newBuilder().withPattern(logPattern).build(), false, new Property[0]);
        this.lineReader = lineReader;
        this.rewriter = rewritePolicy;
    }

    private LogEvent rewrite(LogEvent event) {
        return this.rewriter == null ? event : this.rewriter.rewrite(event);
    }

    public void append(LogEvent event) {
        if (this.lineReader.isReading()) {
            this.lineReader.callWidget("clear");
        }
        this.lineReader.getTerminal().writer().print(this.getLayout().toSerializable(this.rewrite(event)).toString());
        if (this.lineReader.isReading()) {
            this.lineReader.callWidget("redraw-line");
            this.lineReader.callWidget("redisplay");
        }
        this.lineReader.getTerminal().writer().flush();
    }
}

