/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.console;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.ansi.ColorLevel;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="paperMinecraftFormatting", category="Converter")
@ConverterKeys(value={"paperMinecraftFormatting"})
@PerformanceSensitive(value={"allocation"})
public final class HexFormattingConverter
extends LogEventPatternConverter {
    public static final String KEEP_FORMATTING_PROPERTY = "terminal.keepMinecraftFormatting";
    private static final boolean KEEP_FORMATTING = PropertiesUtil.getProperties().getBooleanProperty("terminal.keepMinecraftFormatting");
    private static final String ANSI_RESET = "\u001b[m";
    private static final char COLOR_CHAR = '\u00a7';
    private static final String LOOKUP = "0123456789abcdefklmnor";
    private static final String RGB_ANSI = "\u001b[38;2;%d;%d;%dm";
    private static final String RESET_RGB_ANSI = "\u001b[m\u001b[38;2;%d;%d;%dm";
    private static final Pattern NAMED_PATTERN = Pattern.compile("\u00a7[0-9a-fk-orA-FK-OR]");
    private static final Pattern RGB_PATTERN = Pattern.compile("\u00a7#([0-9a-fA-F]){6}");
    private static final String[] RGB_ANSI_CODES = new String[]{HexFormattingConverter.formatHexAnsi(NamedTextColor.BLACK.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_BLUE.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_GREEN.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_AQUA.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_RED.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_PURPLE.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.GOLD.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.GRAY.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.DARK_GRAY.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.BLUE.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.GREEN.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.AQUA.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.RED.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.LIGHT_PURPLE.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.YELLOW.value()), HexFormattingConverter.formatHexAnsi(NamedTextColor.WHITE.value()), "\u001b[5m", "\u001b[1m", "\u001b[9m", "\u001b[4m", "\u001b[3m", "\u001b[m"};
    private static final String[] ANSI_ANSI_CODES = new String[]{"\u001b[m\u001b[0;30m", "\u001b[m\u001b[0;34m", "\u001b[m\u001b[0;32m", "\u001b[m\u001b[0;36m", "\u001b[m\u001b[0;31m", "\u001b[m\u001b[0;35m", "\u001b[m\u001b[0;33m", "\u001b[m\u001b[0;37m", "\u001b[m\u001b[0;30;1m", "\u001b[m\u001b[0;34;1m", "\u001b[m\u001b[0;32;1m", "\u001b[m\u001b[0;36;1m", "\u001b[m\u001b[0;31;1m", "\u001b[m\u001b[0;35;1m", "\u001b[m\u001b[0;33;1m", "\u001b[m\u001b[0;37;1m", "\u001b[5m", "\u001b[1m", "\u001b[9m", "\u001b[4m", "\u001b[3m", "\u001b[m"};
    private final boolean ansi;
    private final List<PatternFormatter> formatters;

    protected HexFormattingConverter(List<PatternFormatter> formatters, boolean strip) {
        super("paperMinecraftFormatting", null);
        this.formatters = formatters;
        this.ansi = !strip;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        int size = this.formatters.size();
        for (int i = 0; i < size; ++i) {
            this.formatters.get(i).format(event, toAppendTo);
        }
        if (KEEP_FORMATTING || toAppendTo.length() == start) {
            return;
        }
        boolean useAnsi = this.ansi && ColorLevel.compute() != ColorLevel.NONE;
        String content = toAppendTo.substring(start);
        content = useAnsi ? HexFormattingConverter.convertRGBColors(content) : HexFormattingConverter.stripRGBColors(content);
        HexFormattingConverter.format(content, toAppendTo, start, useAnsi);
    }

    private static String convertRGBColors(String input) {
        return RGB_PATTERN.matcher(input).replaceAll(result -> {
            int hex = Integer.decode(result.group().substring(1));
            return HexFormattingConverter.formatHexAnsi(hex);
        });
    }

    private static String formatHexAnsi(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return String.format(RESET_RGB_ANSI, red, green, blue);
    }

    private static String stripRGBColors(String input) {
        return RGB_PATTERN.matcher(input).replaceAll("");
    }

    static void format(String content, StringBuilder result, int start, boolean ansi) {
        int next = content.indexOf(167);
        int last = content.length() - 1;
        if (next == -1 || next == last) {
            result.setLength(start);
            result.append(content);
            if (ansi) {
                result.append(ANSI_RESET);
            }
            return;
        }
        Matcher matcher = NAMED_PATTERN.matcher(content);
        StringBuilder buffer = new StringBuilder();
        String[] ansiCodes = HexFormattingConverter.ansiCodes();
        while (matcher.find()) {
            int format = LOOKUP.indexOf(Character.toLowerCase(matcher.group().charAt(1)));
            if (format == -1) continue;
            matcher.appendReplacement(buffer, ansi ? ansiCodes[format] : "");
        }
        matcher.appendTail(buffer);
        result.setLength(start);
        result.append((CharSequence)buffer);
        if (ansi) {
            result.append(ANSI_RESET);
        }
    }

    private static String[] ansiCodes() {
        boolean rgb = ColorLevel.compute() == ColorLevel.TRUE_COLOR;
        return rgb ? RGB_ANSI_CODES : ANSI_ANSI_CODES;
    }

    public static HexFormattingConverter newInstance(Configuration config, String[] options) {
        if (options.length < 1 || options.length > 2) {
            LOGGER.error("Incorrect number of options on paperMinecraftFormatting. Expected at least 1, max 2 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on paperMinecraftFormatting");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser((Configuration)config);
        List formatters = parser.parse(options[0]);
        boolean strip = options.length > 1 && "strip".equals(options[1]);
        return new HexFormattingConverter(formatters, strip);
    }
}

