/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_8685;

public class PlayerVolumeEntry
extends VolumeEntry {
    @Nullable
    protected final PlayerState state;

    public PlayerVolumeEntry(@Nullable PlayerState state, AdjustVolumesScreen screen) {
        super(screen, new PlayerVolumeConfigEntry(state != null ? state.getUuid() : class_156.field_25140));
        this.state = state;
    }

    @Nullable
    public PlayerState getState() {
        return this.state;
    }

    @Override
    public void renderElement(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        if (this.state != null) {
            class_8685 skin = GameProfileUtils.getSkin(this.state.getUuid());
            guiGraphics.method_25302(class_1921::method_62277, skin.comp_1626(), skinX, skinY, 8.0f, 8.0f, 24, 24, 8, 8, 64, 64);
            RenderSystem.enableBlend();
            guiGraphics.method_25302(class_1921::method_62277, skin.comp_1626(), skinX, skinY, 40.0f, 8.0f, 24, 24, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            guiGraphics.method_51433(this.minecraft.field_1772, this.state.getName(), textX, textY, PLAYER_NAME_COLOR, false);
        } else {
            guiGraphics.method_25302(class_1921::method_62277, OTHER_VOLUME_ICON, skinX, skinY, 16.0f, 16.0f, 24, 24, 16, 16, 16, 16);
            guiGraphics.method_51439(this.minecraft.field_1772, OTHER_VOLUME, textX, textY, PLAYER_NAME_COLOR, false);
            if (hovered) {
                this.screen.postRender(() -> guiGraphics.method_51438(this.minecraft.field_1772, OTHER_VOLUME_DESCRIPTION, mouseX, mouseY));
            }
        }
    }

    public static class PlayerVolumeConfigEntry
    implements AdjustVolumeSlider.VolumeConfigEntry {
        private final UUID playerUUID;

        public PlayerVolumeConfigEntry(UUID playerUUID) {
            this.playerUUID = playerUUID;
        }

        @Override
        public void save(double value) {
            VoicechatClient.VOLUME_CONFIG.setPlayerVolume(this.playerUUID, value);
            VoicechatClient.VOLUME_CONFIG.save();
        }

        @Override
        public double get() {
            return VoicechatClient.VOLUME_CONFIG.getPlayerVolume(this.playerUUID);
        }
    }
}

