/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.tinyremapper.extension.mixin.soft.annotation;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.loader.impl.lib.tinyremapper.extension.mixin.common.data.CommonData;
import net.fabricmc.loader.impl.lib.tinyremapper.extension.mixin.soft.annotation.FirstPassAnnotationVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

public class MixinAnnotationVisitor
extends FirstPassAnnotationVisitor {
    private final CommonData data;
    private final AnnotationVisitor delegate;
    private final AtomicBoolean remap0;
    private final List<String> targets;

    public MixinAnnotationVisitor(CommonData data, AnnotationVisitor delegate, AtomicBoolean remapOut, List<String> targetsOut) {
        super("Lorg/spongepowered/asm/mixin/Mixin;", true);
        this.data = Objects.requireNonNull(data);
        this.delegate = Objects.requireNonNull(delegate);
        this.remap0 = Objects.requireNonNull(remapOut);
        this.targets = Objects.requireNonNull(targetsOut);
    }

    public void visitEnd() {
        this.remap0.set(this.remap);
        this.accept(new MixinSecondPassAnnotationVisitor(this.data, this.delegate, this.remap, this.targets));
        super.visitEnd();
    }

    private static class MixinSecondPassAnnotationVisitor
    extends AnnotationVisitor {
        private final CommonData data;
        private final boolean remap;
        private final List<String> targets;

        MixinSecondPassAnnotationVisitor(CommonData data, AnnotationVisitor delegate, boolean remap, List<String> targetsOut) {
            super(589824, delegate);
            this.data = Objects.requireNonNull(data);
            this.remap = remap;
            this.targets = Objects.requireNonNull(targetsOut);
        }

        public AnnotationVisitor visitArray(String name) {
            AnnotationVisitor visitor = super.visitArray(name);
            if (name.equals("targets")) {
                return new AnnotationVisitor(589824, visitor){

                    public void visit(String name, Object value) {
                        String srcName;
                        String dstName = srcName = ((String)value).replaceAll("\\s", "").replace('.', '/');
                        targets.add(srcName);
                        if (remap) {
                            dstName = ((MixinSecondPassAnnotationVisitor)this).data.mapper.asTrRemapper().map(srcName);
                        }
                        value = dstName;
                        super.visit(name, value);
                    }
                };
            }
            if (name.equals("value")) {
                return new AnnotationVisitor(589824, visitor){

                    public void visit(String name, Object value) {
                        Type srcType = Objects.requireNonNull((Type)value);
                        targets.add(srcType.getInternalName());
                        super.visit(name, value);
                    }
                };
            }
            return visitor;
        }
    }
}

