/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.logging.plugins;

import com.mojang.logging.LogListeners;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Listener", category="Core", elementType="appender", printObject=true)
public class ListenerLogAppender
extends AbstractAppender {
    private final LogListeners.Target output;

    public ListenerLogAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, LogListeners.Target output) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        this.output = output;
    }

    public void append(LogEvent event) {
        this.output.post((Layout<? extends Serializable>)this.getLayout(), event);
    }

    @PluginFactory
    @Nullable
    public static ListenerLogAppender createAppender(@PluginAttribute(value="name") @Nullable String name, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginElement(value="Layout") @Nullable Layout<? extends Serializable> layout, @PluginElement(value="Filters") Filter filter, @PluginAttribute(value="target") @Nullable String target) {
        boolean ignoreExceptions = Boolean.parseBoolean(ignore);
        if (name == null) {
            LOGGER.error("No name provided for ListenerLogAppender");
            return null;
        }
        LogListeners.Target output = LogListeners.getOrCreateTarget(Objects.requireNonNullElse(target, name));
        if (layout == null) {
            layout = PatternLayout.newBuilder().build();
        }
        return new ListenerLogAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, output);
    }
}

