/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.util.log;

import java.util.Arrays;
import java.util.IllegalFormatException;
import net.fabricmc.loader.impl.util.log.BuiltinLogHandler;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.loader.impl.util.log.LogHandler;
import net.fabricmc.loader.impl.util.log.LogLevel;

public final class Log {
    public static final String NAME = "FabricLoader";
    private static final boolean CHECK_FOR_BRACKETS = true;
    private static LogHandler handler = new BuiltinLogHandler();

    public static void init(LogHandler handler) {
        if (handler == null) {
            throw new NullPointerException("null log handler");
        }
        LogHandler oldHandler = Log.handler;
        if (oldHandler instanceof BuiltinLogHandler) {
            ((BuiltinLogHandler)oldHandler).replay(handler);
        }
        Log.handler = handler;
        oldHandler.close();
    }

    public static void configureBuiltin(boolean buffer, boolean output) {
        LogHandler handler = Log.handler;
        if (handler instanceof BuiltinLogHandler) {
            ((BuiltinLogHandler)handler).configure(buffer, output);
        }
    }

    public static void finishBuiltinConfig() {
        LogHandler handler = Log.handler;
        if (handler instanceof BuiltinLogHandler) {
            ((BuiltinLogHandler)handler).finishConfig();
        }
    }

    public static void error(LogCategory category, String format, Object ... args) {
        Log.logFormat(LogLevel.ERROR, category, format, args);
    }

    public static void error(LogCategory category, String msg) {
        Log.log(LogLevel.ERROR, category, msg);
    }

    public static void error(LogCategory category, String msg, Throwable exc) {
        Log.log(LogLevel.ERROR, category, msg, exc);
    }

    public static void warn(LogCategory category, String format, Object ... args) {
        Log.logFormat(LogLevel.WARN, category, format, args);
    }

    public static void warn(LogCategory category, String msg) {
        Log.log(LogLevel.WARN, category, msg);
    }

    public static void warn(LogCategory category, String msg, Throwable exc) {
        Log.log(LogLevel.WARN, category, msg, exc);
    }

    public static void info(LogCategory category, String format, Object ... args) {
        Log.logFormat(LogLevel.INFO, category, format, args);
    }

    public static void info(LogCategory category, String msg) {
        Log.log(LogLevel.INFO, category, msg);
    }

    public static void info(LogCategory category, String msg, Throwable exc) {
        Log.log(LogLevel.INFO, category, msg, exc);
    }

    public static void debug(LogCategory category, String format, Object ... args) {
        Log.logFormat(LogLevel.DEBUG, category, format, args);
    }

    public static void debug(LogCategory category, String msg) {
        Log.log(LogLevel.DEBUG, category, msg);
    }

    public static void debug(LogCategory category, String msg, Throwable exc) {
        Log.log(LogLevel.DEBUG, category, msg, exc);
    }

    public static void trace(LogCategory category, String format, Object ... args) {
        Log.logFormat(LogLevel.TRACE, category, format, args);
    }

    public static void trace(LogCategory category, String msg) {
        Log.log(LogLevel.TRACE, category, msg);
    }

    public static void trace(LogCategory category, String msg, Throwable exc) {
        Log.log(LogLevel.TRACE, category, msg, exc);
    }

    public static void log(LogLevel level, LogCategory category, String msg) {
        LogHandler handler = Log.handler;
        if (handler.shouldLog(level, category)) {
            Log.log(handler, level, category, msg, null);
        }
    }

    public static void log(LogLevel level, LogCategory category, String msg, Throwable exc) {
        LogHandler handler = Log.handler;
        if (handler.shouldLog(level, category)) {
            Log.log(handler, level, category, msg, exc);
        }
    }

    public static void logFormat(LogLevel level, LogCategory category, String format, Object ... args) {
        Throwable exc;
        String msg;
        LogHandler handler = Log.handler;
        if (!handler.shouldLog(level, category)) {
            return;
        }
        if (args.length == 0) {
            msg = format;
            exc = null;
        } else {
            Object[] newArgs;
            if (format.indexOf("{}") != -1) {
                throw new IllegalArgumentException("log message containing {}: " + format);
            }
            Object lastArg = args[args.length - 1];
            if (lastArg instanceof Throwable && Log.getRequiredArgs(format) < args.length) {
                exc = (Throwable)lastArg;
                newArgs = Arrays.copyOf(args, args.length - 1);
            } else {
                exc = null;
                newArgs = args;
            }
            assert (Log.getRequiredArgs(format) == newArgs.length);
            try {
                msg = String.format(format, newArgs);
            }
            catch (IllegalFormatException e) {
                msg = "Format error: fmt=[" + format + "] args=" + Arrays.toString(args);
                Log.warn(LogCategory.LOG, "Invalid format string.", e);
            }
        }
        Log.log(handler, level, category, msg, exc);
    }

    private static int getRequiredArgs(String format) {
        int ret = 0;
        int minRet = 0;
        boolean wasPct = false;
        int max = format.length();
        for (int i = 0; i < max; ++i) {
            char c = format.charAt(i);
            if (c == '%') {
                wasPct = !wasPct;
                continue;
            }
            if (!wasPct) continue;
            wasPct = false;
            if (c == 'n' || c == '<') continue;
            if (c >= '0' && c <= '9') {
                int start = i;
                while (i + 1 < format.length() && (c = format.charAt(i + 1)) >= '0' && c <= '9') {
                    ++i;
                }
                if (i + 1 < format.length() && format.charAt(i + 1) == '$') {
                    minRet = Math.max(minRet, Integer.parseInt(format.substring(start, ++i)) + 1);
                    continue;
                }
                i = start;
            }
            ++ret;
        }
        return Math.max(ret, minRet);
    }

    private static void log(LogHandler handler, LogLevel level, LogCategory category, String msg, Throwable exc) {
        handler.log(System.currentTimeMillis(), level, category, msg.trim(), exc, false, false);
    }

    public static boolean shouldLog(LogLevel level, LogCategory category) {
        return handler.shouldLog(level, category);
    }
}

