/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5253;

public class AudioDeviceEntry
extends ListScreenEntryBase<AudioDeviceEntry> {
    protected static final class_2960 SELECTED = class_2960.method_60655((String)"voicechat", (String)"textures/icons/device_selected.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = class_5253.class_5254.method_27764((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_HOVERED = class_5253.class_5254.method_27764((int)255, (int)90, (int)90, (int)90);
    protected static final int BG_FILL_SELECTED = class_5253.class_5254.method_27764((int)255, (int)40, (int)40, (int)40);
    protected static final int DEVICE_NAME_COLOR = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
    protected final class_310 minecraft;
    protected final String device;
    protected final String visibleDeviceName;
    @Nullable
    protected final class_2960 icon;
    protected final Supplier<Boolean> isSelected;

    public AudioDeviceEntry(String device, String name, @Nullable class_2960 icon, Supplier<Boolean> isSelected) {
        this.device = device;
        this.icon = icon;
        this.isSelected = isSelected;
        this.visibleDeviceName = name;
        this.minecraft = class_310.method_1551();
    }

    public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        boolean selected = this.isSelected.get();
        if (selected) {
            guiGraphics.method_25294(left, top, left + width, top + height, BG_FILL_SELECTED);
        } else if (hovered) {
            guiGraphics.method_25294(left, top, left + width, top + height, BG_FILL_HOVERED);
        } else {
            guiGraphics.method_25294(left, top, left + width, top + height, BG_FILL);
        }
        if (this.icon != null) {
            guiGraphics.method_25290(this.icon, left + 4, top + height / 2 - 8, 16.0f, 16.0f, 16, 16, 16, 16);
        }
        if (selected) {
            guiGraphics.method_25290(SELECTED, left + 4, top + height / 2 - 8, 16.0f, 16.0f, 16, 16, 16, 16);
        }
        float deviceWidth = this.minecraft.field_1772.method_1727(this.visibleDeviceName);
        float space = width - 4 - 16 - 4 - 4;
        float scale = Math.min(space / deviceWidth, 1.0f);
        guiGraphics.method_51448().method_22903();
        class_4587 class_45872 = guiGraphics.method_51448();
        double d = left + 4 + 16 + 4;
        float f = top + height / 2;
        Objects.requireNonNull(this.minecraft.field_1772);
        class_45872.method_22904(d, (double)(f - 9.0f * scale / 2.0f), 0.0);
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        guiGraphics.method_51433(this.minecraft.field_1772, this.visibleDeviceName, 0, 0, DEVICE_NAME_COLOR, false);
        guiGraphics.method_51448().method_22909();
    }

    public String getDevice() {
        return this.device;
    }
}

