/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.relocate.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.geysermc.relocate.jackson.core.JsonGenerator;
import org.geysermc.relocate.jackson.databind.JavaType;
import org.geysermc.relocate.jackson.databind.JsonMappingException;
import org.geysermc.relocate.jackson.databind.JsonNode;
import org.geysermc.relocate.jackson.databind.SerializerProvider;
import org.geysermc.relocate.jackson.databind.annotation.JacksonStdImpl;
import org.geysermc.relocate.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.geysermc.relocate.jackson.databind.jsontype.TypeSerializer;
import org.geysermc.relocate.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public final class StringSerializer
extends StdScalarSerializer<Object> {
    private static final long serialVersionUID = 1L;

    public StringSerializer() {
        super(String.class, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        String str = (String)value;
        return str.isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

