/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.relocate.jackson.databind.deser.std;

import org.geysermc.relocate.jackson.core.JsonLocation;
import org.geysermc.relocate.jackson.core.io.ContentReference;
import org.geysermc.relocate.jackson.databind.DeserializationConfig;
import org.geysermc.relocate.jackson.databind.DeserializationContext;
import org.geysermc.relocate.jackson.databind.JavaType;
import org.geysermc.relocate.jackson.databind.PropertyMetadata;
import org.geysermc.relocate.jackson.databind.PropertyName;
import org.geysermc.relocate.jackson.databind.deser.CreatorProperty;
import org.geysermc.relocate.jackson.databind.deser.SettableBeanProperty;
import org.geysermc.relocate.jackson.databind.deser.ValueInstantiator;

public class JsonLocationInstantiator
extends ValueInstantiator.Base {
    private static final long serialVersionUID = 1L;

    public JsonLocationInstantiator() {
        super(JsonLocation.class);
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return true;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        JavaType intType = config.constructType(Integer.TYPE);
        JavaType longType = config.constructType(Long.TYPE);
        return new SettableBeanProperty[]{JsonLocationInstantiator.creatorProp("sourceRef", config.constructType(Object.class), 0), JsonLocationInstantiator.creatorProp("byteOffset", longType, 1), JsonLocationInstantiator.creatorProp("charOffset", longType, 2), JsonLocationInstantiator.creatorProp("lineNr", intType, 3), JsonLocationInstantiator.creatorProp("columnNr", intType, 4)};
    }

    private static CreatorProperty creatorProp(String name, JavaType type, int index) {
        return CreatorProperty.construct(PropertyName.construct(name), type, null, null, null, null, index, null, PropertyMetadata.STD_REQUIRED);
    }

    @Override
    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) {
        ContentReference srcRef = ContentReference.rawReference(args[0]);
        return new JsonLocation(srcRef, JsonLocationInstantiator._long(args[1]), JsonLocationInstantiator._long(args[2]), JsonLocationInstantiator._int(args[3]), JsonLocationInstantiator._int(args[4]));
    }

    private static final long _long(Object o) {
        return o == null ? 0L : ((Number)o).longValue();
    }

    private static final int _int(Object o) {
        return o == null ? 0 : ((Number)o).intValue();
    }
}

