/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.FishingRodItem;
import org.geysermc.geyser.item.type.Item;

public class ItemUtils {
    public static int getEnchantmentLevel(@Nullable CompoundTag itemNBTData, String enchantmentId) {
        if (itemNBTData == null) {
            return 0;
        }
        ListTag enchantments = (ListTag)itemNBTData.get("Enchantments");
        if (enchantments != null) {
            for (Tag tag : enchantments) {
                Object object;
                Object lvl;
                CompoundTag enchantment = (CompoundTag)tag;
                StringTag enchantId = (StringTag)enchantment.get("id");
                if (!enchantId.getValue().equals(enchantmentId) || (lvl = enchantment.get("lvl")) == null || !((object = ((Tag)lvl).getValue()) instanceof Number)) continue;
                Number number = (Number)object;
                return number.intValue();
            }
        }
        return 0;
    }

    public static int getCorrectBedrockDurability(Item item, int original) {
        if (item == Items.FISHING_ROD) {
            return FishingRodItem.getBedrockDamage(original);
        }
        return original;
    }

    public static @Nullable String getCustomName(CompoundTag itemTag) {
        CompoundTag displayTag;
        Object t;
        Object t2;
        if (itemTag != null && (t2 = itemTag.get("display")) instanceof CompoundTag && (t = (displayTag = (CompoundTag)t2).get("Name")) instanceof StringTag) {
            StringTag nameTag = (StringTag)t;
            return nameTag.getValue();
        }
        return null;
    }
}

